/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.cache;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import net.babelsoft.negatron.io.cache.Cache;

public class IconCache
extends Cache<Data, Version> {
    public static final int WIDTH = 16;
    public static final int HEIGHT = 16;
    public static final int COLOURDEPTH = 4;
    private final Map<String, Image> data = new HashMap<String, Image>();

    protected IconCache() throws ClassNotFoundException, IOException {
        super("icon");
    }

    public String pathToKey(Path path) {
        String key = path.getFileName().toString();
        return key.substring(0, key.length() - 4);
    }

    @Override
    protected Version loadVersion() throws ClassNotFoundException, IOException {
        Version _version = null;
        try {
            _version = (Version)super.loadVersion();
        }
        catch (Exception ex) {
            Logger.getLogger(IconCache.class.getName()).log(Level.WARNING, null, ex);
        }
        if (_version == null) {
            _version = new Version();
        }
        return _version;
    }

    @Override
    public Data load() throws ClassNotFoundException, IOException {
        Data cache = null;
        try {
            cache = (Data)super.load();
        }
        catch (Exception ex) {
            Logger.getLogger(IconCache.class.getName()).log(Level.WARNING, null, ex);
        }
        if (cache != null) {
            cache.entrySet().stream().forEach(entry -> {
                WritableImage img = new WritableImage(16, 16);
                img.getPixelWriter().setPixels(0, 0, 16, 16, (PixelFormat)PixelFormat.getByteBgraInstance(), (byte[])entry.getValue(), 0, 64);
                this.data.put((String)entry.getKey(), (Image)img);
            });
        } else {
            ((Version)this.version).clear();
        }
        return cache;
    }

    public Set<String> getKeys() {
        return this.data.keySet();
    }

    public Instant getVersion(String name) {
        return (Instant)((Version)this.version).get(name);
    }

    public Image get(String name) {
        return this.data.get(name);
    }

    public void putVersion(String key, Instant timestamp) {
        ((Version)this.version).put(key, timestamp);
    }

    public void put(String key, Image image) {
        this.data.put(key, image);
    }

    public void remove(String key) {
        ((Version)this.version).remove(key);
        this.data.remove(key);
    }

    public void save() throws IOException {
        Data cache = new Data();
        this.data.entrySet().stream().forEach(entry -> {
            Image img = (Image)entry.getValue();
            PixelReader pixelReader = img.getPixelReader();
            byte[] buffer = new byte[1024];
            pixelReader.getPixels(0, 0, 16, 16, PixelFormat.getByteBgraInstance(), buffer, 0, 64);
            cache.put(entry.getKey(), buffer);
        });
        super.save(cache);
        this.saveVersion();
    }

    protected static class Data
    extends HashMap<String, byte[]> {
        static final long serialVersionUID = 1L;

        protected Data() {
        }
    }

    protected static class Version
    extends HashMap<String, Instant> {
        static final long serialVersionUID = 1L;

        protected Version() {
        }
    }
}

