/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.cache;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.babelsoft.negatron.io.cache.Cache;
import net.babelsoft.negatron.io.cache.IconCache;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.PathCharset;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.loader.InformationData;
import net.babelsoft.negatron.io.loader.InformationLoader;
import net.babelsoft.negatron.io.loader.InitialisedCallable;
import net.babelsoft.negatron.io.loader.ThreadedCacheLoader;

public class InformationCache
extends Cache<Data, Version>
implements ThreadedCacheLoader<InitialisedCallable<Void>> {
    private static final String SYSTEM_INDEX_FILE = "info.system.index";
    private static final String ITEM_INDEX_FILE = "info.item.index";
    private static SystemIndex systemIndex;
    private static ItemIndex itemIndex;
    private static Data data;
    private int processingFileCount;
    private AtomicInteger processedFileCount;

    public InformationCache() throws ClassNotFoundException, IOException {
        super("info");
    }

    public Map<String, String> get(String system, String item, String parentItem) {
        LinkedHashMap<String, String> sourceContent = new LinkedHashMap<String, String>();
        BiFunction<String, String, Boolean> retrieveContent = (source, target) -> {
            Optional<String> optionalContent;
            Map index;
            BooleanSupplier handleError = () -> {
                sourceContent.put((String)source, (String)null);
                return false;
            };
            if (data.get(source) == null) {
                return handleError.getAsBoolean();
            }
            List systemAliases = null;
            if (systemIndex != null && (index = (Map)systemIndex.get(source)) != null) {
                systemAliases = (List)index.get(system);
            }
            if (systemAliases == null) {
                systemAliases = Collections.singletonList(system);
            }
            if ((optionalContent = systemAliases.stream().map(systemAlias -> {
                Map subIndex;
                Map index;
                if (((Map)data.get(source)).get(systemAlias) == null) {
                    return null;
                }
                String itemAlias = null;
                if (itemIndex != null && (index = (Map)itemIndex.get(source)) != null && (subIndex = (Map)index.get(systemAlias)) != null) {
                    itemAlias = (String)subIndex.get(target);
                }
                if (itemAlias == null) {
                    itemAlias = target;
                }
                return (String)((Map)((Map)data.get(source)).get(systemAlias)).get(itemAlias);
            }).filter(content -> content != null).findAny()).isPresent()) {
                sourceContent.put((String)source, optionalContent.get());
                return true;
            }
            return handleError.getAsBoolean();
        };
        List<PathCharset> paths = Configuration.Manager.getFilePaths(Property.INFORMATION);
        paths.stream().map(pathCharset -> this.pathToKey(pathCharset.getPath())).forEach(source -> {
            if (!((Boolean)retrieveContent.apply((String)source, item)).booleanValue() && parentItem != null) {
                retrieveContent.apply((String)source, parentItem);
            }
        });
        return sourceContent;
    }

    protected String pathToKey(Path path) {
        return path.getFileName().toString();
    }

    @Override
    protected Version loadVersion() throws ClassNotFoundException, IOException {
        Version _version = null;
        try {
            _version = (Version)super.loadVersion();
        }
        catch (Exception ex) {
            Logger.getLogger(IconCache.class.getName()).log(Level.WARNING, null, ex);
        }
        if (_version == null) {
            _version = new Version();
        }
        return _version;
    }

    protected void loadIndex() throws ClassNotFoundException, IOException {
        try {
            Path systemIndexPath = Paths.get(ROOT_FOLDER.toString(), SYSTEM_INDEX_FILE);
            systemIndex = (SystemIndex)this.load(systemIndexPath);
            Path itemIndexPath = Paths.get(ROOT_FOLDER.toString(), ITEM_INDEX_FILE);
            itemIndex = (ItemIndex)this.load(itemIndexPath);
        }
        catch (Exception ex) {
            Logger.getLogger(InformationCache.class.getName()).log(Level.WARNING, null, ex);
        }
        if (systemIndex == null || itemIndex == null) {
            systemIndex = new SystemIndex();
            itemIndex = new ItemIndex();
            ((Version)this.version).clear();
        }
    }

    @Override
    public Data load() throws ClassNotFoundException, IOException {
        try {
            data = (Data)super.load();
        }
        catch (Exception ex) {
            Logger.getLogger(InformationCache.class.getName()).log(Level.WARNING, null, ex);
        }
        if (data == null) {
            data = new Data();
            systemIndex.clear();
            itemIndex.clear();
            ((Version)this.version).clear();
        }
        return data;
    }

    @Override
    public List<InitialisedCallable<Void>> threadedLoad() throws ClassNotFoundException, IOException {
        try {
            ArrayList<InitialisedCallable<Void>> loaders = new ArrayList<InitialisedCallable<Void>>();
            this.loadIndex();
            this.load();
            List<PathCharset> pathCharsets = Configuration.Manager.getFilePaths(Property.INFORMATION);
            for (PathCharset pathCharset : pathCharsets) {
                Path path = pathCharset.getPath();
                String key2 = this.pathToKey(path);
                if (!Files.exists(path, new LinkOption[0])) continue;
                Instant value = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
                if (((Version)this.version).containsKey(key2) && ((Instant)((Version)this.version).get(key2)).equals(value)) continue;
                loaders.add(new InformationLoader(this, path));
                ((Version)this.version).put(key2, value);
                ++this.processingFileCount;
            }
            ArrayList<String> removal = new ArrayList<String>();
            for (String key3 : ((Version)this.version).keySet()) {
                boolean exists = false;
                for (PathCharset pathCharset : pathCharsets) {
                    Path path = pathCharset.getPath();
                    String pathKey = this.pathToKey(path);
                    if (!key3.equals(pathKey) || !Files.exists(path, new LinkOption[0])) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                removal.add(key3);
            }
            removal.forEach(key -> {
                ((Version)this.version).remove(key);
                systemIndex.remove(key);
                itemIndex.remove(key);
                data.remove(key);
            });
            if (this.processingFileCount > 0) {
                this.clearVersion();
                this.processedFileCount = new AtomicInteger();
            } else if (removal.size() > 0) {
                this.save();
            }
            return loaders;
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(InformationCache.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
    }

    protected void saveIndex() throws IOException {
        Path systemIndexPath = Paths.get(ROOT_FOLDER.toString(), SYSTEM_INDEX_FILE);
        this.save(systemIndex, systemIndexPath);
        Path itemIndexPath = Paths.get(ROOT_FOLDER.toString(), ITEM_INDEX_FILE);
        this.save(itemIndex, itemIndexPath);
    }

    @Override
    public void save(InformationData infoData) throws IOException {
        String key = this.pathToKey(infoData.getPath());
        systemIndex.put(key, infoData.getSystemIndex());
        itemIndex.put(key, infoData.getItemIndex());
        data.put(key, infoData.getInformation());
        if (this.processedFileCount.incrementAndGet() == this.processingFileCount) {
            try {
                this.save();
            }
            catch (Exception ex) {
                Logger.getLogger(InformationCache.class.getName()).log(Level.SEVERE, null, ex);
                throw ex;
            }
        }
    }

    private void save() throws IOException {
        this.save(data);
        this.saveIndex();
        this.saveVersion();
    }

    protected static class Data
    extends HashMap<String, Map<String, Map<String, String>>> {
        static final long serialVersionUID = 1L;

        protected Data() {
        }
    }

    protected static class ItemIndex
    extends HashMap<String, Map<String, Map<String, String>>> {
        static final long serialVersionUID = 1L;

        protected ItemIndex() {
        }
    }

    protected static class SystemIndex
    extends HashMap<String, Map<String, List<String>>> {
        static final long serialVersionUID = 1L;

        protected SystemIndex() {
        }
    }

    protected static class Version
    extends HashMap<String, Instant> {
        static final long serialVersionUID = 1L;

        protected Version() {
        }
    }
}

