/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.cache;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.babelsoft.negatron.io.cache.Cache;
import net.babelsoft.negatron.io.cache.InformationCache;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.loader.SoftwareListLoader;
import net.babelsoft.negatron.io.loader.ThreadedCacheLoader;
import net.babelsoft.negatron.model.item.SoftwareList;

public class SoftwareListCache
extends Cache<Data, Version>
implements ThreadedCacheLoader<Callable<Void>> {
    private Data data;
    private int processingfileCount;
    private AtomicInteger processedfileCount;

    public static String convertPathToName(Path path) {
        return path.getFileName().toString().replaceFirst("\\.xml$", "");
    }

    public SoftwareListCache() throws ClassNotFoundException, IOException {
        super("softlist");
    }

    public Map<String, SoftwareList> get() {
        return this.data;
    }

    @Override
    protected Version loadVersion() throws ClassNotFoundException, IOException {
        Version _version = null;
        try {
            _version = (Version)super.loadVersion();
        }
        catch (Exception ex) {
            Logger.getLogger(SoftwareListCache.class.getName()).log(Level.WARNING, null, ex);
        }
        if (_version == null) {
            _version = new Version();
        }
        return _version;
    }

    @Override
    public Data load() throws ClassNotFoundException, IOException {
        try {
            this.data = (Data)super.load();
        }
        catch (Exception ex) {
            Logger.getLogger(SoftwareListCache.class.getName()).log(Level.WARNING, null, ex);
        }
        if (this.data == null) {
            this.data = new Data();
            ((Version)this.version).clear();
        }
        return this.data;
    }

    @Override
    public List<Callable<Void>> threadedLoad() throws ClassNotFoundException, IOException {
        ArrayList<Callable<Void>> loaders = new ArrayList<Callable<Void>>();
        this.load();
        for (String hashString : Configuration.Manager.getFolderPaths(Property.HASH)) {
            Path hashPath = Paths.get(hashString, new String[0]);
            if (!Files.exists(hashPath, new LinkOption[0])) continue;
            Files.find(hashPath, 1, (path, attr) -> path.toString().endsWith(".xml"), new FileVisitOption[0]).forEach(path -> {
                try {
                    String key = path.toString();
                    if (Files.exists(path, new LinkOption[0])) {
                        Instant value = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
                        if (!((Version)this.version).containsKey(key) || !((Instant)((Version)this.version).get(key)).equals(value)) {
                            loaders.add(new SoftwareListLoader(this, (Path)path));
                            ((Version)this.version).put(key, value);
                            ++this.processingfileCount;
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(SoftwareListCache.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
        ArrayList<String> removal = new ArrayList<String>();
        for (String key2 : ((Version)this.version).keySet()) {
            if (Files.exists(Paths.get(key2, new String[0]), new LinkOption[0])) continue;
            removal.add(key2);
        }
        removal.forEach(key -> {
            ((Version)this.version).remove(key);
            key = SoftwareListCache.convertPathToName(Paths.get(key, new String[0]));
            this.data.remove(key);
        });
        if (this.processingfileCount > 0) {
            this.clearVersion();
            this.processedfileCount = new AtomicInteger();
        } else if (removal.size() > 0) {
            this.save();
        }
        return loaders;
    }

    @Override
    public void save(SoftwareList softwareList) throws IOException {
        this.data.put(softwareList.getName(), softwareList);
        if (this.processedfileCount.incrementAndGet() == this.processingfileCount) {
            try {
                this.save();
            }
            catch (Exception ex) {
                Logger.getLogger(InformationCache.class.getName()).log(Level.SEVERE, null, ex);
                throw ex;
            }
        }
    }

    private void save() throws IOException {
        this.save(this.data);
        this.saveVersion();
    }

    protected static class Data
    extends HashMap<String, SoftwareList> {
        static final long serialVersionUID = 1L;

        protected Data() {
        }
    }

    protected static class Version
    extends HashMap<String, Instant> {
        static final long serialVersionUID = 1L;

        protected Version() {
        }
    }
}

