/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.cache;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.babelsoft.negatron.io.cache.Cache;
import net.babelsoft.negatron.io.cache.MachineListCache;
import net.babelsoft.negatron.io.cache.StatusVersion;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.loader.InitialisedCallable;
import net.babelsoft.negatron.io.loader.MachineStatusLoader;
import net.babelsoft.negatron.io.loader.SoftwareStatusLoader;
import net.babelsoft.negatron.io.loader.ThreadedCacheLoader;
import net.babelsoft.negatron.model.Status;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.model.item.SoftwareList;

public class StatusCache
extends Cache<Data, StatusVersion>
implements ThreadedCacheLoader<InitialisedCallable<Void>> {
    private Data data;
    private final Map<String, Machine> machines;
    private final Map<String, SoftwareList> softwareLists;
    private int processingItemCount;
    private AtomicInteger processedItemCount;

    public StatusCache(Map<String, Machine> machines, Map<String, SoftwareList> softwareLists) throws ClassNotFoundException, IOException {
        super("status");
        this.machines = machines;
        this.softwareLists = softwareLists;
    }

    private void checkVersion(List<String> paths, final Supplier<Instant> getLastCreationTime, final Consumer<Instant> setLastCreationTime, final Supplier<Instant> getLastModifiedTime, final Consumer<Instant> setLastModifiedTime) {
        paths.stream().map(path -> Paths.get(path, new String[0])).filter(path -> Files.exists(path, new LinkOption[0])).forEach(path -> {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        Instant time = attrs.creationTime().toInstant();
                        if (((Instant)getLastCreationTime.get()).isBefore(time)) {
                            setLastCreationTime.accept(time);
                        }
                        time = attrs.lastModifiedTime().toInstant();
                        if (((Instant)getLastModifiedTime.get()).isBefore(time)) {
                            setLastModifiedTime.accept(time);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                Logger.getLogger(MachineStatusLoader.class.getName()).log(Level.WARNING, "Couldn't retrieve status versioning", ex);
            }
        });
    }

    private void updateMachineUI() {
        if (this.data.machineStatuses == null) {
            return;
        }
        this.data.machineStatuses.entrySet().forEach(entry -> {
            Machine machine = this.machines.get(entry.getKey());
            if (machine != null) {
                machine.setStatus((Status)entry.getValue());
            }
        });
    }

    private void updateSoftwareUI() {
        if (this.data.softwareStatuses == null) {
            return;
        }
        this.data.softwareStatuses.entrySet().forEach(entry -> {
            SoftwareList softwareList = this.softwareLists.get(entry.getKey());
            if (softwareList != null) {
                ((HashMap)entry.getValue()).entrySet().forEach(subEntry -> {
                    Software software = softwareList.getSoftware((String)subEntry.getKey());
                    if (software != null) {
                        software.setStatus((Status)subEntry.getValue());
                    }
                });
            }
        });
    }

    @Override
    public List<InitialisedCallable<Void>> threadedLoad() throws ClassNotFoundException, IOException {
        String mameVersion;
        this.data = (Data)this.load();
        if (this.data == null) {
            this.data = new Data();
        }
        if (this.version == null) {
            this.version = new StatusVersion();
        }
        if (!(mameVersion = (String)new MachineListCache().getVersion()).equals(((StatusVersion)this.version).getMameVersion())) {
            ((StatusVersion)this.version).setMameVersion(mameVersion);
        }
        this.checkVersion(Configuration.Manager.getFolderPaths(Property.HASH), ((StatusVersion)this.version)::getSoftlistLastCreationTime, ((StatusVersion)this.version)::setSoftlistLastCreationTime, ((StatusVersion)this.version)::getSoftlistLastModifiedTime, ((StatusVersion)this.version)::setSoftlistLastModifiedTime);
        this.checkVersion(Configuration.Manager.getFolderPaths(Property.ROM), ((StatusVersion)this.version)::getRomLastCreationTime, ((StatusVersion)this.version)::setRomLastCreationTime, ((StatusVersion)this.version)::getRomLastModifiedTime, ((StatusVersion)this.version)::setRomLastModifiedTime);
        ArrayList<InitialisedCallable<Void>> loaders = new ArrayList<InitialisedCallable<Void>>();
        if (((StatusVersion)this.version).isMachineModified() || ((StatusVersion)this.version).isRomModified()) {
            loaders.add(new MachineStatusLoader(this));
            this.processedItemCount = new AtomicInteger();
            ++this.processingItemCount;
        } else {
            this.updateMachineUI();
        }
        if (((StatusVersion)this.version).isSoftwareListModified() || ((StatusVersion)this.version).isRomModified()) {
            loaders.add(new SoftwareStatusLoader(this));
            if (this.processedItemCount == null) {
                this.processedItemCount = new AtomicInteger();
            }
            ++this.processingItemCount;
        } else {
            this.updateSoftwareUI();
        }
        return loaders;
    }

    public void saveSoftware(HashMap<String, HashMap<String, Status>> listStatuses) throws IOException {
        this.data.softwareStatuses = listStatuses;
        this.save();
    }

    public void saveMachines(HashMap<String, Status> statuses) throws IOException {
        this.data.machineStatuses = statuses;
        this.save();
    }

    private void save() throws IOException {
        if (this.processedItemCount.incrementAndGet() == this.processingItemCount) {
            try {
                this.save(this.data);
                this.saveVersion();
            }
            catch (Exception ex) {
                Logger.getLogger(StatusCache.class.getName()).log(Level.SEVERE, null, ex);
                throw ex;
            }
        }
    }

    protected static class Data
    implements Serializable {
        static final long serialVersionUID = 1L;
        protected HashMap<String, Status> machineStatuses;
        protected HashMap<String, HashMap<String, Status>> softwareStatuses;

        protected Data() {
        }
    }
}

