/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.cache;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.babelsoft.negatron.io.cache.Cache;
import net.babelsoft.negatron.io.cache.UIConfigurationData;
import net.babelsoft.negatron.io.configuration.TableColumnConfiguration;
import net.babelsoft.negatron.io.configuration.TreeTableColumnConfiguration;
import net.babelsoft.negatron.io.configuration.TreeTableViewConfiguration;

public class UIConfigurationCache
extends Cache<Data, Void> {
    public static final int DEFAULT_WIDTH = 1280;
    public static final int DEFAULT_HEIGHT = 720;
    private Data data;

    public UIConfigurationCache() throws ClassNotFoundException, IOException {
        super("ui");
        try {
            this.data = (Data)this.load();
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        if (this.data != null) {
            if (this.data.windowWidth < 10 || this.data.windowHeight < 10) {
                this.data.windowWidth = 1280;
                this.data.windowHeight = 720;
            }
        } else {
            this.data = new Data();
        }
    }

    private <T> T loadTreeTableViewConfiguration(String id, Function<TreeTableViewConfiguration, T> get, T defaultValue) {
        TreeTableViewConfiguration conf = this.data.treeTableConfiguration.get(id);
        if (conf != null) {
            return get.apply(conf);
        }
        return defaultValue;
    }

    public Map<String, TreeTableColumnConfiguration> loadTreeTableColumnsConfiguration(String id) {
        return this.loadTreeTableViewConfiguration(id, conf -> conf.getLayout(), null);
    }

    public boolean loadTreeTableFlattenConfiguration(String id) {
        return this.loadTreeTableViewConfiguration(id, conf -> conf.isFlatten(), false);
    }

    private void saveTreeTableViewConfiguration(String id, Consumer<TreeTableViewConfiguration> updateViewConfiguration) throws IOException {
        TreeTableViewConfiguration vconf = this.data.treeTableConfiguration.get(id);
        if (vconf == null) {
            vconf = new TreeTableViewConfiguration();
        }
        updateViewConfiguration.accept(vconf);
        this.data.treeTableConfiguration.put(id, vconf);
        this.save(this.data);
    }

    public void saveTreeTableColumnsConfiguration(String id, Map<String, TreeTableColumnConfiguration> conf) throws IOException {
        this.saveTreeTableViewConfiguration(id, vconf -> vconf.setLayout(conf));
    }

    public void saveTreeTableFlattenConfiguration(String id, boolean flatten) throws IOException {
        this.saveTreeTableViewConfiguration(id, vconf -> vconf.setFlatten(flatten));
    }

    public Map<String, TableColumnConfiguration> loadTableColumnsConfiguration(String id) {
        return this.data.tableConfiguration;
    }

    public void saveTableColumnsConfiguration(String id, Map<String, TableColumnConfiguration> conf) throws IOException {
        this.data.tableConfiguration = conf;
        this.save(this.data);
    }

    public double loadMainDividerPosition() {
        return this.data.mainDividerPosition;
    }

    public void saveMainDividerPosition(double position) throws IOException {
        this.data.mainDividerPosition = position;
        this.save(this.data);
    }

    public int loadMachineInformationTabIndex() {
        return this.data.machineInformationTabIndex;
    }

    public void saveMachineInformationTabIndex(int index) throws IOException {
        this.data.machineInformationTabIndex = index;
        this.save(this.data);
    }

    public int loadSoftwareInformationTabIndex() {
        return this.data.softwareInformationTabIndex;
    }

    public void saveSoftwareInformationTabIndex(int index) throws IOException {
        this.data.softwareInformationTabIndex = index;
        this.save(this.data);
    }

    public int loadGlobalConfigurationTabIndex() {
        return this.data.globalConfigurationTabIndex;
    }

    public void saveGlobalConfigurationTabIndex(int index) throws IOException {
        this.data.globalConfigurationTabIndex = index;
        this.save(this.data);
    }

    public UIConfigurationData loadFilterConfiguration() {
        return this.data.filterConfiguration;
    }

    public UIConfigurationData loadFilterConfiguration(String key) {
        if (this.data.filterConfigurationMap.containsKey(key)) {
            return this.data.filterConfigurationMap.get(key);
        }
        return new UIConfigurationData();
    }

    public void saveFilterConfiguration(UIConfigurationData data) throws IOException {
        this.data.filterConfiguration = data;
        this.save(this.data);
    }

    public void saveFilterConfiguration(String key, UIConfigurationData data) throws IOException {
        this.data.filterConfigurationMap.put(key, data);
        this.save(this.data);
    }

    public boolean loadLoopEnabled() {
        return this.data.loopEnabled;
    }

    public void saveLoopEnabled(boolean value) throws IOException {
        this.data.loopEnabled = value;
        this.save(this.data);
    }

    public int loadWindowWidth() {
        return this.data.windowWidth;
    }

    public void saveWindowWidth(int value) throws IOException {
        this.data.windowWidth = value;
        this.save(this.data);
    }

    public int loadWindowHeight() {
        return this.data.windowHeight;
    }

    public void saveWindowHeight(int value) throws IOException {
        this.data.windowHeight = value;
        this.save(this.data);
    }

    public boolean loadWindowMaximised() {
        return this.data.isWindowMaximised;
    }

    public void saveWindowMaximised(boolean value) throws IOException {
        this.data.isWindowMaximised = value;
        this.save(this.data);
    }

    public boolean loadWindowFullscreen() {
        return this.data.isWindowFullscreen;
    }

    public void saveWindowFullscreen(boolean value) throws IOException {
        this.data.isWindowFullscreen = value;
        this.save(this.data);
    }

    protected static class Data
    implements Serializable {
        static final long serialVersionUID = 5L;
        protected Map<String, TreeTableViewConfiguration> treeTableConfiguration = new HashMap<String, TreeTableViewConfiguration>();
        protected Map<String, TableColumnConfiguration> tableConfiguration = new HashMap<String, TableColumnConfiguration>();
        protected double mainDividerPosition = -1.0;
        protected UIConfigurationData filterConfiguration = new UIConfigurationData();
        protected Map<String, UIConfigurationData> filterConfigurationMap = new HashMap<String, UIConfigurationData>();
        protected int machineInformationTabIndex = 0;
        protected int softwareInformationTabIndex = 0;
        protected int globalConfigurationTabIndex = 0;
        protected boolean loopEnabled = false;
        protected int windowWidth = 1280;
        protected int windowHeight = 720;
        protected boolean isWindowMaximised = false;
        protected boolean isWindowFullscreen = false;
    }
}

