/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.configuration;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.babelsoft.negatron.io.Mame;
import net.babelsoft.negatron.io.cache.UIConfigurationCache;
import net.babelsoft.negatron.io.cache.UIConfigurationData;
import net.babelsoft.negatron.io.configuration.Domain;
import net.babelsoft.negatron.io.configuration.PathCharset;
import net.babelsoft.negatron.io.configuration.PathPrimary;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.configuration.TableColumnConfiguration;
import net.babelsoft.negatron.io.configuration.TreeTableColumnConfiguration;
import net.babelsoft.negatron.io.configuration.VsyncMethod;
import net.babelsoft.negatron.util.Shell;
import net.babelsoft.negatron.util.Strings;

public enum Configuration {
    Manager;

    private static final String TRUE = "1";
    private static final String FALSE = "0";
    private final String MAME = "mame";
    private final String MESS = "mess";
    private final String CHDMAN = "chdman";
    private final String MAME_ENTRY = "mame";
    private final String MESS_ENTRY = "mess";
    private final String MAME_INI_ENTRY = "mameini";
    private final String CHDMAN_ENTRY = "chdman";
    private final String EXTRAS_ENTRY = "extras";
    private final String MULTIMEDIA_ENTRY = "multimedia";
    private final String VLC_ENTRY = "vlc";
    private final String SKIN_ENTRY = "skin";
    private final String LANGUAGE_ENTRY = "language";
    private final String CHEAT_MENU_ENTRY = "cheatmenu";
    private final String VSYNC_ENTRY = "vsync";
    private final String SOUND_ENTRY = "sound";
    private final String VIDEO_ENTRY = "video";
    private final String VIEW3D_ENTRY = "view3d";
    private final String MAME_CHEAT_MENU_ENTRY = "cheat";
    private final Path NEGATRON_INI = Paths.get("./Negatron.ini", new String[0]);
    private final String MAME_INI = "mame.ini";
    private final String MESS_INI = "mess.ini";
    private String mamePath;
    private String mameExec;
    private String mameIni;
    private String chdmanExec;
    private String extrasPath;
    private String multimediaPath;
    private String vlcPath;
    private String skin;
    private String language;
    private Boolean cheatMenuEnabled;
    private VsyncMethod vsync;
    private Boolean soundEnabled;
    private Boolean videoEnabled;
    private Boolean view3dEnabled;
    private final Map<Property, List<String>> folders = new LinkedHashMap<Property, List<String>>();
    private final Map<Property, List<PathCharset>> files = new LinkedHashMap<Property, List<PathCharset>>();
    private final Map<Property, String> primaryMachineFolders = new LinkedHashMap<Property, String>();
    private final Map<Property, String> primarySoftwareFolders = new LinkedHashMap<Property, String>();
    private UIConfigurationCache uiConfigurationCache;
    private boolean disableWrite;
    private boolean masterConfigPointSet;
    private boolean isMess;
    private boolean isAsyncExecutionMode;
    private boolean isXmlMediaOptionAvailable;

    private Configuration() {
        try {
            this.uiConfigurationCache = new UIConfigurationCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialise() throws IOException, InterruptedException {
        Optional<Property> result;
        Property[] propertyArray = null;
        try (BufferedReader reader = Files.newBufferedReader(this.NEGATRON_INI);){
            reader.lines().filter(line -> !line.trim().startsWith("#")).map(line -> this.splitLine((String)line)).forEach(content -> {
                if ("screenshotpath".equals(content[0])) {
                    content[0] = Property.SNAPSHOT.name;
                }
                switch (content[0]) {
                    case "mame": {
                        this.setMamePath(this.tidyStringPath(content[1]));
                        break;
                    }
                    case "mess": {
                        this.setMamePath(this.tidyStringPath(content[1]));
                        this.isMess = true;
                        break;
                    }
                    case "mameini": {
                        String iniPath = this.tidyStringPath(content[1]);
                        if (iniPath.isEmpty()) break;
                        this.mameIni = iniPath;
                        break;
                    }
                    case "chdman": {
                        this.chdmanExec = this.tidyStringPath(content[1]);
                        break;
                    }
                    case "extras": {
                        this.extrasPath = this.tidyStringPath(content[1]);
                        break;
                    }
                    case "multimedia": {
                        this.multimediaPath = this.tidyStringPath(content[1]);
                        break;
                    }
                    case "vlc": {
                        this.vlcPath = this.tidyStringPath(content[1]);
                        break;
                    }
                    case "skin": {
                        this.skin = this.tidyStringPath(content[1]);
                        break;
                    }
                    case "language": {
                        this.language = this.tidyStringPath(content[1]);
                        break;
                    }
                    case "cheatmenu": {
                        this.cheatMenuEnabled = this.digitToBoolean(content[1]);
                        break;
                    }
                    case "vsync": {
                        this.vsync = Arrays.stream(VsyncMethod.values()).filter(vsyncMethod -> vsyncMethod.equals(content[1])).findAny().orElse(null);
                        break;
                    }
                    case "sound": {
                        this.soundEnabled = this.digitToBoolean(content[1]);
                        break;
                    }
                    case "video": {
                        this.videoEnabled = this.digitToBoolean(content[1]);
                        break;
                    }
                    case "view3d": {
                        this.view3dEnabled = this.digitToBoolean(content[1]);
                        break;
                    }
                    default: {
                        Arrays.stream(Property.values()).filter(property -> property.name.equals(content[0])).findAny().ifPresent(property -> {
                            if (property.domain == Domain.EXTRAS_INFORMATION) {
                                this.files.put((Property)((Object)((Object)property)), this.pathStringToFileArray(content[1]));
                            } else {
                                this.folders.put((Property)((Object)((Object)property)), this.pathStringToFolderArray((Property)((Object)((Object)property)), content[1]));
                            }
                        });
                    }
                }
            });
        }
        catch (Throwable object) {
            propertyArray = object;
            throw object;
        }
        boolean mustWriteDefaultConfiguration = false;
        if (Strings.isValid(this.extrasPath) && !(result = Arrays.stream(Property.values()).filter(property -> !property.isMamePath && this.folders.get(property) != null).findAny()).isPresent()) {
            mustWriteDefaultConfiguration = true;
        }
        if (Strings.isValid(this.mamePath)) {
            boolean mustUpdateMameConfiguration;
            if (this.mameIni == null) {
                String INI;
                String string = INI = this.isMess ? "mess.ini" : "mame.ini";
                if (Shell.isLinux()) {
                    List<String> mameIniPaths = Shell.find(INI, this.mamePath);
                    mameIniPaths.addAll(Shell.find(INI, Shell.expandPath("$HOME/." + (this.isMess ? "mess" : "mame"))));
                    mameIniPaths.addAll(Shell.find(INI, "/etc/"));
                    mameIniPaths.addAll(Shell.find(INI, "/usr/"));
                    Optional<String> mameIniPath = mameIniPaths.stream().filter(path -> {
                        File file = Paths.get(path, new String[0]).toFile();
                        return file.canRead() && file.canWrite();
                    }).findAny();
                    if (mameIniPath.isPresent()) {
                        this.mameIni = mameIniPath.get();
                    } else {
                        mameIniPath = mameIniPaths.stream().filter(path -> Paths.get(path, new String[0]).toFile().canRead()).findAny();
                        if (mameIniPath.isPresent()) {
                            try (BufferedReader reader = Files.newBufferedReader(Paths.get(mameIniPath.get(), new String[0]));){
                                reader.lines().filter(line -> line.startsWith("inipath")).findAny().ifPresent(iniPathLine -> {
                                    List<String> iniPaths = this.pathStringToArray(this.splitLine((String)iniPathLine)[1]);
                                    String mameIniFolder = iniPaths.get(0);
                                    if (mameIniFolder.startsWith("$")) {
                                        mameIniFolder = Shell.expandPath(mameIniFolder);
                                    }
                                    if (mameIniFolder != null) {
                                        this.mameIni = Paths.get(mameIniFolder, INI).toString();
                                    }
                                });
                            }
                        }
                    }
                    if (this.mameIni == null) {
                        this.mameIni = Paths.get(Shell.expandPath("$HOME/." + (this.isMess ? "mess" : "mame")), INI).toString();
                    }
                } else {
                    this.mameIni = Paths.get(this.mamePath, INI).toString();
                }
            }
            boolean mameIniCreatedJustNow = false;
            Path iniPath = Paths.get(this.mameIni, new String[0]);
            if (Files.notExists(iniPath, new LinkOption[0])) {
                mameIniCreatedJustNow = true;
            }
            Mame.launch(this.stringToArray("-cc"), iniPath.getParent().toString(), true);
            boolean shouldUpdateMameConfiguration = mustWriteDefaultConfiguration || this.extrasPath != null && mameIniCreatedJustNow;
            Path mameRoot = Paths.get(this.mamePath, new String[0]);
            try (BufferedReader reader = Files.newBufferedReader(iniPath);){
                mustUpdateMameConfiguration = reader.lines().filter(line -> !line.trim().startsWith("#")).map(line -> this.splitLine((String)line)).map(content -> {
                    Arrays.stream(Property.values()).filter(property -> property.isMamePath && content[0].equals(property.name)).forEach(property -> {
                        String defaultFolders = null;
                        if (shouldUpdateMameConfiguration && property.defaultFolders.size() > 0) {
                            defaultFolders = property.defaultFolders.stream().map(defaultFolder -> Paths.get(this.extrasPath, defaultFolder).normalize().toString()).filter(defaultFolder -> {
                                String relativePath = null;
                                try {
                                    relativePath = mameRoot.relativize(Paths.get(defaultFolder, new String[0])).toString();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                                return !content[1].contains((CharSequence)defaultFolder) && (relativePath == null || !content[1].contains(relativePath));
                            }).collect(Collectors.joining(";"));
                        }
                        this.folders.put((Property)((Object)((Object)property)), this.contentToPathArray(content[1] + (defaultFolders != null ? ";" + defaultFolders : "")));
                    });
                    boolean mustUpdate = false;
                    if (content[0].equals("cheat")) {
                        boolean mameCheatMenuEnabled = this.digitToBoolean(content[1]);
                        if (this.cheatMenuEnabled == null) {
                            this.cheatMenuEnabled = mameCheatMenuEnabled;
                            mustUpdate = true;
                        } else if (this.cheatMenuEnabled != mameCheatMenuEnabled) {
                            mustUpdate = true;
                        }
                    } else if (content[0].equals(VsyncMethod.DOUBLE_BUFFERING.name)) {
                        boolean doubleBufferingEnabled = this.digitToBoolean(content[1]);
                        if (this.vsync == null && doubleBufferingEnabled) {
                            this.vsync = VsyncMethod.DOUBLE_BUFFERING;
                            mustUpdate = true;
                        } else if (this.vsync == VsyncMethod.DOUBLE_BUFFERING && !doubleBufferingEnabled) {
                            mustUpdate = true;
                        }
                    } else if (content[0].equals(VsyncMethod.TRIPLE_BUFFERING.name)) {
                        boolean tripleBufferingEnabled = this.digitToBoolean(content[1]);
                        if (this.vsync == null && tripleBufferingEnabled) {
                            this.vsync = VsyncMethod.TRIPLE_BUFFERING;
                            mustUpdate = true;
                        } else if (this.vsync == VsyncMethod.TRIPLE_BUFFERING && !tripleBufferingEnabled) {
                            mustUpdate = true;
                        }
                    }
                    return mustUpdate;
                }).reduce(false, (a, b) -> a != false || b != false);
            }
            if (shouldUpdateMameConfiguration || mustUpdateMameConfiguration) {
                this.writeMameInitialisationFile();
            }
        }
        if (this.chdmanExec == null) {
            if (Shell.isWindows()) {
                Path path2 = Paths.get(this.mamePath, "chdman.exe");
                if (path2.toFile().exists()) {
                    this.chdmanExec = path2.toString();
                }
            } else {
                List<String> chdmanPaths;
                this.chdmanExec = Shell.which("chdman");
                if (this.chdmanExec == null && (chdmanPaths = Shell.find("chdman", this.mamePath)).size() > 0) {
                    this.chdmanExec = chdmanPaths.get(0);
                }
            }
            if (this.chdmanExec == null) {
                this.chdmanExec = "";
            }
        }
        if (this.vlcPath == null) {
            this.vlcPath = "";
        }
        if (this.skin == null) {
            this.skin = "";
        }
        if (this.language == null) {
            this.language = "";
        }
        if (this.vsync == null) {
            this.vsync = VsyncMethod.NONE;
        }
        if (this.soundEnabled == null) {
            this.soundEnabled = true;
        }
        if (this.videoEnabled == null) {
            this.videoEnabled = true;
        }
        if (this.view3dEnabled == null) {
            this.view3dEnabled = false;
        }
        if (mustWriteDefaultConfiguration) {
            for (Property property2 : Property.values()) {
                if (property2.isMamePath) continue;
                if (property2.domain == Domain.EXTRAS_INFORMATION) {
                    property2.defaultFiles.keySet().stream().forEach(file -> {
                        Path path = Paths.get(this.extrasPath, file);
                        if (this.files.get((Object)property2) == null) {
                            this.files.put(property2, new ArrayList());
                        }
                        String pathString = path.toString();
                        String charset = property.defaultFiles.get(file);
                        this.files.get((Object)property2).add(new PathCharset(pathString, charset));
                    });
                    continue;
                }
                Consumer<String> initProperty = rootPath -> property.defaultFolders.stream().map(folder -> Paths.get(rootPath, folder).toString()).forEach(path -> {
                    if (this.folders.get((Object)property2) == null) {
                        this.folders.put(property2, new ArrayList());
                    }
                    this.folders.get((Object)property2).add((String)path);
                    if (property.hasSoftwarePrimaryPath && path.endsWith(property.defaultPrimarySoftwareFolder)) {
                        this.primarySoftwareFolders.put(property2, (String)path);
                    }
                    if (property.hasMachinePrimaryPath && path.endsWith(property.defaultPrimaryMachineFolder)) {
                        this.primaryMachineFolders.put(property2, (String)path);
                    }
                });
                if (property2.isExtrasPath) {
                    initProperty.accept(this.extrasPath);
                    continue;
                }
                if (!Strings.isValid(this.multimediaPath)) continue;
                initProperty.accept(this.multimediaPath);
            }
            this.writeNegatronInitialisationFile();
        }
    }

    private boolean digitToBoolean(String content) {
        return TRUE.equals(content.trim());
    }

    private String tidyStringPath(String path) {
        path = path.replace("\"", "").trim();
        if (Shell.isPosix()) {
            return Shell.expandPath(path);
        }
        return path;
    }

    private String[] splitLine(String line) {
        return line.split("\\s", 2);
    }

    private List<String> stringToArray(String string) {
        ArrayList<String> array = new ArrayList<String>();
        array.add(string);
        return array;
    }

    private List<String> pathStringToArray(String paths) {
        if ((paths = paths.trim()).isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.asList(paths.trim().replace("\"", "").replaceAll(";{2,}", ";").split(";"));
    }

    private List<String> pathStringToFolderArray(Property property, String paths) {
        List<String> array = this.pathStringToArray(paths);
        return array.stream().map(element -> {
            String[] folderPrimary = element.split("\\|");
            if (folderPrimary.length > 1) {
                if (folderPrimary[1].contains("M")) {
                    this.primaryMachineFolders.put(property, folderPrimary[0]);
                }
                if (folderPrimary[1].contains("S")) {
                    this.primarySoftwareFolders.put(property, folderPrimary[0]);
                }
            }
            return folderPrimary[0];
        }).collect(Collectors.toList());
    }

    private List<PathCharset> pathStringToFileArray(String paths) {
        List<String> array = this.pathStringToArray(paths);
        ArrayList<PathCharset> pathCharsets = new ArrayList<PathCharset>();
        array.stream().forEachOrdered(element -> {
            String[] pathCharset = element.split("\\|");
            pathCharsets.add(new PathCharset(pathCharset[0], pathCharset[1]));
        });
        return pathCharsets;
    }

    private List<String> contentToPathArray(String content) {
        List<String> array = this.pathStringToArray(content);
        Path mameRoot = Paths.get(this.mamePath, new String[0]);
        return array.stream().map(path -> {
            if (Shell.isPosix()) {
                path = Shell.expandPath(path);
            }
            return mameRoot.resolve((String)path).normalize().toString();
        }).collect(Collectors.toList());
    }

    private void writeConfigurationSectionHeader(BufferedWriter writer, String header) throws IOException {
        writer.write("#");
        writer.newLine();
        writer.write("# ");
        writer.write(header);
        writer.newLine();
        writer.write("#");
        writer.newLine();
    }

    private void writeConfigurationLineHeader(BufferedWriter writer, String header) throws IOException {
        writer.write(header);
        int blankSize = 26 - header.length();
        for (int i = 0; i < blankSize; ++i) {
            writer.write(" ");
        }
    }

    private void writeConfigurationLine(BufferedWriter writer, String header, String content) throws IOException {
        this.writeConfigurationLine(writer, header, Collections.singletonList(content));
    }

    private void writeConfigurationLine(BufferedWriter writer, String header, List<String> content) throws IOException {
        this.writeConfigurationLineHeader(writer, header);
        Iterator<String> it = content.iterator();
        if (it.hasNext()) {
            writer.write(it.next());
            while (it.hasNext()) {
                String part = it.next();
                writer.write(";");
                writer.write(part);
            }
        }
        writer.newLine();
    }

    private void writeConfigurationLine(BufferedWriter writer, String header, boolean content) throws IOException {
        this.writeConfigurationLineHeader(writer, header);
        if (content) {
            writer.write(TRUE);
        } else {
            writer.write(FALSE);
        }
        writer.newLine();
    }

    private void writeInitialisationFile(Property property) throws IOException, InterruptedException {
        if (!this.disableWrite) {
            if (property.isMamePath) {
                this.writeMameInitialisationFile();
            } else {
                this.writeNegatronInitialisationFile();
            }
        }
    }

    public void writeMameInitialisationFile() throws IOException, InterruptedException {
        if (Strings.isEmpty(this.mamePath) || this.mameIni == null || !new File(this.mameIni).canWrite()) {
            return;
        }
        Path mameRoot = Paths.get(this.mamePath, new String[0]);
        Path iniPath = Paths.get(this.mameIni, new String[0]);
        Path tempPath = Files.createTempFile("negatron", "mameini", new FileAttribute[0]);
        try (BufferedReader reader = Files.newBufferedReader(iniPath);
             BufferedWriter writer = Files.newBufferedWriter(tempPath, new OpenOption[0]);){
            for (String line : (String[])reader.lines().toArray(String[]::new)) {
                boolean lineUpdated = false;
                if (!line.isEmpty() && !line.startsWith("#")) {
                    String[] splitLine = this.splitLine(line);
                    for (Property property : Property.values()) {
                        if (!property.isMamePath || !splitLine[0].equals(property.name)) continue;
                        ArrayList<String> content = new ArrayList<String>();
                        this.folders.get((Object)property).stream().forEachOrdered(folder -> {
                            if (Shell.isLinux()) {
                                folder = Shell.maskPath(folder);
                            } else {
                                try {
                                    Path res = mameRoot.relativize(Paths.get(folder, new String[0]));
                                    folder = res.toString();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                            content.add((String)folder);
                        });
                        this.writeConfigurationLine(writer, property.name, content);
                        lineUpdated = true;
                        break;
                    }
                    if (splitLine[0].equals("cheat")) {
                        this.writeConfigurationLine(writer, "cheat", this.cheatMenuEnabled);
                        lineUpdated = true;
                    } else if (splitLine[0].equals(VsyncMethod.DOUBLE_BUFFERING.name)) {
                        this.writeConfigurationLine(writer, VsyncMethod.DOUBLE_BUFFERING.name, this.vsync == VsyncMethod.DOUBLE_BUFFERING);
                        lineUpdated = true;
                    } else if (splitLine[0].equals(VsyncMethod.TRIPLE_BUFFERING.name)) {
                        this.writeConfigurationLine(writer, VsyncMethod.TRIPLE_BUFFERING.name, this.vsync == VsyncMethod.TRIPLE_BUFFERING);
                        lineUpdated = true;
                    }
                }
                if (lineUpdated) continue;
                writer.write(line);
                writer.newLine();
            }
        }
        Files.move(tempPath, iniPath, StandardCopyOption.REPLACE_EXISTING);
    }

    public void writeNegatronInitialisationFile() throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(this.NEGATRON_INI, new OpenOption[0]);){
            this.writeConfigurationSectionHeader(writer, "MAME PATHS");
            if (this.isMess) {
                this.writeConfigurationLine(writer, "mess", this.mameExec);
            } else {
                this.writeConfigurationLine(writer, "mame", this.mameExec);
            }
            this.writeConfigurationLine(writer, "mameini", this.mameIni);
            this.writeConfigurationLine(writer, "chdman", this.chdmanExec);
            this.writeConfigurationLine(writer, "extras", this.extrasPath);
            this.writeConfigurationLine(writer, "multimedia", this.multimediaPath);
            writer.newLine();
            this.writeConfigurationSectionHeader(writer, "EXTRAS / MULTIMEDIA PATHS");
            for (Property property : Property.values()) {
                ArrayList<String> paths;
                if (property.isMamePath) continue;
                if (property.domain == Domain.EXTRAS_INFORMATION) {
                    paths = new ArrayList<String>();
                    if (this.files.get((Object)property) == null) continue;
                    this.files.get((Object)property).stream().forEach(pathCharset -> paths.add(pathCharset.getPath().toString() + "|" + pathCharset.getCharSet()));
                    this.writeConfigurationLine(writer, property.name, paths);
                    continue;
                }
                paths = new ArrayList();
                if (this.folders.get((Object)property) == null) continue;
                this.folders.get((Object)property).stream().forEach(path -> {
                    String primary = "";
                    if (property.hasSoftwarePrimaryPath && path.equals(this.primarySoftwareFolders.get((Object)property))) {
                        primary = primary + "S";
                    }
                    if (property.hasMachinePrimaryPath && path.equals(this.primaryMachineFolders.get((Object)property))) {
                        primary = primary + "M";
                    }
                    if (!primary.isEmpty()) {
                        path = path + "|" + primary;
                    }
                    paths.add((String)path);
                });
                this.writeConfigurationLine(writer, property.name, paths);
            }
            writer.newLine();
            this.writeConfigurationSectionHeader(writer, "MISC");
            this.writeConfigurationLine(writer, "vlc", this.vlcPath);
            this.writeConfigurationLine(writer, "skin", this.skin);
            this.writeConfigurationLine(writer, "language", this.language);
            this.writeConfigurationLine(writer, "cheatmenu", this.cheatMenuEnabled);
            this.writeConfigurationLine(writer, "vsync", this.vsync.name);
            this.writeConfigurationLine(writer, "sound", this.soundEnabled);
            this.writeConfigurationLine(writer, "video", this.videoEnabled);
            this.writeConfigurationLine(writer, "view3d", this.view3dEnabled);
        }
    }

    public void determineExecutionMode(String mameVersion) {
        this.isAsyncExecutionMode = false;
        this.isXmlMediaOptionAvailable = false;
        String[] versionTab = mameVersion.split(" ");
        if (versionTab.length > 1 && versionTab[1].startsWith("v0.")) {
            try {
                int minorVersion = Integer.parseInt(versionTab[1].substring(3));
                if (minorVersion < 186) {
                    this.isAsyncExecutionMode = true;
                } else if (mameVersion.matches("MAME.*\\(negamame.*\\)")) {
                    this.isXmlMediaOptionAvailable = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean isAsyncExecutionMode() {
        return this.isAsyncExecutionMode;
    }

    public boolean isSyncExecutionMode() {
        return !this.isAsyncExecutionMode;
    }

    public boolean isXmlMediaOptionAvailable() {
        return this.isXmlMediaOptionAvailable;
    }

    public boolean isMess() {
        return this.isMess;
    }

    public String getMamePath() {
        return this.mamePath;
    }

    public String getMameExecutable() {
        return this.mameExec;
    }

    public String getMameIni() {
        return this.mameIni;
    }

    public String getChdmanExecutable() {
        return this.chdmanExec;
    }

    public String getExtrasPath() {
        return this.extrasPath;
    }

    public String getMultimediaPath() {
        return this.multimediaPath;
    }

    public String getVlcPath() {
        return this.vlcPath;
    }

    public String getSkin() {
        return this.skin;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isCheatMenuEnabled() {
        return this.cheatMenuEnabled;
    }

    public VsyncMethod getVsyncMethod() {
        return this.vsync;
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public boolean isView3dEnabled() {
        return this.view3dEnabled;
    }

    public List<String> getFolderPaths(Property property) {
        if (property.domain != Domain.EXTRAS_INFORMATION && this.folders.get((Object)property) != null) {
            return this.folders.get((Object)property);
        }
        return Collections.emptyList();
    }

    public List<PathCharset> getFilePaths(Property property) {
        if (property.domain == Domain.EXTRAS_INFORMATION && this.files.get((Object)property) != null) {
            return this.files.get((Object)property);
        }
        return Collections.emptyList();
    }

    public String getPrimaryMachineFolder(Property property) {
        return this.primaryMachineFolders.get((Object)property);
    }

    public String getPrimarySoftwareFolder(Property property) {
        return this.primarySoftwareFolders.get((Object)property);
    }

    public List<PathPrimary> getDefaultFolderPaths(Property property, String rootFolder) {
        ArrayList<PathPrimary> pathPrimaries = new ArrayList<PathPrimary>();
        if (property.domain != Domain.EXTRAS_INFORMATION) {
            property.defaultFolders.stream().map(folder -> rootFolder + File.separator + folder).forEach(path -> {
                boolean softwarePrimary = false;
                boolean machinePrimary = false;
                if (property.hasSoftwarePrimaryPath && path.endsWith(property.defaultPrimarySoftwareFolder)) {
                    softwarePrimary = true;
                }
                if (property.hasMachinePrimaryPath && path.endsWith(property.defaultPrimaryMachineFolder)) {
                    machinePrimary = true;
                }
                pathPrimaries.add(new PathPrimary((String)path, machinePrimary, softwarePrimary));
            });
        }
        return pathPrimaries;
    }

    public List<PathCharset> getDefaultFilePaths(Property property, String rootFolder) {
        ArrayList<PathCharset> pathCharsets = new ArrayList<PathCharset>();
        if (property.domain == Domain.EXTRAS_INFORMATION) {
            property.defaultFiles.keySet().stream().forEach(file -> {
                String path = rootFolder + File.separator + file;
                String charset = property.defaultFiles.get(file);
                pathCharsets.add(new PathCharset(path, charset));
            });
        }
        return pathCharsets;
    }

    public Map<String, TreeTableColumnConfiguration> getTreeTableColumnsConfiguration(String id) {
        Map<String, TreeTableColumnConfiguration> res;
        if (this.uiConfigurationCache != null && (res = this.uiConfigurationCache.loadTreeTableColumnsConfiguration(id)) != null) {
            return res;
        }
        return Collections.emptyMap();
    }

    public boolean getTreeTableFlattenConfiguration(String id) {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadTreeTableFlattenConfiguration(id);
        }
        return false;
    }

    public Map<String, TableColumnConfiguration> getTableColumnsConfiguration(String id) {
        Map<String, TableColumnConfiguration> res;
        if (this.uiConfigurationCache != null && (res = this.uiConfigurationCache.loadTableColumnsConfiguration(id)) != null) {
            return res;
        }
        return Collections.emptyMap();
    }

    public double getMainDividerPosition() {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadMainDividerPosition();
        }
        return -1.0;
    }

    public int getMachineInformationTabIndex() {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadMachineInformationTabIndex();
        }
        return 0;
    }

    public int getSoftwareInformationTabIndex() {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadSoftwareInformationTabIndex();
        }
        return 0;
    }

    public int getGlobalConfigurationTabIndex() {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadGlobalConfigurationTabIndex();
        }
        return 0;
    }

    public UIConfigurationData getFilterConfiguration() {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadFilterConfiguration();
        }
        return new UIConfigurationData();
    }

    public UIConfigurationData getFilterConfiguration(String key) {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadFilterConfiguration(key);
        }
        return new UIConfigurationData();
    }

    public boolean isLoopEnabled() {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadLoopEnabled();
        }
        return false;
    }

    public int getWindowWidth() {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadWindowWidth();
        }
        return 1280;
    }

    public int getWindowHeight() {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadWindowHeight();
        }
        return 720;
    }

    public boolean isWindowMaximised() {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadWindowMaximised();
        }
        return false;
    }

    public boolean isWindowFullscreen() {
        if (this.uiConfigurationCache != null) {
            return this.uiConfigurationCache.loadWindowFullscreen();
        }
        return false;
    }

    public void setMasterConfigPoint() {
        this.beginMasterConfigTransaction();
        this.masterConfigPointSet = true;
    }

    public void beginMasterConfigTransaction() {
        this.disableWrite = true;
    }

    public void rollbackMasterConfigTransaction() {
        this.disableWrite = false;
    }

    public boolean updateMasterConfigPath(Domain domain, String path) throws IOException, InterruptedException {
        boolean changed = false;
        if (domain == Domain.EXTRAS_MACHINE_SOFTWARE && !path.equals(this.extrasPath) || domain == Domain.MULTIMEDIA_MACHINE_SOFTWARE && !path.equals(this.multimediaPath)) {
            if (domain == Domain.EXTRAS_MACHINE_SOFTWARE) {
                this.extrasPath = path;
            } else {
                this.multimediaPath = path;
            }
            changed = true;
        }
        if (this.masterConfigPointSet || !this.disableWrite) {
            if (changed) {
                if (domain == Domain.EXTRAS_MACHINE_SOFTWARE) {
                    this.writeMameInitialisationFile();
                }
                this.writeNegatronInitialisationFile();
            }
            this.masterConfigPointSet = false;
            this.disableWrite = false;
            return true;
        }
        return false;
    }

    public void commitMasterConfigTransaction(Domain domain) throws IOException, InterruptedException {
        this.disableWrite = false;
        if (domain == Domain.EXTRAS_MACHINE_SOFTWARE) {
            this.writeMameInitialisationFile();
        }
        this.writeNegatronInitialisationFile();
    }

    private boolean setMamePath(String path) {
        Path _path;
        String _mameExec;
        boolean changed = false;
        if (Strings.isValid(path) && !(_mameExec = (_path = Paths.get(path, new String[0])).toString()).equals(this.mameExec)) {
            this.mameExec = _path.toString();
            this.mamePath = _path.getParent().toString();
            changed = true;
        }
        return changed;
    }

    public void updateMamePath(String path) throws IOException {
        if (this.setMamePath(path)) {
            this.writeNegatronInitialisationFile();
        }
    }

    public void updateMameIni(String path) throws IOException {
        if (!path.equals(this.mameIni)) {
            this.mameIni = path;
            this.writeNegatronInitialisationFile();
        }
    }

    public void updateChdmanPath(String path) throws IOException {
        if (!path.equals(this.chdmanExec)) {
            this.chdmanExec = path;
            this.writeNegatronInitialisationFile();
        }
    }

    public void updateVlcPath(String path) throws IOException {
        if (!path.equals(this.vlcPath)) {
            this.vlcPath = path;
            this.writeNegatronInitialisationFile();
        }
    }

    public void updateSkin(String name) throws IOException {
        if (!this.skin.equals(name)) {
            this.skin = name;
            this.writeNegatronInitialisationFile();
        }
    }

    public void updateLanguage(String language) throws IOException {
        if (!this.language.equals(language)) {
            this.language = language;
            this.writeNegatronInitialisationFile();
        }
    }

    public void updateCheatMenuEnabled(boolean cheatMenuEnabled) throws IOException, InterruptedException {
        this.cheatMenuEnabled = cheatMenuEnabled;
        this.writeNegatronInitialisationFile();
        this.writeMameInitialisationFile();
    }

    public void updateVsyncMethod(VsyncMethod vsync) throws IOException, InterruptedException {
        this.vsync = vsync;
        this.writeNegatronInitialisationFile();
        this.writeMameInitialisationFile();
    }

    public void updateSoundEnabled(boolean soundEnabled) throws IOException {
        this.soundEnabled = soundEnabled;
        this.writeNegatronInitialisationFile();
    }

    public void updateVideoEnabled(boolean videoEnabled) throws IOException {
        this.videoEnabled = videoEnabled;
        this.writeNegatronInitialisationFile();
    }

    public void updateView3dEnabled(boolean view3dEnabled) throws IOException {
        this.view3dEnabled = view3dEnabled;
        this.writeNegatronInitialisationFile();
    }

    public void updateFolderPath(Property property, int index, String path) throws IOException, InterruptedException {
        if (index != -1 && property.domain != Domain.EXTRAS_INFORMATION) {
            List<String> f = this.folders.get((Object)property);
            if (f == null) {
                f = new ArrayList<String>();
                this.folders.put(property, f);
            }
            while (index >= f.size()) {
                f.add("");
            }
            if (!path.equals(f.get(index))) {
                f.set(index, path);
            }
            this.writeInitialisationFile(property);
        }
    }

    public void updateFilePath(Property property, int index, String path, String charSet) throws IOException, InterruptedException {
        if (index != -1 && property.domain == Domain.EXTRAS_INFORMATION) {
            List<PathCharset> f = this.files.get((Object)property);
            if (f == null) {
                f = new ArrayList<PathCharset>();
                this.files.put(property, f);
            }
            if (f.size() <= index) {
                f.add(new PathCharset(path, charSet));
                this.writeInitialisationFile(property);
            } else if (!path.equals(f.get(index).getPathString()) || !charSet.equals(f.get(index).getCharSet())) {
                f.get(index).setPath(path);
                f.get(index).setCharSet(charSet);
                this.writeInitialisationFile(property);
            }
        }
    }

    public void updateMachinePrimaryPath(Property property, String text) throws IOException, InterruptedException {
        if (!text.equals(this.primaryMachineFolders.get((Object)property))) {
            this.primaryMachineFolders.put(property, text);
            this.writeInitialisationFile(property);
        }
    }

    public void updateSoftwarePrimaryPath(Property property, String text) throws IOException, InterruptedException {
        if (!text.equals(this.primarySoftwareFolders.get((Object)property))) {
            this.primarySoftwareFolders.put(property, text);
            this.writeInitialisationFile(property);
        }
    }

    public void updateTreeTableColumnsConfiguration(String id, Map<String, TreeTableColumnConfiguration> conf) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveTreeTableColumnsConfiguration(id, conf);
        }
    }

    public void updateTreeTableFlattenConfiguration(String id, boolean flatten) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveTreeTableFlattenConfiguration(id, flatten);
        }
    }

    public void updateTableColumnsConfiguration(String id, Map<String, TableColumnConfiguration> conf) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveTableColumnsConfiguration(id, conf);
        }
    }

    public void updateMainDividerPosition(double position) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveMainDividerPosition(position);
        }
    }

    public void updateMachineInformationTabIndex(int index) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveMachineInformationTabIndex(index);
        }
    }

    public void updateSoftwareInformationTabIndex(int index) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveSoftwareInformationTabIndex(index);
        }
    }

    public void updateGlobalConfigurationTabIndex(int index) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveGlobalConfigurationTabIndex(index);
        }
    }

    public void updateFilterConfiguration(UIConfigurationData data) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveFilterConfiguration(data);
        }
    }

    public void updateFilterConfiguration(String key, UIConfigurationData data) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveFilterConfiguration(key, data);
        }
    }

    public void updateLoopEnabled(boolean value) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveLoopEnabled(value);
        }
    }

    public void updateWindowWidth(int value) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveWindowWidth(value);
        }
    }

    public void updateWindowHeight(int value) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveWindowHeight(value);
        }
    }

    public void updateWindowMaximised(boolean value) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveWindowMaximised(value);
        }
    }

    public void updateWindowFullscreen(boolean value) throws IOException {
        if (this.uiConfigurationCache != null) {
            this.uiConfigurationCache.saveWindowFullscreen(value);
        }
    }

    public void addPath(Property property, String path, String charSet) {
        if (property.domain == Domain.EXTRAS_INFORMATION) {
            this.files.get((Object)property).add(new PathCharset(path, charSet));
        } else {
            this.folders.get((Object)property).add(path);
        }
    }

    public void removePath(Property property, int index) throws IOException, InterruptedException {
        if (property.domain == Domain.EXTRAS_INFORMATION) {
            if (index < this.files.get((Object)property).size()) {
                this.files.get((Object)property).remove(index);
            }
        } else if (index < this.folders.get((Object)property).size()) {
            this.folders.get((Object)property).remove(index);
        }
        this.writeInitialisationFile(property);
    }
}

