/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.babelsoft.negatron.io.configuration.Domain;
import net.babelsoft.negatron.util.Shell;

public enum Property {
    ARTWORK("artpath", Domain.MAME_FOLDER_ONLY, "artwork"),
    ARTWORK_PREVIEW("artpreviewpath", Domain.EXTRAS_MACHINE_ONLY, "artpreview|M"),
    BOSS("bosspath", Domain.EXTRAS_MACHINE_ONLY, "bosses|M"),
    BOX_ART("boxartpath", Domain.EXTRAS_SOFTWARE_ONLY, "boxart|S"),
    CABINET("cabinetpath", Domain.EXTRAS_MACHINE_ONLY, "cabinets|M"),
    CHEAT("cheatpath", Domain.MAME_FILE_FOLDER, "cheat"),
    CONTROL_PANEL("cpanelpath", Domain.EXTRAS_MACHINE_ONLY, "cpanel|M"),
    CONTROLLER("ctrlrpath", Domain.MAME_FOLDER_ONLY, "ctrlr"),
    COVER("coverpath", Domain.EXTRAS_SOFTWARE_ONLY, "covers_SL|S"),
    DEVICE("devicepath", Domain.EXTRAS_MACHINE_ONLY, "devices|M"),
    END("endpath", Domain.EXTRAS_MACHINE_ONLY, "ends|M"),
    FLYER("flyerpath", Domain.EXTRAS_MACHINE_ONLY, "flyers|M"),
    FOLDER_VIEW("folderviewpath", Domain.EXTRAS_GENERIC, "folders"),
    GAME_OVER("gameoverpath", Domain.EXTRAS_MACHINE_ONLY, "gameover|M"),
    HASH("hashpath", Domain.MAME_FOLDER_ONLY, new String[0]),
    HOW_TO("howtopath", Domain.EXTRAS_MACHINE_ONLY, "howto|M"),
    INFORMATION("informationpath", Domain.EXTRAS_INFORMATION, "dats/history.dat|UTF-8", "dats/sysinfo.dat|ISO-8859-1", "dats/mameinfo.dat|ISO-8859-1", "dats/messinfo.dat|UTF-8", "dats/gameinit.dat|UTF-8", "dats/story.dat|UTF-8"),
    ICON("iconpath", Domain.EXTRAS_MACHINE_SOFTWARE, "icons|SM"),
    LOGO("logopath", Domain.EXTRAS_MACHINE_ONLY, "logo|M"),
    MANUAL("manualpath", Domain.EXTRAS_MACHINE_SOFTWARE, "manuals|M", "manuals_SL|S"),
    MARQUEE("marqueepath", Domain.EXTRAS_MACHINE_ONLY, "marquees|M"),
    MEDIA("mediapath", Domain.EXTRAS_SOFTWARE_ONLY, "media|S"),
    PCB("pcbpath", Domain.EXTRAS_MACHINE_ONLY, "pcb|M"),
    ROM("rompath", Domain.MAME_FOLDER_ONLY, new String[0]),
    SAMPLE("samplepath", Domain.MAME_FOLDER_ONLY, "samples"),
    SCORE("scorepath", Domain.EXTRAS_MACHINE_ONLY, "scores|M"),
    SELECT("selectpath", Domain.EXTRAS_MACHINE_ONLY, "select|M"),
    SNAPSHOT("snapshotpath", Domain.EXTRAS_MACHINE_SOFTWARE, "snap|M", "snap_SL|S"),
    SOUNDTRACK("soundtrackpath", Domain.MULTIMEDIA_MACHINE_ONLY, "soundtrack|M"),
    TITLE("titlepath", Domain.EXTRAS_MACHINE_SOFTWARE, "titles|M", "titles_SL|S"),
    VERSUS("versuspath", Domain.EXTRAS_MACHINE_ONLY, "versus|M"),
    VIDEO_PREVIEW("videopreviewpath", Domain.MULTIMEDIA_MACHINE_SOFTWARE, "videosnaps|M", "videosnaps_SL|S");

    final String name;
    final boolean isMamePath;
    final boolean isExtrasPath;
    final boolean isMultimediaPath;
    final List<String> defaultFolders;
    final Map<String, String> defaultFiles;
    final Domain domain;
    String defaultPrimaryMachineFolder;
    String defaultPrimarySoftwareFolder;
    boolean hasMachinePrimaryPath;
    boolean hasSoftwarePrimaryPath;

    private Property(String name, Domain domain, String ... defaultFoldersFiles) {
        this.name = name;
        this.domain = domain;
        this.defaultPrimaryMachineFolder = null;
        this.defaultPrimarySoftwareFolder = null;
        this.hasMachinePrimaryPath = false;
        this.hasSoftwarePrimaryPath = false;
        if (domain == Domain.EXTRAS_INFORMATION) {
            this.defaultFiles = new LinkedHashMap<String, String>();
            this.defaultFolders = null;
            Arrays.stream(defaultFoldersFiles).forEachOrdered(defaultFile -> {
                String[] fileCharset = defaultFile.split("\\|");
                if (Shell.isWindows()) {
                    fileCharset[0] = fileCharset[0].replace("/", "\\");
                }
                this.defaultFiles.put(fileCharset[0], fileCharset[1]);
            });
        } else {
            this.defaultFiles = null;
            this.defaultFolders = new ArrayList<String>();
            Arrays.stream(defaultFoldersFiles).forEachOrdered(defaultFolder -> {
                String[] folderPrimary = defaultFolder.split("\\|");
                this.defaultFolders.add(folderPrimary[0]);
                if (folderPrimary.length > 1) {
                    if (folderPrimary[1].contains("M")) {
                        this.defaultPrimaryMachineFolder = folderPrimary[0];
                        this.hasMachinePrimaryPath = true;
                    }
                    if (folderPrimary[1].contains("S")) {
                        this.defaultPrimarySoftwareFolder = folderPrimary[0];
                        this.hasSoftwarePrimaryPath = true;
                    }
                }
            });
        }
        this.isMamePath = domain == Domain.MAME_FOLDER_ONLY || domain == Domain.MAME_FILE_FOLDER;
        this.isMultimediaPath = domain == Domain.MULTIMEDIA_MACHINE_ONLY || domain == Domain.MULTIMEDIA_MACHINE_SOFTWARE;
        this.isExtrasPath = !this.isMamePath && !this.isMultimediaPath;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public boolean hasMachinePrimaryPath() {
        return this.hasMachinePrimaryPath;
    }

    public boolean hasSoftwarePrimaryPath() {
        return this.hasSoftwarePrimaryPath;
    }

    public boolean isMamePath() {
        return this.isMamePath;
    }

    public boolean isExtrasPath() {
        return this.isExtrasPath;
    }

    public boolean isMultimediaPath() {
        return this.isMultimediaPath;
    }
}

