/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.extras;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.babelsoft.negatron.io.cache.Cache;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Property;

public class Extras {
    private static final int BUFFER_SIZE = 2048;
    private static final String PDF_EXT = ".pdf";
    private static final String TXT_EXT = ".txt";
    private static final String ZIP_EXT = ".zip";

    private Extras() {
    }

    public static Path toPath(String name, Property property, String ... extensions) {
        return Extras.toPath(null, name, property, extensions);
    }

    public static Path toPath(String system, String name, Property property, String ... extensions) {
        return Arrays.stream(extensions).flatMap(extension -> Configuration.Manager.getFolderPaths(property).stream().filter(stringPath -> {
            Path path = Paths.get(stringPath, new String[0]);
            return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
        }).map(stringPath -> {
            if (system != null) {
                return Paths.get(stringPath, system, name + extension);
            }
            return Paths.get(stringPath, name + extension);
        }).filter(path -> Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]))).findAny().orElse(null);
    }

    public static String toPrimaryPath(String name, Property property) {
        return Extras.toPrimaryPath(null, name, property);
    }

    public static String toPrimaryPath(String system, String name, Property property) {
        if (name == null) {
            return null;
        }
        if (system != null) {
            String path = Configuration.Manager.getPrimarySoftwareFolder(property);
            return Paths.get(path, system, name).toString();
        }
        String path = Configuration.Manager.getPrimaryMachineFolder(property);
        return Paths.get(path, name).toString();
    }

    public static Path toPdfPath(String system, String name, Property property) {
        Path path;
        block28: {
            path = Extras.toPath(system, name, property, PDF_EXT);
            if (path == null) {
                try (InputStream stream = Extras.newZipInputStream(system, name, property, PDF_EXT);){
                    if (stream == null) break block28;
                    Path tmpPath = Cache.ROOT_FOLDER.resolve("tmp.pdf");
                    try (FileOutputStream file = new FileOutputStream(tmpPath.toFile());){
                        int count;
                        byte[] buffer = new byte[2048];
                        while ((count = stream.read(buffer, 0, 2048)) != -1) {
                            file.write(buffer, 0, count);
                        }
                        file.close();
                        path = tmpPath;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return path;
    }

    private static Stream<String> toZipPath(String system, String name, String ... extensions) {
        ArrayList res = new ArrayList();
        Arrays.stream(extensions).forEach(extension -> res.add((system != null ? system + "/" : "") + name + extension));
        return res.stream();
    }

    public static InputStream newInputStream(String name, Property property, String ... extensions) throws IOException {
        return Extras.newInputStream(null, name, property, extensions);
    }

    public static InputStream newInputStream(String system, String name, Property property, String ... extensions) throws IOException {
        Path path = Extras.toPath(system, name, property, extensions);
        if (path != null) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        return Extras.newZipInputStream(system, name, property, extensions);
    }

    /*
     * Exception decompiling
     */
    public static InputStream newInputStream(ZipFile file, ZipEntry entry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream newZipInputStream(String system, String name, Property property, String ... extensions) throws IOException {
        return Configuration.Manager.getFolderPaths(property).stream().map(stringPath -> stringPath.endsWith(ZIP_EXT) ? stringPath : stringPath + ZIP_EXT).filter(stringPath -> {
            Path path = Paths.get(stringPath, new String[0]);
            return Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]);
        }).map(stringPath -> {
            try (ZipFile file = new ZipFile((String)stringPath);){
                InputStream inputStream = Extras.toZipPath(system, name, extensions).map(zipPath -> file.getEntry((String)zipPath)).filter(zipEntry -> zipEntry != null && !zipEntry.isDirectory()).findFirst().map(entry -> Extras.newInputStream(file, entry)).orElse(null);
                return inputStream;
            }
            catch (IOException ex) {
                return null;
            }
        }).filter(inputStream -> inputStream != null).findFirst().orElse(null);
    }

    private static Path getDocumentPath(String wantedFilenameMask, final String removingExpression, String resource) throws IOException {
        String version = Extras.class.getPackage().getImplementationVersion();
        Path defaultDocumentPath = Paths.get(".", String.format(wantedFilenameMask, version));
        if (Files.notExists(defaultDocumentPath, new LinkOption[0])) {
            Files.walkFileTree(Paths.get(".", new String[0]), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getName(file.getNameCount() - 1).toString().matches(removingExpression)) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            Files.copy(Extras.class.getResourceAsStream("/net/babelsoft/negatron/resource/" + resource), defaultDocumentPath, new CopyOption[0]);
        }
        return defaultDocumentPath;
    }

    public static String getDefaultPdfPath() throws IOException {
        return Extras.getDocumentPath("Negatron Manual v%s.pdf", "Negatron Manual[\\s\\S]*\\.pdf", "Negatron Manual.pdf").toString();
    }

    public static String getDefaultInformationContent() throws IOException {
        Path path = Extras.getDocumentPath("readme-v%s.txt", "readme[\\s\\S]*\\.txt", "readme.txt");
        return Files.lines(path).collect(Collectors.joining("\n"));
    }
}

