/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.extras;

import com.twelvemonkeys.image.ResampleOp;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.GrayFilter;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.extras.Extras;

public class Icons {
    public static final String EXTENSION = ".ico";
    public static final javafx.scene.image.Image DEFAULT_ICON = new javafx.scene.image.Image(Icons.class.getResourceAsStream("/net/babelsoft/negatron/resource/icon/Negatron.png"));

    private Icons() {
    }

    private static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bImg = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bImg.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bImg;
    }

    public static javafx.scene.image.Image newImage(Path path) throws IOException {
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            javafx.scene.image.Image image = Icons.newImage(stream, 0, false);
            return image;
        }
    }

    public static javafx.scene.image.Image newImage(String name) throws IOException {
        return Icons.newImage(name, 0, false);
    }

    public static javafx.scene.image.Image newImage(String name, int size) throws IOException {
        return Icons.newImage(name, size, false);
    }

    public static javafx.scene.image.Image newGreyImage(String name, int size) throws IOException {
        return Icons.newImage(name, size, true);
    }

    public static javafx.scene.image.Image newImage(String name, int size, boolean requestGrey) throws IOException {
        try (InputStream stream = Extras.newInputStream(name, Property.ICON, EXTENSION);){
            javafx.scene.image.Image image = Icons.newImage(stream, size, requestGrey);
            return image;
        }
    }

    public static javafx.scene.image.Image newImage(Path path, int size) throws IOException {
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            javafx.scene.image.Image image = Icons.newImage(stream, size, false);
            return image;
        }
    }

    public static javafx.scene.image.Image newImage(ZipFile file, ZipEntry entry, int size) throws IOException {
        try (InputStream stream = Extras.newInputStream(file, entry);){
            javafx.scene.image.Image image = Icons.newImage(stream, size, false);
            return image;
        }
    }

    public static javafx.scene.image.Image newImage(InputStream stream, int size, boolean requestGrey) throws IOException {
        if (stream != null) {
            try (ImageInputStream imageStream = ImageIO.createImageInputStream(stream);){
                ImageReader reader = ImageIO.getImageReaders(imageStream).next();
                reader.setInput(imageStream);
                BufferedImage image = reader.read(0, null);
                if (size > 0) {
                    ResampleOp resampler = new ResampleOp(size, size, 3);
                    image = resampler.filter(image, null);
                }
                if (requestGrey) {
                    image = Icons.toBufferedImage(GrayFilter.createDisabledImage(image));
                }
                WritableImage writableImage = SwingFXUtils.toFXImage((BufferedImage)image, null);
                return writableImage;
            }
        }
        return null;
    }
}

