/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.loader;

import java.util.HashMap;
import java.util.function.BiConsumer;
import net.babelsoft.negatron.io.loader.EmulatedItemFactory;
import net.babelsoft.negatron.model.item.EmulatedItem;
import net.babelsoft.negatron.util.function.HexaConsumer;
import net.babelsoft.negatron.util.function.PentaConsumer;
import net.babelsoft.negatron.util.function.TetraConsumer;
import net.babelsoft.negatron.util.function.TriConsumer;
import net.babelsoft.negatron.util.function.TriFunction;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class EmulatedItemListDataHandler<T extends EmulatedItem<T>>
extends DefaultHandler {
    private final HashMap<String, T> map;
    private final EmulatedItemFactory<T> factory;
    protected T currentItem;
    private StringBuilder text;

    public EmulatedItemListDataHandler(EmulatedItemFactory<T> factory) {
        this.factory = factory;
        this.map = new HashMap();
    }

    protected void buildCurrentItem(String name, String group, String cloneof) {
        this.currentItem = (EmulatedItem)this.map.get(name);
        if (this.currentItem == null) {
            this.currentItem = this.factory.create(name, group);
            if (cloneof == null) {
                this.map.put(name, this.currentItem);
            }
        }
        if (cloneof != null) {
            EmulatedItem parent = (EmulatedItem)this.map.get(cloneof);
            if (parent == null) {
                parent = this.factory.create(cloneof, group);
                this.map.put(cloneof, parent);
            }
            this.currentItem.setParent((EmulatedItem)parent);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "description": 
            case "year": {
                this.startTextElement();
            }
        }
    }

    protected void startTextElement() {
        if (this.currentItem != null) {
            this.text = new StringBuilder();
        }
    }

    protected <V> void startConsumeCurrentItem(BiConsumer<T, V> consumer, V value) {
        if (this.currentItem != null) {
            consumer.accept(this.currentItem, value);
        }
    }

    protected <U, V> void startConsumeCurrentItem(TriConsumer<T, U, V> consumer, U value1, V value2) {
        if (this.currentItem != null) {
            consumer.accept(this.currentItem, value1, value2);
        }
    }

    protected <U, V, W> void startConsumeCurrentItem(TetraConsumer<T, U, V, W> consumer, U value1, V value2, W value3) {
        if (this.currentItem != null) {
            consumer.accept(this.currentItem, value1, value2, value3);
        }
    }

    protected <U, V, W, X> void startConsumeCurrentItem(PentaConsumer<T, U, V, W, X> consumer, U value1, V value2, W value3, X value4) {
        if (this.currentItem != null) {
            consumer.accept(this.currentItem, value1, value2, value3, value4);
        }
    }

    protected <U, V, W, X, Y> void startConsumeCurrentItem(HexaConsumer<T, U, V, W, X, Y> consumer, U value1, V value2, W value3, X value4, Y value5) {
        if (this.currentItem != null) {
            consumer.accept(this.currentItem, value1, value2, value3, value4, value5);
        }
    }

    protected <U, V, R> R startApplyOnCurrentItem(TriFunction<T, U, V, R> function, U value1, V value2) {
        if (this.currentItem != null) {
            return function.apply(this.currentItem, value1, value2);
        }
        return null;
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.text != null) {
            this.text.append(chars, start, length);
        }
    }

    protected <S> void endConsumeCurrentItem(BiConsumer<S, T> consumer, S operand) {
        if (this.currentItem != null) {
            consumer.accept(operand, this.currentItem);
            this.currentItem = null;
        }
    }

    protected void endTextElement(BiConsumer<T, String> consumer) {
        if (this.text != null) {
            consumer.accept(this.currentItem, this.text.toString());
            this.text = null;
        }
    }

    protected <V> void endTextElement(TriConsumer<T, String, V> consumer, V value) {
        if (this.text != null) {
            consumer.accept(this.currentItem, this.text.toString(), value);
            this.text = null;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        switch (qName) {
            case "description": {
                this.endTextElement(EmulatedItem::setDescription);
                break;
            }
            case "year": {
                this.endTextElement(EmulatedItem::setYear);
            }
        }
    }
}

