/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.loader;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.FavouriteConfiguration;
import net.babelsoft.negatron.io.configuration.FavouriteTree;
import net.babelsoft.negatron.io.loader.MachineListLoader;
import net.babelsoft.negatron.model.component.Bios;
import net.babelsoft.negatron.model.component.BiosSet;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.model.component.MachineElementList;
import net.babelsoft.negatron.model.component.Ram;
import net.babelsoft.negatron.model.component.RamOption;
import net.babelsoft.negatron.model.component.Slot;
import net.babelsoft.negatron.model.component.SlotOption;
import net.babelsoft.negatron.model.favourites.Favourite;
import net.babelsoft.negatron.model.favourites.Folder;
import net.babelsoft.negatron.model.favourites.MachineConfiguration;
import net.babelsoft.negatron.model.favourites.Separator;
import net.babelsoft.negatron.model.favourites.SoftwareConfiguration;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.model.item.SoftwareList;
import net.babelsoft.negatron.view.control.tree.CopyPastableTreeItem;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FavouriteLoader
implements Callable<FavouriteTree> {
    private final Map<String, Machine> machines;
    private final Map<String, SoftwareList> softwareLists;

    public FavouriteLoader(Map<String, Machine> machines, Map<String, SoftwareList> softwareLists) {
        this.machines = machines;
        this.softwareLists = softwareLists;
    }

    @Override
    public FavouriteTree call() throws Exception {
        if (!Files.exists(FavouriteConfiguration.FAV_PATH, new LinkOption[0])) {
            return null;
        }
        FavouriteDataHandler dataHandler = new FavouriteDataHandler();
        try (InputStream dataStream = Files.newInputStream(FavouriteConfiguration.FAV_PATH, new OpenOption[0]);){
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(false);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            xmlReader.setContentHandler(dataHandler);
            xmlReader.parse(new InputSource(dataStream));
        }
        catch (Exception ex) {
            Logger.getLogger(MachineListLoader.class.getName()).log(Level.SEVERE, "An error occured while loading favourites", ex);
        }
        return dataHandler.result();
    }

    private class FavouriteDataHandler
    extends DefaultHandler {
        private final FavouriteTree favouriteTree = new FavouriteTree();
        private CopyPastableTreeItem parentItem;
        private Favourite favourite;
        private boolean configurable;
        private MachineElementList parameters;
        private Device device;
        private StringBuilder commandLine;

        private Slot findSlot(Slot refSlot, String fullname, String name) {
            List<Slot> slots;
            String parentName = name;
            int j = parentName.indexOf(":");
            String value = parentName.substring(0, j);
            SlotOption option = refSlot.getOptions().stream().filter(o -> o.getName().equals(value)).findAny().orElse(null);
            if (option != null && (slots = option.getDevice().getSlots()) != null) {
                String slotName = name.substring(j);
                refSlot = slots.stream().filter(s -> slotName.startsWith(s.getName())).findAny().orElse(null);
                if (refSlot != null) {
                    int k = refSlot.getName().length();
                    if (k < slotName.length()) {
                        return this.findSlot(refSlot, fullname, slotName.substring(k + 2));
                    }
                    return refSlot.copy(fullname);
                }
            }
            return null;
        }

        public FavouriteTree result() {
            return this.favouriteTree;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            switch (qName) {
                case "root": {
                    Folder root = new Folder(atts.getValue("name"), LocalDateTime.parse(atts.getValue("dateCreated")), LocalDateTime.parse(atts.getValue("dateModified")));
                    this.parentItem = new CopyPastableTreeItem(root);
                    this.favouriteTree.setRoot(this.parentItem);
                    return;
                }
                case "folder": {
                    Folder folder = new Folder(atts.getValue("name"), LocalDateTime.parse(atts.getValue("dateCreated")), LocalDateTime.parse(atts.getValue("dateModified")));
                    CopyPastableTreeItem item = new CopyPastableTreeItem(folder);
                    this.parentItem.getInternalChildren().add((Object)item);
                    this.parentItem = item;
                    this.favouriteTree.addFolder(folder);
                    return;
                }
                case "children": {
                    return;
                }
                case "separator": {
                    Separator separator = new Separator(LocalDateTime.parse(atts.getValue("dateCreated")), LocalDateTime.parse(atts.getValue("dateModified")));
                    CopyPastableTreeItem item = new CopyPastableTreeItem(separator);
                    this.parentItem.getInternalChildren().add((Object)item);
                    return;
                }
                case "favourite": {
                    this.favourite = new Favourite(atts.getValue("name"), null, null, null, LocalDateTime.parse(atts.getValue("dateCreated")), LocalDateTime.parse(atts.getValue("dateModified")));
                    CopyPastableTreeItem item = new CopyPastableTreeItem(this.favourite);
                    this.parentItem.getInternalChildren().add((Object)item);
                    return;
                }
                case "machineConfiguration": {
                    Machine machine = (Machine)FavouriteLoader.this.machines.get(atts.getValue("name"));
                    if (machine == null) {
                        machine = new Machine(atts.getValue("name"), "");
                        machine.setDescription(atts.getValue("description"));
                    }
                    this.favourite.resetMachine(machine);
                    this.configurable = Boolean.parseBoolean(atts.getValue("configurable"));
                    return;
                }
                case "commandLine": {
                    this.commandLine = new StringBuilder();
                    return;
                }
                case "parameters": {
                    this.parameters = new MachineElementList(this.favourite.getMachine());
                    return;
                }
                case "bios": {
                    Bios bios = new Bios();
                    if (atts.getValue("name") != null) {
                        BiosSet set = new BiosSet(atts.getValue("name"), atts.getValue("description"));
                        String isDefault = atts.getValue("default");
                        bios.addOption(set, isDefault != null && isDefault.equals(Boolean.TRUE.toString()));
                        bios.setValue(set);
                    } else {
                        bios.setDefaultValue();
                    }
                    this.parameters.add(bios);
                    return;
                }
                case "ramsize": {
                    Ram ram = new Ram();
                    if (atts.getValue("value") != null) {
                        RamOption option = new RamOption(atts.getValue("value"));
                        String isDefault = atts.getValue("default");
                        ram.addOption(option, isDefault != null && isDefault.equals(Boolean.TRUE.toString()));
                        ram.setValue(option);
                    } else {
                        ram.setDefaultValue();
                    }
                    this.parameters.add(ram);
                    return;
                }
                case "device": {
                    this.device = new Device(atts.getValue("name"), atts.getValue("type"), atts.getValue("tag"), Boolean.parseBoolean(atts.getValue("mandatory")));
                    this.device.setCompatibleSoftwareLists(Boolean.parseBoolean(atts.getValue("compatibleSoftwareLists")));
                    if (atts.getValue("value") != null) {
                        this.device.setValue(atts.getValue("value"));
                    }
                    this.parameters.add(this.device);
                    return;
                }
                case "interfaces": {
                    return;
                }
                case "interface": {
                    this.device.addInterfaceFormat(atts.getValue("name"));
                    return;
                }
                case "extensions": {
                    Arrays.stream(atts.getValue("names").split(",")).forEach(ext -> this.device.addExtension((String)ext));
                    return;
                }
                case "slot": {
                    if (Configuration.Manager.isAsyncExecutionMode()) {
                        Slot slot = new Slot(atts.getValue("name"));
                        if (atts.getValue("value") != null) {
                            SlotOption option = new SlotOption(atts.getValue("value"), atts.getValue("description"));
                            String isDefault = atts.getValue("default");
                            slot.addOption(option, isDefault != null && isDefault.equals(Boolean.TRUE.toString()));
                            slot.setValue(option);
                        } else {
                            slot.setDefaultValue();
                        }
                        this.parameters.add(slot);
                        return;
                    }
                    Slot refSlot = this.favourite.getMachine().getSlots().stream().filter(s -> s.getName().equals(atts.getValue("name"))).findAny().orElse(null);
                    Slot slot = null;
                    if (refSlot != null) {
                        slot = refSlot.copy();
                    } else {
                        int i;
                        String name;
                        String parentName = name = atts.getValue("name");
                        while ((i = parentName.lastIndexOf(":")) > 0) {
                            String filter = parentName.substring(0, i);
                            refSlot = this.favourite.getMachine().getSlots().stream().filter(s -> s.getName().equals(filter)).findAny().orElse(null);
                            if (refSlot != null) {
                                slot = this.findSlot(refSlot, name, name.substring(i + 1));
                                break;
                            }
                            parentName = filter;
                        }
                    }
                    if (slot == null) return;
                    if (atts.getValue("value") == null) return;
                    SlotOption option = slot.getOptions().stream().filter(o -> o.getName().equals(atts.getValue("value"))).findAny().orElse(null);
                    if (option == null) return;
                    slot.setValue(option);
                    this.parameters.add(slot);
                    return;
                }
                case "softwareConfiguration": {
                    Software software = null;
                    SoftwareList softwareList = (SoftwareList)FavouriteLoader.this.softwareLists.get(atts.getValue("list"));
                    if (softwareList != null) {
                        software = softwareList.getSoftware(atts.getValue("name"));
                    }
                    if (software == null) {
                        software = new Software(atts.getValue("name"), "");
                        software.setDescription(atts.getValue("description"));
                    }
                    String deviceName = atts.getValue("device");
                    this.device = this.favourite.getMachineConfiguration().getParameters().stream().filter(parameter -> parameter instanceof Device).map(parameter -> (Device)parameter).filter(parameter -> parameter.getName().equals(deviceName)).findAny().orElse(null);
                    SoftwareConfiguration softwareConfiguration = new SoftwareConfiguration(this.favourite.getMachine(), this.device, software);
                    this.favourite.resetSoftwareConfiguration(softwareConfiguration);
                    return;
                }
            }
            throw new RuntimeException("Unknown XML element during favourites parsing: " + qName);
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (this.commandLine != null) {
                this.commandLine.append(chars, start, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            switch (qName) {
                case "folder": {
                    this.parentItem = (CopyPastableTreeItem)this.parentItem.getParent();
                    break;
                }
                case "favourite": {
                    if (this.favourite.getMachine() == null) {
                        this.favourite.resetMachine();
                        this.favouriteTree.addEmptyFavourite(this.favourite);
                    }
                    this.favourite.checkValidity();
                    this.favourite = null;
                    break;
                }
                case "machineConfiguration": {
                    if (this.favourite.getMachineConfiguration() != null) break;
                    this.favourite.resetMachineConfiguration(new MachineConfiguration(new MachineElementList(this.favourite.getMachine()), this.configurable));
                    break;
                }
                case "commandLine": {
                    this.favourite.resetMachineConfiguration(new MachineConfiguration(this.commandLine.toString()));
                    this.commandLine = null;
                    break;
                }
                case "parameters": {
                    this.favourite.resetMachineConfiguration(new MachineConfiguration(this.parameters, this.configurable));
                    this.parameters = null;
                    break;
                }
                case "device": {
                    if (Configuration.Manager.isSyncExecutionMode() && this.device.getExtensions().isEmpty()) {
                        this.favourite.setMustMigrate(true);
                    }
                    this.device = null;
                }
            }
        }
    }
}

