/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.loader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javafx.scene.image.Image;
import net.babelsoft.negatron.io.cache.IconCache;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.extras.Icons;
import net.babelsoft.negatron.io.loader.InitialisedCallable;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.SoftwareList;
import net.babelsoft.negatron.util.IterableEnumeration;
import net.babelsoft.negatron.util.function.Delegate;

public class IconLoader
implements InitialisedCallable<Void> {
    private static final String ZIP_EXT = ".zip";
    private final IconCache cache;
    private Map<String, Machine> machines;

    public IconLoader(IconCache cache) {
        this.cache = cache;
    }

    private void updateUI(String name) {
        Machine machine = this.machines.get(name);
        if (machine != null) {
            machine.setIcon(this.cache.get(name));
        }
    }

    @Override
    public void initialise(Map<String, Machine> machines, Map<String, SoftwareList> softwareLists) {
        this.machines = machines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        Path zipPath;
        try {
            this.cache.load();
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(IconLoader.class.getName()).log(Level.SEVERE, "Couldn't load icon cache, format may have changed, still re-building cache from source files", ex);
        }
        this.cache.getKeys().forEach(name -> this.updateUI((String)name));
        boolean isModified = false;
        ArrayList<String> batch = new ArrayList<String>();
        int cutoffSize = 1000;
        Delegate batchUpdateUI = () -> {
            batch.forEach(id -> this.updateUI((String)id));
            batch.clear();
        };
        for (String folder : Configuration.Manager.getFolderPaths(Property.ICON)) {
            String zip;
            Image image;
            Instant timestamp;
            Path folderPath = Paths.get(folder, new String[0]);
            if (Files.exists(folderPath, new LinkOption[0]) && Files.isDirectory(folderPath, new LinkOption[0])) {
                try (Stream<Path> iconPaths = Files.list(folderPath);){
                    for (Path path : (Path[])iconPaths.toArray(Path[]::new)) {
                        String key2 = this.cache.pathToKey(path);
                        Instant version = this.cache.getVersion(key2);
                        timestamp = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
                        if (version == null || !version.equals(timestamp)) {
                            image = Icons.newImage(path, 16);
                            this.cache.putVersion(key2, timestamp);
                            this.cache.put(key2, image);
                            batch.add(key2);
                            if (batch.size() > 1000) {
                                batchUpdateUI.fire();
                            }
                            if (!isModified) {
                                isModified = true;
                            }
                        }
                        if (!Thread.interrupted()) continue;
                        image = null;
                        return image;
                    }
                }
            }
            if (!(zip = folder).endsWith(ZIP_EXT)) {
                zip = zip + ZIP_EXT;
            }
            if (!Files.exists(zipPath = Paths.get(zip, new String[0]), new LinkOption[0]) || Files.isDirectory(zipPath, new LinkOption[0])) continue;
            ZipFile zipFile2 = new ZipFile(zip);
            Throwable throwable = null;
            try {
                for (ZipEntry zipEntry : IterableEnumeration.make(zipFile2.entries())) {
                    String key2;
                    if (!zipEntry.isDirectory()) {
                        key2 = this.cache.pathToKey(Paths.get(zipEntry.getName(), new String[0]));
                        Instant version2 = this.cache.getVersion(key2);
                        timestamp = zipEntry.getLastModifiedTime().toInstant();
                        if (version2 == null || !version2.equals(timestamp)) {
                            image = Icons.newImage(zipFile2, zipEntry, 16);
                            this.cache.putVersion(key2, timestamp);
                            this.cache.put(key2, image);
                            batch.add(key2);
                            if (batch.size() > 1000) {
                                batchUpdateUI.fire();
                            }
                            if (!isModified) {
                                isModified = true;
                            }
                        }
                    }
                    if (!Thread.interrupted()) continue;
                    key2 = null;
                    return key2;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (zipFile2 == null) continue;
                if (throwable != null) {
                    try {
                        zipFile2.close();
                    }
                    catch (Throwable version2) {
                        throwable.addSuppressed(version2);
                    }
                    continue;
                }
                zipFile2.close();
            }
        }
        batchUpdateUI.fire();
        if (isModified) {
            this.cache.save();
            isModified = false;
        }
        ArrayList<String> keysToRemove = new ArrayList<String>();
        HashMap<String, ZipFile> zipFiles = new HashMap<String, ZipFile>();
        try {
            for (String zip : Configuration.Manager.getFolderPaths(Property.ICON)) {
                if (!zip.endsWith(ZIP_EXT)) {
                    zip = zip + ZIP_EXT;
                }
                if (!Files.exists(zipPath = Paths.get(zip, new String[0]), new LinkOption[0]) || Files.isDirectory(zipPath, new LinkOption[0])) continue;
                try {
                    ZipFile zipFile3 = new ZipFile(zip);
                    zipFiles.put(zip, zipFile3);
                }
                catch (Exception zipFile3) {}
            }
            Set<String> keys = this.cache.getKeys();
            for (String key3 : keys) {
                boolean exists = false;
                for (String folder : Configuration.Manager.getFolderPaths(Property.ICON)) {
                    ZipEntry zipEntry;
                    ZipFile zipFile4;
                    Path path = Paths.get(folder, key3 + ".ico");
                    if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                        exists = true;
                        break;
                    }
                    String zip = folder;
                    if (!zip.endsWith(ZIP_EXT)) {
                        zip = zip + ZIP_EXT;
                    }
                    if ((zipFile4 = (ZipFile)zipFiles.get(zip)) == null || (zipEntry = zipFile4.getEntry(key3 + ".ico")) == null || zipEntry.isDirectory()) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    keysToRemove.add(key3);
                }
                if (!Thread.interrupted()) continue;
                Iterator<String> iterator = null;
                return iterator;
            }
        }
        finally {
            zipFiles.values().forEach(zipFile -> {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (keysToRemove.size() > 0) {
            keysToRemove.forEach(key -> {
                this.cache.remove((String)key);
                this.updateUI((String)key);
            });
            if (!isModified) {
                isModified = true;
            }
        }
        if (isModified) {
            this.cache.save();
        }
        return null;
    }
}

