/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.loader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.babelsoft.negatron.io.cache.InformationCache;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.configuration.PathCharset;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.loader.InformationData;
import net.babelsoft.negatron.io.loader.InitialisedCallable;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.SoftwareList;
import net.babelsoft.negatron.util.Strings;

public class InformationLoader
implements InitialisedCallable<Void> {
    private final InformationCache cache;
    private final Path datFilePath;

    public InformationLoader(InformationCache cache, Path datFilePath) {
        this.cache = cache;
        this.datFilePath = datFilePath;
    }

    @Override
    public void initialise(Map<String, Machine> machines, Map<String, SoftwareList> softwareLists) {
    }

    @Override
    public Void call() throws Exception {
        List<PathCharset> encodings = Configuration.Manager.getFilePaths(Property.INFORMATION);
        Optional<PathCharset> encoding = encodings.stream().filter(pathCharset -> pathCharset.getPath().equals(this.datFilePath)).findAny();
        CharsetDecoder decoder = Charset.forName(encoding.get().getCharSet()).newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        HashMap<String, List<String>> systemIndex = new HashMap<String, List<String>>();
        HashMap<String, Map<String, String>> itemIndex = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> information = new HashMap<String, Map<String, String>>();
        try (InputStream input = Files.newInputStream(this.datFilePath, new OpenOption[0]);
             InputStreamReader stream = new InputStreamReader(input, decoder);
             BufferedReader reader = new BufferedReader(stream);){
            String line;
            String systems = null;
            String items = null;
            boolean mustAppend = false;
            StringBuilder sb = null;
            while ((line = reader.readLine()) != null) {
                line = Strings.rtrim(line);
                if (!mustAppend && line.startsWith("$") && line.contains("=")) {
                    String[] systemItems = line.substring(1).split("=");
                    systems = systemItems[0];
                    items = systemItems[1];
                    sb = new StringBuilder();
                    mustAppend = true;
                    continue;
                }
                if (mustAppend && "$end".equals(line)) {
                    if (information.get(systems) == null) {
                        information.put(systems, new HashMap());
                    }
                    String content = sb.toString();
                    if (this.datFilePath.endsWith("sysinfo.dat")) {
                        Pattern pattern = Pattern.compile("\\S\\n\\n");
                        Matcher matcher = pattern.matcher(content);
                        sb = new StringBuilder();
                        int from = 0;
                        while (matcher.find()) {
                            int to = matcher.start();
                            sb.append(content.substring(from, to));
                            sb.append(matcher.group().charAt(0));
                            sb.append("\n");
                            from = matcher.end();
                        }
                        if (from != content.length() - 1) {
                            sb.append(content.substring(from));
                        }
                        content = sb.toString();
                        content = content.replaceAll("\\n{7}", "\n\n\n\n");
                        content = content.replaceAll("\\n{5}", "\n\n\n");
                        content = content.replaceAll("\\n{3}", "\n\n");
                    }
                    if (items.endsWith(",")) {
                        items = items.substring(0, items.length() - 1);
                    }
                    if (Strings.isValid(items)) {
                        Map systemMap = (Map)information.get(systems);
                        if (systemMap.get(items) != null) {
                            content = (String)systemMap.get(items) + content;
                        }
                        systemMap.put(items, content);
                        if (systems.contains(",")) {
                            for (String system : systems.split(",")) {
                                if (!Strings.isValid(system)) continue;
                                ArrayList<String> folders = (ArrayList<String>)systemIndex.get(system);
                                if (folders == null) {
                                    folders = new ArrayList<String>();
                                    systemIndex.put(system, folders);
                                }
                                if (!folders.contains(systems)) continue;
                                folders.add(systems);
                            }
                        }
                        if (items.contains(",")) {
                            for (String item : items.split(",")) {
                                if (!Strings.isValid(item)) continue;
                                HashMap<String, String> itemMap = (HashMap<String, String>)itemIndex.get(systems);
                                if (itemMap == null) {
                                    itemMap = new HashMap<String, String>();
                                    itemIndex.put(systems, itemMap);
                                }
                                itemMap.put(item, items);
                            }
                        }
                    }
                    sb = null;
                    mustAppend = false;
                    continue;
                }
                if (mustAppend && "$drv".equals(line)) {
                    sb = null;
                    mustAppend = false;
                    continue;
                }
                if (!mustAppend || "$bio".equals(line) || "$mame".equals(line) || "$story".equals(line)) continue;
                sb.append(line).append("\n");
            }
        }
        this.cache.save(new InformationData(this.datFilePath, information, systemIndex, itemIndex));
        return null;
    }
}

