/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.loader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javax.xml.parsers.SAXParserFactory;
import net.babelsoft.negatron.io.Mame;
import net.babelsoft.negatron.io.cache.MachineListCache;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.io.loader.EmulatedItemListDataHandler;
import net.babelsoft.negatron.model.component.SlotOption;
import net.babelsoft.negatron.model.item.EmulatedItem;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.SoftwareList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MachineListLoader
implements Callable<MachineListData> {
    private final Map<String, SoftwareList> softwareLists;
    private final SimpleDoubleProperty progressProperty;

    public MachineListLoader(Map<String, SoftwareList> softwareLists, SimpleDoubleProperty progressProperty) {
        this.softwareLists = softwareLists;
        this.progressProperty = progressProperty;
    }

    @Override
    public MachineListData call() throws Exception {
        long totalCount;
        Object stream;
        MachineListCache cache = new MachineListCache();
        if (cache.exists()) {
            try {
                this.progressProperty.set(0.0);
                Configuration.Manager.determineExecutionMode((String)cache.getVersion());
                MachineListCache.Data data = (MachineListCache.Data)cache.load();
                MachineListData result = new MachineListData(data);
                this.progressProperty.set(1.0);
                return result;
            }
            catch (Exception ex) {
                Logger.getLogger(MachineListLoader.class.getName()).log(Level.WARNING, "Cache has been corrupted, reload from source.", ex);
            }
        }
        Configuration.Manager.determineExecutionMode(cache.retrieveVersion());
        try (InputStream input = Mame.newInputStream("-ll");){
            stream = new InputStreamReader(input);
            Throwable throwable = null;
            try (BufferedReader reader2 = new BufferedReader((Reader)stream);){
                totalCount = reader2.lines().count();
            }
            catch (Throwable reader2) {
                throwable = reader2;
                throw reader2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            ((InputStreamReader)stream).close();
                        }
                        catch (Throwable reader2) {
                            throwable.addSuppressed(reader2);
                        }
                    } else {
                        ((InputStreamReader)stream).close();
                    }
                }
            }
        }
        MachineListDataHandler dataHandler = new MachineListDataHandler(this.softwareLists, totalCount);
        this.progressProperty.bind((ObservableValue)dataHandler.ProgressProperty());
        try {
            InputStream dataStream = Mame.newInputStream("-lx");
            stream = null;
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(false);
                XMLReader xmlReader = spf.newSAXParser().getXMLReader();
                xmlReader.setContentHandler(dataHandler);
                xmlReader.parse(new InputSource(dataStream));
            }
            catch (Throwable throwable) {
                stream = throwable;
                throw throwable;
            }
            finally {
                if (dataStream != null) {
                    if (stream != null) {
                        try {
                            dataStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)stream).addSuppressed(throwable);
                        }
                    } else {
                        dataStream.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MachineListLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        MachineListData result = dataHandler.result();
        try {
            cache.save(result.getList());
        }
        catch (Exception ex) {
            Logger.getLogger(MachineListLoader.class.getName()).log(Level.WARNING, "Couldn't save cache to file.", ex);
        }
        return result;
    }

    private static class MachineListDataHandler
    extends EmulatedItemListDataHandler<Machine> {
        private final Map<String, SoftwareList> softwareLists;
        private final SimpleDoubleProperty progressProperty = new SimpleDoubleProperty(0.0);
        private final long totalCount;
        private long currentCount;
        private final MachineListData machines = new MachineListData();
        private int biosCount;
        private int ramCount;
        private int slotOptionCount;
        private final Map<String, List<String>> internalDeviceMap;
        private final Map<String, List<SlotOption>> slotOptionMap;
        private Map<String, String> attributes;

        public MachineListDataHandler(Map<String, SoftwareList> softwareLists, long totalCount) {
            super((name, group) -> new Machine(name, group));
            this.softwareLists = softwareLists;
            this.totalCount = totalCount;
            this.currentCount = 0L;
            this.internalDeviceMap = new HashMap<String, List<String>>();
            this.slotOptionMap = new HashMap<String, List<SlotOption>>();
        }

        public ReadOnlyDoubleProperty ProgressProperty() {
            return this.progressProperty;
        }

        private void clone(Attributes atts) {
            this.attributes = new HashMap<String, String>();
            for (int i = 0; i < atts.getLength(); ++i) {
                this.attributes.put(atts.getLocalName(i), atts.getValue(i));
            }
        }

        public MachineListData result() {
            return this.machines;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            switch (qName) {
                case "machine": 
                case "game": {
                    if (!Configuration.Manager.isSyncExecutionMode() && !"yes".equals(atts.getValue("runnable"))) break;
                    this.buildCurrentItem(atts.getValue("name"), atts.getValue("sourcefile"), atts.getValue("cloneof"));
                    ((Machine)this.currentItem).setRunnable("yes".equals(atts.getValue("runnable")));
                    ((Machine)this.currentItem).setMechanical("yes".equals(atts.getValue("ismechanical")));
                    this.biosCount = 0;
                    this.ramCount = 0;
                    this.attributes = null;
                    break;
                }
                case "manufacturer": {
                    this.startTextElement();
                    break;
                }
                case "input": {
                    this.startConsumeCurrentItem(Machine::setCoinSlot, atts.getValue("coins") != null);
                    this.startConsumeCurrentItem(Machine::setServiceMode, "yes".equals(atts.getValue("service")));
                    this.startConsumeCurrentItem(Machine::setTilt, "yes".equals(atts.getValue("tilt")));
                    this.startConsumeCurrentItem(Machine::setMaxNumberPlayers, atts.getValue("players"));
                    break;
                }
                case "control": {
                    this.startConsumeCurrentItem(Machine::addControllerType, atts.getValue("type"));
                    break;
                }
                case "sound": {
                    this.startConsumeCurrentItem(Machine::setSoundType, atts.getValue("channels"));
                    break;
                }
                case "display": {
                    this.startConsumeCurrentItem(Machine::setDisplayType, atts.getValue("type"));
                    this.startConsumeCurrentItem(Machine::setScreenOrientation, atts.getValue("rotate"));
                    break;
                }
                case "driver": {
                    this.startConsumeCurrentItem(EmulatedItem::setSupport, atts.getValue("status"));
                    break;
                }
                case "biosset": {
                    if (++this.biosCount > 1) {
                        this.startConsumeCurrentItem(EmulatedItem::setConfigurable, true);
                    }
                    if (!Configuration.Manager.isSyncExecutionMode()) break;
                    this.startConsumeCurrentItem(Machine::addBiosSet, atts.getValue("name"), atts.getValue("description"), "yes".equals(atts.getValue("default")));
                    break;
                }
                case "ramoption": {
                    if (++this.ramCount > 1) {
                        this.startConsumeCurrentItem(EmulatedItem::setConfigurable, true);
                    }
                    if (!Configuration.Manager.isSyncExecutionMode()) break;
                    this.clone(atts);
                    this.startTextElement();
                    break;
                }
                case "device_ref": {
                    if (!Configuration.Manager.isSyncExecutionMode() || this.currentItem == null) break;
                    List<String> internalDevices = this.internalDeviceMap.get(((Machine)this.currentItem).getName());
                    if (internalDevices == null) {
                        internalDevices = new ArrayList<String>();
                        this.internalDeviceMap.put(((Machine)this.currentItem).getName(), internalDevices);
                    }
                    internalDevices.add(atts.getValue("name"));
                    break;
                }
                case "device": {
                    if (!Configuration.Manager.isSyncExecutionMode()) break;
                    this.clone(atts);
                    break;
                }
                case "instance": {
                    if (!Configuration.Manager.isSyncExecutionMode()) break;
                    this.startConsumeCurrentItem(Machine::addDevice, atts.getValue("name"), this.attributes.get("type"), this.attributes.get("tag"), this.attributes.get("interface"), this.attributes.get("mandatory") != null);
                    break;
                }
                case "extension": {
                    this.startConsumeCurrentItem(EmulatedItem::setConfigurable, true);
                    if (!Configuration.Manager.isSyncExecutionMode()) break;
                    this.startConsumeCurrentItem(Machine::addExtensionToLastDevice, atts.getValue("name"));
                    break;
                }
                case "slot": {
                    this.slotOptionCount = 0;
                    if (!Configuration.Manager.isSyncExecutionMode()) break;
                    this.startConsumeCurrentItem(Machine::addSlot, atts.getValue("name"));
                    break;
                }
                case "slotoption": {
                    if (++this.slotOptionCount > 1) {
                        this.startConsumeCurrentItem(EmulatedItem::setConfigurable, true);
                    }
                    if (!Configuration.Manager.isSyncExecutionMode()) break;
                    SlotOption option = this.startApplyOnCurrentItem(Machine::addSlotOptionToLastSlot, atts.getValue("name"), "yes".equals(atts.getValue("default")));
                    List<SlotOption> slotOptionList = this.slotOptionMap.get(atts.getValue("devname"));
                    if (slotOptionList == null) {
                        slotOptionList = new ArrayList<SlotOption>();
                        this.slotOptionMap.put(atts.getValue("devname"), slotOptionList);
                    }
                    slotOptionList.add(option);
                    break;
                }
                case "softwarelist": {
                    this.startConsumeCurrentItem(Machine::setSoftwareEmbedded, false);
                    if (!Configuration.Manager.isSyncExecutionMode()) break;
                    this.startConsumeCurrentItem(Machine::addSoftwareList, atts.getValue("name"), atts.getValue("filter"));
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            switch (qName) {
                case "mame": {
                    if (!Configuration.Manager.isSyncExecutionMode()) break;
                    Map<String, Machine> machineMap = this.machines.getMap();
                    this.internalDeviceMap.forEach((key, devices) -> {
                        Machine machine = (Machine)machineMap.get(key);
                        devices.forEach(device -> machine.addInternalDevice((String)device, ((Machine)machineMap.get(device)).getDescription()));
                    });
                    this.slotOptionMap.forEach((key, slotOptionList) -> {
                        Machine machine = (Machine)machineMap.get(key);
                        slotOptionList.forEach(slotOption -> slotOption.setDevice(machine));
                    });
                    break;
                }
                case "machine": 
                case "game": {
                    if (Configuration.Manager.isSyncExecutionMode()) {
                        this.startConsumeCurrentItem(Machine::initialise, this.softwareLists);
                    }
                    this.endConsumeCurrentItem(MachineListData::add, this.machines);
                    ++this.currentCount;
                    if (this.currentCount % 50L != 0L) break;
                    this.progressProperty.set((double)this.currentCount / (double)this.totalCount);
                    break;
                }
                case "manufacturer": {
                    this.endTextElement(Machine::setManufacturer);
                    break;
                }
                case "ramoption": {
                    if (!Configuration.Manager.isSyncExecutionMode()) break;
                    this.endTextElement(Machine::addRamOption, this.attributes.get("default") != null);
                }
            }
        }
    }

    public static class MachineListData {
        private final MachineListCache.Data list;
        private final Map<String, Machine> map;

        public MachineListData() {
            this(new MachineListCache.Data());
        }

        public MachineListData(MachineListCache.Data list) {
            this.list = list;
            this.map = new HashMap<String, Machine>();
            list.forEach(machine -> this.map.put(machine.getName(), (Machine)machine));
        }

        public MachineListCache.Data getList() {
            return this.list;
        }

        public Map<String, Machine> getMap() {
            return this.map;
        }

        public void add(Machine machine) {
            this.list.add(machine);
            this.map.put(machine.getName(), machine);
        }
    }
}

