/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.loader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.util.Pair;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.babelsoft.negatron.io.Mame;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.model.comparing.Difference;
import net.babelsoft.negatron.model.comparing.MergedUnit;
import net.babelsoft.negatron.model.comparing.Merger;
import net.babelsoft.negatron.model.component.Bios;
import net.babelsoft.negatron.model.component.BiosSet;
import net.babelsoft.negatron.model.component.Choice;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.model.component.MachineElement;
import net.babelsoft.negatron.model.component.Ram;
import net.babelsoft.negatron.model.component.RamOption;
import net.babelsoft.negatron.model.component.Slot;
import net.babelsoft.negatron.model.component.SlotOption;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.SoftwareList;
import net.babelsoft.negatron.util.Dom;
import net.babelsoft.negatron.view.control.form.ChoiceControl;
import net.babelsoft.negatron.view.control.form.Control;
import net.babelsoft.negatron.view.control.form.DeviceControl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MachineLoader
extends Service<List<Control<?>>> {
    private static final String XML_PROLOG = "<?xml version=\"1.0\"?>";
    public static final List<Control<?>> MAME_FATAL_ERROR = Collections.emptyList();
    private volatile String origin;
    private volatile Machine machine;
    private volatile List<String> parameters;
    private volatile Mode mode;
    private Map<String, SoftwareList> softwareLists;
    private final Object dataSync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialisationData(Machine machine, String origin, Mode mode) {
        Object object = this.dataSync;
        synchronized (object) {
            this.machine = machine;
            this.parameters = machine.parameters(origin);
            this.origin = origin;
            this.mode = mode;
        }
    }

    public void setSoftwareLists(Map<String, SoftwareList> softwareLists) {
        this.softwareLists = softwareLists;
    }

    public Mode getMode() {
        return this.mode;
    }

    protected Task<List<Control<?>>> createTask() {
        return new Task<List<Control<?>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            protected List<Control<?>> call() throws Exception {
                MachineDataHandler dataHandler;
                List params = null;
                Object object = MachineLoader.this.dataSync;
                synchronized (object) {
                    dataHandler = new MachineDataHandler(this, MachineLoader.this.machine, MachineLoader.this.softwareLists, MachineLoader.this.origin, MachineLoader.this.mode);
                    if (Configuration.Manager.isAsyncExecutionMode() || Configuration.Manager.isXmlMediaOptionAvailable()) {
                        params = MachineLoader.this.parameters;
                        if (Configuration.Manager.isAsyncExecutionMode()) {
                            params.add("-lx");
                        } else {
                            params.add("-lmx");
                        }
                    }
                }
                if (this.isCancelled()) {
                    return null;
                }
                Document doc = null;
                if (Configuration.Manager.isAsyncExecutionMode() || Configuration.Manager.isXmlMediaOptionAvailable()) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(false);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Logger.getLogger(MachineLoader.class.getName()).log(Level.INFO, params.toString());
                    MachineLoader machineLoader = MachineLoader.this;
                    synchronized (machineLoader) {
                        boolean tryAgain = false;
                        int attemptCount = 0;
                        if (this.isCancelled()) {
                            return null;
                        }
                        do {
                            try (InputStream input = Mame.newInputStream(params);){
                                boolean canProceed = true;
                                if (input.markSupported()) {
                                    input.mark(30);
                                    byte[] header = new byte[33];
                                    input.read(header, 0, 21);
                                    if (!MachineLoader.XML_PROLOG.equals(new String(header).trim())) {
                                        canProceed = false;
                                        if (attemptCount < 2) {
                                            input.reset();
                                            InputStreamReader stream = new InputStreamReader(input);
                                            BufferedReader reader = new BufferedReader(stream);
                                            String[] error = reader.readLine().split(":");
                                            if (error[0].equals("Error") && error[1].equals(" unknown option")) {
                                                String param = error[2].trim();
                                                int index = params.indexOf(param);
                                                params.remove(index);
                                                if (attemptCount == 0) {
                                                    param = param.endsWith("1") ? param.substring(0, param.length() - 1) : param + "1";
                                                    params.add(index, param);
                                                } else if (params.size() > index && params.get(index) != null && !((String)params.get(index)).startsWith("-")) {
                                                    params.remove(index);
                                                }
                                                params.remove(0);
                                                tryAgain = true;
                                                ++attemptCount;
                                            } else {
                                                tryAgain = false;
                                            }
                                        } else {
                                            tryAgain = false;
                                        }
                                    } else {
                                        input.reset();
                                        tryAgain = false;
                                    }
                                }
                                if (canProceed) {
                                    doc = db.parse(input);
                                    continue;
                                }
                                if (tryAgain) continue;
                                Logger.getLogger(MachineLoader.class.getName()).log(Level.WARNING, "MAME didn't output valid XML");
                                List<Control<?>> list = MAME_FATAL_ERROR;
                                return list;
                            }
                        } while (tryAgain && !this.isCancelled());
                    }
                    if (this.isCancelled()) {
                        return null;
                    }
                }
                dataHandler.process(doc);
                return dataHandler.result();
            }
        };
    }

    private static class MachineDataHandler {
        private final Task<?> task;
        private final Machine machine;
        private final Map<String, SoftwareList> softwareLists;
        private final String origin;
        private final Mode mode;
        private List<MergedUnit<?>> differences;

        public MachineDataHandler(Task<?> task, Machine machine, Map<String, SoftwareList> softwareLists, String origin, Mode mode) {
            this.task = task;
            this.machine = machine;
            this.softwareLists = softwareLists;
            this.origin = origin;
            this.mode = mode;
        }

        private void processXmlDevices(Element machineNode, Merger merger) {
            List<Node> deviceList = Dom.getElementsByTagName(machineNode, "device");
            deviceList.stream().map(o -> (Element)o).filter(deviceElement -> deviceElement.getElementsByTagName("instance").item(0) != null).map(deviceElement -> {
                NamedNodeMap attributes = deviceElement.getAttributes();
                boolean isMandatory = false;
                if (attributes.getNamedItem("mandatory") != null) {
                    isMandatory = true;
                }
                Node tag = attributes.getNamedItem("tag");
                Device device = new Device(deviceElement.getElementsByTagName("instance").item(0).getAttributes().getNamedItem("name").getNodeValue(), attributes.getNamedItem("type").getNodeValue(), tag != null ? tag.getNodeValue() : null, isMandatory);
                Node interfaceFormat = attributes.getNamedItem("interface");
                device.setInterfaceFormats(interfaceFormat != null ? interfaceFormat.getNodeValue().split(",") : new String[]{});
                if (this.machine.getSoftwareLists() != null) {
                    this.machine.getSoftwareLists().stream().flatMap(softwareListFilter -> {
                        SoftwareList softwareList = this.softwareLists.get(softwareListFilter.getSoftwareList());
                        if (softwareList != null) {
                            return softwareList.getSoftwares(device.getInterfaceFormats(), softwareListFilter.getFilter()).stream();
                        }
                        return null;
                    }).findAny().ifPresent(software -> device.setCompatibleSoftwareLists(true));
                }
                Dom.getElementsByTagName(deviceElement, "extension").stream().map(extension -> extension.getAttributes().getNamedItem("name").getNodeValue()).forEach(extension -> device.addExtension((String)extension));
                return device;
            }).filter(device -> device.getExtensions().size() > 0).forEach(device -> merger.add((MachineElement<?>)device));
        }

        private void processXml(Document doc, Merger merger) {
            List<Node> ramList;
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element machineNode = null;
            try {
                machineNode = (Element)xpath.evaluate(String.format("/mame/machine[@name='%s']", this.machine.getName()), doc, XPathConstants.NODE);
                if (machineNode == null && (machineNode = (Element)xpath.evaluate(String.format("/mame/game[@name='%s']", this.machine.getName()), doc, XPathConstants.NODE)) == null) {
                    machineNode = (Element)xpath.evaluate(String.format("/mess/machine[@name='%s']", this.machine.getName()), doc, XPathConstants.NODE);
                }
            }
            catch (XPathExpressionException ex) {
                Logger.getLogger(MachineLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
            List<Node> internalDevices = Dom.getElementsByTagName(machineNode, "device_ref");
            internalDevices.stream().forEach(node -> {
                String name = node.getAttributes().getNamedItem("name").getNodeValue();
                String description = null;
                try {
                    description = (String)xpath.evaluate(String.format("/mame/machine[@name='%s']/description/text()", name), doc, XPathConstants.STRING);
                    if (description == null && (description = (String)xpath.evaluate(String.format("/mame/game[@name='%s']/description/text()", name), doc, XPathConstants.STRING)) == null) {
                        description = (String)xpath.evaluate(String.format("/mess/machine[@name='%s']/description/text()", name), doc, XPathConstants.STRING);
                    }
                }
                catch (XPathExpressionException ex) {
                    Logger.getLogger(MachineLoader.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.machine.addInternalDevice(name, description);
            });
            List<Node> softwareListNodes = Dom.getElementsByTagName(machineNode, "softwarelist");
            softwareListNodes.stream().forEach(node -> {
                Node filter = node.getAttributes().getNamedItem("filter");
                this.machine.addSoftwareList(node.getAttributes().getNamedItem("name").getNodeValue(), filter != null ? filter.getNodeValue() : null);
            });
            List<Node> biosList = Dom.getElementsByTagName(machineNode, "biosset");
            if (biosList.size() > 1) {
                Bios bios = new Bios();
                biosList.stream().map(node -> node.getAttributes()).forEach(attributes -> {
                    BiosSet set = new BiosSet(attributes.getNamedItem("name").getNodeValue(), attributes.getNamedItem("description").getNodeValue());
                    bios.addOption(set, "yes".equals(attributes.getNamedItem("default").getNodeValue()));
                });
                merger.add(bios);
            }
            if ((ramList = Dom.getElementsByTagName(machineNode, "ramoption")).size() > 1) {
                Ram ram = new Ram();
                ramList.stream().forEach(node -> {
                    RamOption option = new RamOption(node.getTextContent());
                    ram.addOption(option, node.getAttributes().getNamedItem("default") != null);
                });
                merger.add(ram);
            }
            this.processXmlDevices(machineNode, merger);
            List<Node> slotList = Dom.getElementsByTagName(machineNode, "slot");
            slotList.stream().map(o -> (Element)o).filter(slotElement -> slotElement.hasChildNodes() && slotElement.getChildNodes().getLength() > 1).map(slotElement -> {
                Slot slot = new Slot(slotElement.getAttribute("name"));
                Dom.getElementsByTagName(slotElement, "slotoption").stream().map(node -> node.getAttributes()).forEach(attributes -> {
                    String devName = attributes.getNamedItem("devname").getNodeValue();
                    try {
                        Element element = (Element)xpath.evaluate(String.format("/mame/machine[@name='%s']", devName), doc, XPathConstants.NODE);
                        if (element == null && (element = (Element)xpath.evaluate(String.format("/mame/game[@name='%s']", devName), doc, XPathConstants.NODE)) == null) {
                            element = (Element)xpath.evaluate(String.format("/mess/machine[@name='%s']", devName), doc, XPathConstants.NODE);
                        }
                        SlotOption option = new SlotOption(attributes.getNamedItem("name").getNodeValue(), element.getElementsByTagName("description").item(0).getTextContent());
                        slot.addOption(option, "yes".equals(attributes.getNamedItem("default").getNodeValue()));
                    }
                    catch (XPathExpressionException ex) {
                        Logger.getLogger(MachineLoader.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
                return slot;
            }).filter(slot -> slot.size() > 1).forEach(slot -> merger.add((MachineElement<?>)slot));
        }

        private void copyDefaults(List<Pair<String, String>> defaults, Machine device, String root) {
            List<Pair<String, String>> deviceDefaults = device.getDefaultSlotOptions();
            if (deviceDefaults != null) {
                deviceDefaults.stream().forEach(pair -> defaults.add(new Pair((Object)(root + (String)pair.getKey()), pair.getValue())));
            }
        }

        private void retrieveDefaults(Machine device, List<Pair<String, String>> defaults, String root, String[] splitOrigin, int start) {
            this.copyDefaults(defaults, device, root);
            StringBuilder name = new StringBuilder();
            for (int i = start; i < splitOrigin.length; ++i) {
                if (i != 0) {
                    name.append(":");
                }
                name.append(splitOrigin[i]);
                Slot parentSlot = device.getSlots().stream().filter(slot -> slot.getName().equals(name.toString())).findAny().orElse(null);
                if (parentSlot == null) continue;
                Machine subdevice = ((SlotOption)parentSlot.getValue()).getDevice();
                this.retrieveDefaults(subdevice, defaults, root + name + ":" + ((SlotOption)parentSlot.getValue()).getName(), splitOrigin, ++i);
            }
        }

        private void processSlots(List<Slot> slots, Slot rootSlot, String root, List<Pair<String, String>> defaults) {
            Machine device = ((SlotOption)rootSlot.getValue()).getDevice();
            if (device != null && device.getSlots() != null) {
                device.getSlots().forEach(slot -> {
                    String subroot = root + ":" + ((SlotOption)rootSlot.getValue()).getName();
                    String name = subroot + slot.getName();
                    Slot clone = slot.copy(name);
                    ArrayList<Pair<String, String>> dft = new ArrayList<Pair<String, String>>(defaults);
                    this.copyDefaults(dft, device, subroot);
                    Pair value = dft.stream().filter(pair -> ((String)pair.getKey()).equals(name)).findFirst().orElse(null);
                    clone.setValue(clone.getOptions().stream().filter(option -> option.getName().equals(value.getValue())).findFirst().orElse(null));
                    slots.add(clone);
                    this.processSlots(slots, clone, name, dft);
                });
            }
        }

        private void process(Document doc, Merger merger) {
            Ram ram;
            Bios bios = this.machine.getBios();
            if (bios != null && bios.size() > 1) {
                merger.add(bios);
            }
            if ((ram = this.machine.getRam()) != null && ram.size() > 1) {
                merger.add(ram);
            }
            String filter = this.origin + ":";
            if (this.mode == Mode.UPDATE && doc != null) {
                XPath xpath = XPathFactory.newInstance().newXPath();
                Element machineNode = null;
                try {
                    machineNode = (Element)xpath.evaluate(String.format("/mame/machine[@name='%s']", this.machine.getName()), doc, XPathConstants.NODE);
                }
                catch (XPathExpressionException ex) {
                    Logger.getLogger(MachineLoader.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.processXmlDevices(machineNode, merger);
            } else {
                List<Device> devices = this.machine.getDevices();
                if (devices != null) {
                    devices.removeIf(candidate -> candidate.getTag().startsWith(filter));
                    devices.stream().filter(device -> device.getExtensions().size() > 0).forEach(device -> merger.add(device.copy()));
                }
            }
            List<Slot> slots = this.machine.getSlots();
            if (slots != null) {
                Slot originSlot;
                ArrayList<Slot> copiedSlots = new ArrayList<Slot>();
                slots.forEach(slot -> copiedSlots.add(slot.copy()));
                slots = copiedSlots;
                if (this.mode == Mode.UPDATE && (originSlot = (Slot)slots.stream().filter(slot -> slot.getName().equals(this.origin)).findAny().orElse(null)) != null) {
                    slots.removeIf(candidate -> candidate.getName().startsWith(filter));
                    if (!((SlotOption)originSlot.getValue()).getName().isEmpty()) {
                        ArrayList<Pair<String, String>> defaults = new ArrayList<Pair<String, String>>();
                        this.retrieveDefaults(this.machine, defaults, "", this.origin.split(":"), 0);
                        this.processSlots(slots, originSlot, this.origin, defaults);
                    }
                }
                slots.stream().filter(slot -> slot.size() > 1).sorted((s1, s2) -> s1.getName().compareTo(s2.getName())).forEachOrdered(slot -> merger.add((MachineElement<?>)slot));
            }
        }

        public void process(Document doc) {
            Merger merger = this.machine.reset(this.origin);
            if (Configuration.Manager.isAsyncExecutionMode()) {
                this.processXml(doc, merger);
            } else {
                this.process(doc, merger);
            }
            if ((merger.merge() || this.mode == Mode.CREATE) && !this.task.isCancelled()) {
                this.differences = merger.commit();
            } else {
                merger.rollback();
            }
        }

        public List<Control<?>> result() {
            if (this.differences == null) {
                return null;
            }
            ArrayList views = new ArrayList();
            this.differences.stream().forEachOrdered(mergedUnit -> {
                MachineElement element;
                Difference status = mergedUnit.getStatus();
                switch (status) {
                    default: {
                        element = mergedUnit.getNewElement();
                        break;
                    }
                    case DELETED: {
                        element = mergedUnit.getOldElement();
                    }
                }
                if (element instanceof Device) {
                    views.add(new DeviceControl((Device)element, status));
                } else {
                    views.add(new ChoiceControl((Choice)element, status));
                }
            });
            return views;
        }
    }

    public static enum Mode {
        CREATE,
        UPDATE;

    }
}

