/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.loader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.babelsoft.negatron.io.Mame;
import net.babelsoft.negatron.io.cache.StatusCache;
import net.babelsoft.negatron.io.loader.InitialisedCallable;
import net.babelsoft.negatron.model.Status;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.SoftwareList;

public class MachineStatusLoader
implements InitialisedCallable<Void> {
    private final StatusCache cache;
    private Map<String, Machine> machines;

    public MachineStatusLoader(StatusCache cache) {
        this.cache = cache;
    }

    @Override
    public void initialise(Map<String, Machine> machines, Map<String, SoftwareList> softwareLists) {
        this.machines = machines;
    }

    private void updateUI(HashMap<String, Status> statuses, String name) {
        Machine machine = this.machines.get(name);
        if (machine != null) {
            machine.setStatus(statuses.get(name));
        }
    }

    @Override
    public Void call() throws Exception {
        HashMap<String, Status> statuses = new HashMap<String, Status>();
        ArrayList batch = new ArrayList();
        int cutoffSize = 500;
        Process process = Mame.newProcess("-verifyroms");
        try (InputStream input = process.getInputStream();
             InputStreamReader stream = new InputStreamReader(input);
             BufferedReader reader = new BufferedReader(stream);){
            reader.lines().map(line -> line.split("\\s")).filter(lineElements -> ((String[])lineElements).length > 2 && lineElements[0].equals("romset")).forEach(lineElements -> {
                String name = lineElements[1];
                if (lineElements[((String[])lineElements).length - 1].equals("good") || lineElements[((String[])lineElements).length - 2].equals("best") && lineElements[((String[])lineElements).length - 1].equals("available")) {
                    statuses.put(name, Status.GOOD);
                } else {
                    statuses.put(name, Status.BAD);
                }
                if (!Thread.currentThread().isInterrupted()) {
                    batch.add(name);
                    if (batch.size() > 500) {
                        batch.forEach(id -> this.updateUI(statuses, (String)id));
                        batch.clear();
                    }
                } else {
                    process.destroy();
                }
            });
        }
        if (!Thread.interrupted()) {
            batch.forEach(id -> this.updateUI(statuses, (String)id));
            batch.clear();
            this.cache.saveMachines(statuses);
        }
        return null;
    }
}

