/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.loader;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.babelsoft.negatron.io.cache.SoftwareListCache;
import net.babelsoft.negatron.io.loader.EmulatedItemListDataHandler;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.model.item.SoftwareList;
import net.babelsoft.negatron.model.item.SoftwarePart;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SoftwareListLoader
implements Callable<Void> {
    private final SoftwareListCache cache;
    private final Path path;

    public SoftwareListLoader(SoftwareListCache cache, Path path) {
        this.cache = cache;
        this.path = path;
    }

    @Override
    public Void call() {
        SoftwareListDataHandler dataHandler = new SoftwareListDataHandler(this.path);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(false);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            xmlReader.setContentHandler(dataHandler);
            xmlReader.parse(new InputSource(this.path.toString()));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(SoftwareListLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        SoftwareList result = dataHandler.result();
        try {
            this.cache.save(result);
        }
        catch (Exception ex) {
            Logger.getLogger(SoftwareListLoader.class.getName()).log(Level.WARNING, "Couldn't save cache to file.", ex);
        }
        return null;
    }

    private static class SoftwareListDataHandler
    extends EmulatedItemListDataHandler<Software> {
        private final String name;
        private SoftwareList softwareList;

        public SoftwareListDataHandler(Path path) {
            super((String name, String group) -> new Software(name, group));
            this.name = SoftwareListCache.convertPathToName(path);
        }

        public SoftwareList result() {
            return this.softwareList;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            block8 : switch (qName) {
                case "softwarelist": {
                    this.softwareList = new SoftwareList(this.name, atts.getValue("description"));
                    break;
                }
                case "software": {
                    this.buildCurrentItem(atts.getValue("name"), this.softwareList.getName(), atts.getValue("cloneof"));
                    ((Software)this.currentItem).setSupport(atts.getValue("supported"));
                    break;
                }
                case "publisher": {
                    this.startTextElement();
                    break;
                }
                case "sharedfeat": {
                    switch (atts.getValue("name")) {
                        case "compatibility": {
                            this.startConsumeCurrentItem(Software::setCompatibility, atts.getValue("value").split(","));
                            break;
                        }
                        case "requirement": {
                            String requirement = atts.getValue("value");
                            if (requirement.contains(" -")) {
                                requirement = requirement.replace(" -", ":");
                            }
                            this.startConsumeCurrentItem(Software::setRequirement, requirement);
                        }
                    }
                    break;
                }
                case "part": {
                    this.startConsumeCurrentItem(Software::addSoftwarePart, new SoftwarePart(atts.getValue("name"), atts.getValue("interface")));
                    break;
                }
                case "feature": {
                    switch (atts.getValue("name")) {
                        case "Disc Code": 
                        case "disk_label": 
                        case "part_id": 
                        case "part id": 
                        case "slot": {
                            this.startConsumeCurrentItem(Software::setLastPartDescription, atts.getValue("value"));
                            break block8;
                        }
                    }
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            switch (qName) {
                case "software": {
                    this.endConsumeCurrentItem(SoftwareList::addSoftware, this.softwareList);
                    break;
                }
                case "publisher": {
                    this.endTextElement(Software::setPublisher);
                }
            }
        }
    }
}

