/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.io.loader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.babelsoft.negatron.io.Mame;
import net.babelsoft.negatron.io.cache.StatusCache;
import net.babelsoft.negatron.io.loader.InitialisedCallable;
import net.babelsoft.negatron.model.Status;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.model.item.SoftwareList;

public class SoftwareStatusLoader
implements InitialisedCallable<Void> {
    private final StatusCache cache;
    private Map<String, SoftwareList> softwareLists;

    public SoftwareStatusLoader(StatusCache cache) {
        this.cache = cache;
    }

    @Override
    public void initialise(Map<String, Machine> machines, Map<String, SoftwareList> softwareLists) {
        this.softwareLists = softwareLists;
    }

    private void updateUI(Map<Software, Status> batch) {
        batch.entrySet().forEach(entry -> ((Software)entry.getKey()).setStatus((Status)entry.getValue()));
        batch.clear();
    }

    @Override
    public Void call() throws Exception {
        HashMap<String, HashMap<String, Status>> listStatuses = new HashMap<String, HashMap<String, Status>>();
        HashMap<Software, Status> batch = new HashMap<Software, Status>();
        int cutoffSize = 500;
        Process process = Mame.newProcess("-verifysoftware");
        try (InputStream input = process.getInputStream();
             InputStreamReader stream = new InputStreamReader(input);
             BufferedReader reader = new BufferedReader(stream);){
            reader.lines().map(line -> line.split("\\s")).filter(lineElements -> ((String[])lineElements).length > 2 && lineElements[0].equals("romset")).forEach(lineElements -> {
                String[] names = lineElements[1].split(":");
                Software software = this.softwareLists.get(names[0]).getSoftware(names[1]);
                HashMap<String, Status> statuses = (HashMap<String, Status>)listStatuses.get(names[0]);
                if (statuses == null) {
                    statuses = new HashMap<String, Status>();
                    listStatuses.put(names[0], statuses);
                }
                if (lineElements[((String[])lineElements).length - 1].equals("good") || lineElements[((String[])lineElements).length - 2].equals("best") && lineElements[((String[])lineElements).length - 1].equals("available")) {
                    statuses.put(names[1], Status.GOOD);
                    if (software != null) {
                        batch.put(software, Status.GOOD);
                    }
                } else {
                    statuses.put(names[1], Status.BAD);
                    if (software != null) {
                        batch.put(software, Status.BAD);
                    }
                }
                if (!Thread.currentThread().isInterrupted()) {
                    if (batch.size() > 500) {
                        this.updateUI(batch);
                    }
                } else {
                    process.destroy();
                }
            });
        }
        if (!Thread.interrupted()) {
            this.updateUI(batch);
            this.cache.saveSoftware(listStatuses);
        }
        return null;
    }
}

