/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model;

import java.util.function.Function;
import net.babelsoft.negatron.model.SizeUnit;

public class HddGeometry {
    private String manufacturer;
    private String name;
    private String path;
    private final long cylinder;
    private final long head;
    private final long sector;
    private final long sectorSize;

    private HddGeometry(String cylinder, String head, String sector, String sectorSize) {
        Function<String, Long> parse = text -> !text.isEmpty() ? Long.parseUnsignedLong(text) : 0L;
        this.cylinder = parse.apply(cylinder);
        this.head = parse.apply(head);
        this.sector = parse.apply(sector);
        this.sectorSize = parse.apply(sectorSize);
    }

    public HddGeometry(String manufacturer, String name, String cylinder, String head, String sector, String sectorSize) {
        this(cylinder, head, sector, sectorSize);
        this.manufacturer = manufacturer;
        this.name = name;
    }

    public HddGeometry(String path, String cylinder, String head, String sector, String sectorSize) {
        this(cylinder, head, sector, sectorSize);
        this.path = path;
    }

    public String toString() {
        return String.format("%s %s (%s)", this.getManufacturer(), this.getName(), this.getTotalSize());
    }

    public String getTotalSize() {
        return SizeUnit.factorise(this.getCylinder() * this.getHead() * this.getSector() * this.getSectorSize());
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public long getCylinder() {
        return this.cylinder;
    }

    public long getHead() {
        return this.head;
    }

    public long getSector() {
        return this.sector;
    }

    public long getSectorSize() {
        return this.sectorSize;
    }
}

