/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.comparing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.babelsoft.negatron.model.comparing.Difference;
import net.babelsoft.negatron.model.comparing.MergedUnit;
import net.babelsoft.negatron.model.component.MachineElement;
import net.babelsoft.negatron.model.component.MachineElementList;
import net.babelsoft.negatron.model.item.Machine;

public class Merger {
    private final Machine machine;
    private String origin;
    private MachineElement<?> dependency;
    private List<MergedUnit<?>> differences;
    private MachineElementList parameters;
    private MachineElementList previousParameters;
    private Map<String, MachineElement<?>> parameterMap;
    private Map<String, MachineElement<?>> previousParameterMap;
    private Map<String, MachineElement<?>> parameterMapBackup;
    boolean hasChanged;

    public Merger(Machine machine) {
        this.machine = machine;
    }

    public Merger(Machine machine, MachineElementList parameters) {
        this.machine = machine;
        this.parameters = parameters;
        this.parameterMap = new HashMap();
        parameters.forEach(parameter -> this.parameterMap.put(parameter.getName(), (MachineElement<?>)parameter));
    }

    public void reset(String origin) {
        this.origin = origin;
        if (this.parameterMap != null) {
            this.hasChanged = false;
            this.previousParameters = this.parameters;
            this.previousParameterMap = this.parameterMap;
            this.parameterMapBackup = new HashMap(this.parameterMap);
        } else {
            this.hasChanged = true;
        }
        this.parameters = new MachineElementList(this.machine);
        this.parameterMap = new HashMap();
        this.differences = new ArrayList();
    }

    private <T> MergedUnit<T> compare(MachineElement<T> parameter) {
        MergedUnit<Object> mergedUnit;
        if (this.previousParameterMap != null) {
            String previousName = parameter.getName();
            if (!this.previousParameterMap.containsKey(previousName)) {
                if (previousName.matches(".*[a-z]1$")) {
                    if (!this.previousParameterMap.containsKey(previousName = previousName.substring(0, previousName.length() - 1))) {
                        previousName = null;
                    }
                } else if (previousName.matches(".*[^\\d]$")) {
                    if (!this.previousParameterMap.containsKey(previousName = previousName + "1")) {
                        previousName = null;
                    }
                } else {
                    previousName = null;
                }
                this.hasChanged = true;
            }
            if (previousName != null) {
                MachineElement<?> previousParameter = this.previousParameterMap.remove(previousName);
                if (previousName.equals(this.origin)) {
                    this.dependency = parameter;
                }
                if (!parameter.getName().equals(previousName)) {
                    parameter.setPreviousName(previousName);
                }
                if (!parameter.setValue(previousParameter)) {
                    this.hasChanged = true;
                    mergedUnit = new MergedUnit(previousParameter, parameter, Difference.CHANGED);
                } else {
                    mergedUnit = new MergedUnit(previousParameter, parameter, Difference.UNCHANGED);
                }
            } else {
                mergedUnit = new MergedUnit<T>(null, parameter, Difference.ADDED);
            }
        } else {
            mergedUnit = new MergedUnit<T>(null, parameter, Difference.CREATED);
        }
        return mergedUnit;
    }

    public void add(MachineElement<?> parameter) {
        this.differences.add(this.compare(parameter));
        this.parameters.add(parameter);
        this.parameterMap.put(parameter.getName(), parameter);
    }

    public boolean merge() {
        this.differences.stream().filter(mergedUnit -> mergedUnit.getStatus() == Difference.ADDED || (mergedUnit.getStatus() == Difference.UNCHANGED || mergedUnit.getStatus() == Difference.CHANGED) && mergedUnit.getOldElement().getDependencies() != null && mergedUnit.getOldElement().getDependencies().size() > 0).forEach(mergedUnit -> {
            if (mergedUnit.getStatus() == Difference.ADDED) {
                mergedUnit.getNewElement().addDependency(this.dependency);
            } else {
                mergedUnit.getOldElement().getDependencies().stream().map(dependency -> this.parameterMap.get(dependency.getDependency().getName())).forEach(replacement -> mergedUnit.getNewElement().addDependency((MachineElement<?>)replacement));
            }
        });
        if (this.previousParameterMap != null) {
            this.previousParameterMap.values().stream().forEach(previousParameter -> {
                int index = this.previousParameters.indexOf(previousParameter);
                if (index > 0) {
                    MachineElement previousSibling = (MachineElement)this.previousParameters.get(index - 1);
                    for (int i = 0; i < this.differences.size(); ++i) {
                        MergedUnit<?> unit = this.differences.get(i);
                        MachineElement<?> element = unit.getOldElement();
                        if (element == null || element != previousSibling) continue;
                        this.differences.add(++i, new MergedUnit(previousParameter, null, Difference.DELETED));
                        this.hasChanged = true;
                        break;
                    }
                } else {
                    this.differences.add(0, new MergedUnit(previousParameter, null, Difference.DELETED));
                    this.hasChanged = true;
                }
            });
        }
        return this.hasChanged;
    }

    private void clear() {
        this.previousParameters = null;
        this.parameterMapBackup = null;
        this.previousParameterMap = null;
        this.differences = null;
    }

    public List<MergedUnit<?>> commit() {
        this.machine.setParameters(this.parameters);
        this.machine.processInternalDevices();
        List<MergedUnit<?>> result = this.differences;
        this.clear();
        return result;
    }

    public void rollback() {
        if (this.previousParameterMap != null) {
            this.parameters = this.previousParameters;
            this.parameterMap = this.parameterMapBackup;
        } else {
            this.parameters = null;
            this.parameterMap = null;
        }
        this.clear();
    }
}

