/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.component;

import java.util.ArrayList;
import java.util.List;
import net.babelsoft.negatron.model.Option;
import net.babelsoft.negatron.model.OptionProperty;
import net.babelsoft.negatron.model.component.MachineComponent;
import net.babelsoft.negatron.model.component.MachineElement;

public abstract class Choice<T extends Option<T>>
extends MachineElement<T>
implements MachineComponent<T, OptionProperty<T>> {
    private static final long serialVersionUID = 1L;
    private final List<T> options = new ArrayList<T>();
    private transient OptionProperty<T> value;
    protected T defaultValue;

    private void initialise(Choice<T> ref) {
        ref.options.forEach(option -> {
            Object cloned = option.copy();
            if (option == ref.defaultValue) {
                this.defaultValue = cloned;
            }
            this.options.add(cloned);
        });
        if (ref.value != null) {
            this.setValue((T)ref.getValue());
        }
    }

    protected Choice(String name) {
        super(name);
    }

    protected Choice(Choice<T> ref) {
        super(ref);
        this.initialise(ref);
    }

    protected Choice(String name, Choice<T> ref) {
        super(name, ref);
        this.initialise(ref);
    }

    @Override
    public T getValue() {
        Option v = (Option)this.valueProperty().get();
        if (v != null) {
            return (T)v;
        }
        return this.getDefaultValue();
    }

    @Override
    public void setValue(T value) {
        if (!this.options.contains(value)) {
            this.valueProperty().set(this.options.stream().filter(option -> option.getName().equals(value.getName())).findAny().orElse((Option)this.defaultValue));
        } else {
            this.valueProperty().set(value);
        }
    }

    @Override
    public OptionProperty<T> valueProperty() {
        if (this.value == null) {
            this.value = new OptionProperty(this, "value");
        }
        return this.value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public abstract void setDefaultValue();

    public void addOption(T option, boolean isDefault) {
        this.options.add(option);
        if (isDefault) {
            this.defaultValue = option;
        }
    }

    public List<T> getOptions() {
        return this.options;
    }

    public int size() {
        return this.options.size();
    }

    @Override
    public List<String> parameters() {
        Object v = this.getValue();
        ArrayList<String> param = new ArrayList<String>();
        if (this.hasDependenciesValidated()) {
            param.add("-" + this.getName());
            param.add(((Option)v).getName());
        }
        return param;
    }

    @Override
    public <S extends MachineComponent<T, OptionProperty<T>>> boolean canReplace(S otherComponent) {
        return this.getName().equals(otherComponent.getName());
    }
}

