/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.babelsoft.negatron.model.component.MachineComponent;
import net.babelsoft.negatron.model.component.MachineElement;
import net.babelsoft.negatron.util.Strings;

public final class Device
extends MachineElement<String>
implements MachineComponent<String, StringProperty> {
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String tag;
    private final boolean mandatory;
    private final List<String> extensions;
    private final List<String> interfaceFormats;
    private transient StringProperty value;
    private boolean compatibleSoftwareLists;

    public Device(String name, String type, String tag, boolean mandatory) {
        super(name);
        this.type = type;
        this.tag = tag;
        this.mandatory = mandatory;
        this.extensions = new ArrayList<String>();
        this.interfaceFormats = new ArrayList<String>(1);
    }

    protected Device(Device ref) {
        super(ref);
        this.type = ref.type;
        this.tag = ref.tag;
        this.mandatory = ref.mandatory;
        this.extensions = new ArrayList<String>();
        this.interfaceFormats = new ArrayList<String>(1);
        ref.extensions.forEach(extension -> this.extensions.add((String)extension));
        ref.interfaceFormats.forEach(extension -> this.interfaceFormats.add((String)extension));
        this.setValue(ref.getValue());
        this.compatibleSoftwareLists = ref.compatibleSoftwareLists;
    }

    @Override
    public String getValue() {
        return (String)this.valueProperty().get();
    }

    @Override
    public void setValue(String value) {
        this.valueProperty().set((Object)value);
    }

    @Override
    public boolean setValue(MachineElement<String> param) {
        Device device = (Device)param;
        if (device != null && (this.getInterfaceFormats().isEmpty() || this.getInterfaceFormats().equals(device.getInterfaceFormats())) && (this.getTag() == null || this.getTag().equals(device.getTag()))) {
            this.setValue(device.getValue());
            return true;
        }
        return false;
    }

    @Override
    public StringProperty valueProperty() {
        if (this.value == null) {
            this.value = new SimpleStringProperty((Object)this, "value");
        }
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String getTag() {
        return this.tag;
    }

    public void setInterfaceFormats(String[] interfaceFormats) {
        this.interfaceFormats.addAll(Arrays.asList(interfaceFormats));
    }

    public void addInterfaceFormat(String interfaceFormat) {
        this.interfaceFormats.add(interfaceFormat);
    }

    public List<String> getInterfaceFormats() {
        return this.interfaceFormats;
    }

    public void addExtension(String extension) {
        this.extensions.add("*." + extension);
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public void setCompatibleSoftwareLists(boolean compatibleSoftwareLists) {
        this.compatibleSoftwareLists = compatibleSoftwareLists;
    }

    public boolean hasCompatibleSoftwareLists() {
        return this.compatibleSoftwareLists;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public boolean isReady() {
        return !this.mandatory || Strings.isValid(this.getValue());
    }

    @Override
    public List<String> parameters() {
        String v = this.getValue();
        ArrayList<String> param = new ArrayList<String>();
        if (this.hasDependenciesValidated()) {
            param.add("-" + this.getName());
            if (Strings.isEmpty(v)) {
                param.add("\"\"");
            } else if (v.contains(" ")) {
                param.add("\"" + v + "\"");
            } else {
                param.add(v);
            }
        }
        return param;
    }

    @Override
    public <S extends MachineComponent<String, StringProperty>> boolean canReplace(S otherComponent) {
        if (otherComponent instanceof Device) {
            Device otherDevice = (Device)otherComponent;
            List<String> interfaceFormat = this.getInterfaceFormats();
            List<String> otherInterfaceFormat = otherDevice.getInterfaceFormats();
            String name = this.getName();
            String previousName = this.getPreviousName();
            String otherName = otherDevice.getName();
            String otherPreviousName = otherDevice.getPreviousName();
            return interfaceFormat.equals(otherInterfaceFormat) && (name.equals(otherName) || name.equals(otherPreviousName) || previousName != null && previousName.equals(otherName));
        }
        return false;
    }

    @Override
    public MachineElement<?> copy() {
        return new Device(this);
    }

    @Override
    public void write(XMLStreamWriter writer) throws XMLStreamException {
        if (this.interfaceFormats.size() > 0 || this.extensions.size() > 0) {
            writer.writeStartElement("device");
        } else {
            writer.writeEmptyElement("device");
        }
        writer.writeAttribute("name", this.getName());
        writer.writeAttribute("type", this.getType());
        writer.writeAttribute("tag", this.getTag());
        writer.writeAttribute("mandatory", Boolean.toString(this.isMandatory()));
        writer.writeAttribute("compatibleSoftwareLists", Boolean.toString(this.hasCompatibleSoftwareLists()));
        String v = this.getValue();
        if (!Strings.isEmpty(v)) {
            writer.writeAttribute("value", v);
        }
        if (this.interfaceFormats.size() > 0) {
            writer.writeStartElement("interfaces");
            for (String interfaceFormat : this.interfaceFormats) {
                writer.writeEmptyElement("interface");
                writer.writeAttribute("name", interfaceFormat);
            }
            writer.writeEndElement();
        }
        if (this.extensions.size() > 0) {
            writer.writeEmptyElement("extensions");
            writer.writeAttribute("names", this.extensions.stream().map(ext -> ext.substring(2)).filter(ext -> !ext.equals("zip")).collect(Collectors.joining(",")));
        }
        if (this.interfaceFormats.size() > 0 || this.extensions.size() > 0) {
            writer.writeEndElement();
        }
    }
}

