/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.babelsoft.negatron.io.XmlOutput;
import net.babelsoft.negatron.model.ParameterDependency;
import net.babelsoft.negatron.model.ParametrisedElement;

public abstract class MachineElement<T>
implements ParametrisedElement,
XmlOutput,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private String previousName;
    private List<ParameterDependency<?>> dependencies;

    private void initialise(MachineElement<T> ref) {
        this.previousName = ref.previousName;
    }

    protected MachineElement(String name) {
        this.name = name;
    }

    protected MachineElement(MachineElement<T> ref) {
        this(ref.name);
        super.initialise(ref);
    }

    protected MachineElement(String name, MachineElement<T> ref) {
        this(name);
        super.initialise(ref);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPreviousName() {
        return this.previousName;
    }

    public void setPreviousName(String name) {
        this.previousName = name;
    }

    public abstract T getValue();

    public abstract void setValue(T var1);

    public boolean setValue(MachineElement<T> param) {
        if (param != null) {
            this.setValue(param.getValue());
        }
        return true;
    }

    public void addDependency(MachineElement<?> dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        this.dependencies.add(new ParameterDependency(dependency));
    }

    public void copyDependencies(List<ParameterDependency<?>> dependencies, List<MachineElement<?>> params) {
        if (dependencies == null) {
            return;
        }
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        dependencies.forEach(dependency -> {
            String dependencyName = dependency.getDependency().getName();
            params.stream().filter(param -> param.getName().equals(dependencyName)).findAny().ifPresent(param -> this.dependencies.add(new ParameterDependency(param, dependency.getFilterValues())));
        });
        this.dependencies.addAll(dependencies);
    }

    public List<ParameterDependency<?>> getDependencies() {
        return this.dependencies;
    }

    public boolean hasDependenciesValidated() {
        if (this.dependencies == null) {
            return true;
        }
        return !this.dependencies.stream().anyMatch(dependency -> !dependency.getFilterValues().equals(dependency.getDependency().parameters()));
    }

    public abstract MachineElement<?> copy();
}

