/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.model.component.MachineElement;
import net.babelsoft.negatron.model.component.Slot;
import net.babelsoft.negatron.model.item.Machine;

public class MachineElementList
extends ArrayList<MachineElement<?>> {
    private final String machine;

    public MachineElementList(Machine machine) {
        this.machine = machine.getName();
    }

    protected MachineElementList(MachineElementList ref) {
        ArrayList oldNewList = new ArrayList();
        ref.forEach((? super E element) -> {
            MachineElement<?> copied = element.copy();
            this.add(copied);
            oldNewList.add(new Pair(element, copied));
        });
        oldNewList.forEach((? super T pair) -> {
            MachineElement oldElement = (MachineElement)pair.getKey();
            MachineElement newElement = (MachineElement)pair.getValue();
            newElement.copyDependencies(oldElement.getDependencies(), this);
        });
        this.machine = ref.machine;
    }

    public String getMachineName() {
        return this.machine;
    }

    public MachineElementList copy() {
        return new MachineElementList(this);
    }

    public List<String> toParameters() {
        return this.toParameters(null);
    }

    public List<String> toParameters(String origin) {
        List<String> params = this.stream().filter(elt -> !(elt instanceof Device)).flatMap(value -> value.parameters().stream()).collect(Collectors.toList());
        Stream<MachineElement> stream = null;
        if (origin != null && this.stream().filter(elt -> elt instanceof Slot).filter(slot -> slot.getName().equals(origin)).findAny().isPresent()) {
            stream = this.stream().filter(elt -> {
                if (elt instanceof Device) {
                    return !((Device)elt).getTag().startsWith(origin + ":");
                }
                return false;
            });
        }
        if (stream == null) {
            stream = this.stream().filter(elt -> elt instanceof Device);
        }
        params.addAll(stream.flatMap(value -> value.parameters().stream()).collect(Collectors.toList()));
        params.add(0, this.machine);
        return params;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toParameters().stream().forEachOrdered(string -> sb.append((String)string).append(" "));
        return sb.toString().trim();
    }
}

