/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.component;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.babelsoft.negatron.model.Option;
import net.babelsoft.negatron.model.component.Choice;
import net.babelsoft.negatron.model.component.SlotOption;

public class Slot
extends Choice<SlotOption> {
    private static final long serialVersionUID = 1L;

    public Slot(String name) {
        super(name);
    }

    protected Slot(Slot ref) {
        super(ref);
    }

    protected Slot(String name, Slot ref) {
        super(name, ref);
    }

    @Override
    public void setDefaultValue() {
        this.defaultValue = SlotOption.EMPTY_SLOT;
    }

    @Override
    public void addOption(SlotOption option, boolean isDefault) {
        if (this.getOptions().isEmpty()) {
            super.addOption(SlotOption.EMPTY_SLOT, true);
        }
        super.addOption(option, isDefault);
    }

    public Slot copy() {
        return new Slot(this);
    }

    public Slot copy(String newName) {
        return new Slot(newName, this);
    }

    @Override
    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEmptyElement("slot");
        writer.writeAttribute("name", this.getName());
        Object v = this.getValue();
        if (v != SlotOption.EMPTY_SLOT && !((Option)v).getName().isEmpty() && !((Option)v).getName().equals("\"\"")) {
            writer.writeAttribute("value", ((Option)v).getName());
            writer.writeAttribute("description", ((Option)v).getDescription());
            if (v == this.getDefaultValue()) {
                writer.writeAttribute("default", Boolean.TRUE.toString());
            }
        }
    }
}

