/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.favourites;

import java.time.LocalDateTime;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.babelsoft.negatron.io.XmlOutput;
import net.babelsoft.negatron.model.IconDescription;
import net.babelsoft.negatron.model.component.MachineElement;
import net.babelsoft.negatron.model.component.MachineElementList;
import net.babelsoft.negatron.model.favourites.MachineConfiguration;
import net.babelsoft.negatron.model.favourites.SoftwareConfiguration;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.theme.Language;

public class Favourite
implements XmlOutput {
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<Machine> machine = new SimpleObjectProperty();
    private final ObjectProperty<SoftwareConfiguration> softwareConfiguration = new SimpleObjectProperty();
    private final ObjectProperty<MachineConfiguration> machineConfiguration = new SimpleObjectProperty();
    private final ReadOnlyDateTimeProperty dateCreated = new ReadOnlyDateTimeProperty();
    private final ReadOnlyDateTimeProperty dateModified = new ReadOnlyDateTimeProperty();
    private final transient ObjectProperty<IconDescription> iconName = new SimpleObjectProperty();
    private transient String shortcut;
    private transient BooleanProperty invalidated;
    private transient boolean disableDateModifiedUpdate;
    private transient boolean machineEditable;
    private transient BooleanProperty mustMigrate = new SimpleBooleanProperty();

    protected Favourite() {
        this.dateCreated.set(LocalDateTime.now());
        this.dateModified.set(LocalDateTime.now());
    }

    protected Favourite(LocalDateTime dateCreated, LocalDateTime dateModified) {
        this.dateCreated.set(dateCreated);
        this.dateModified.set(dateModified);
    }

    protected Favourite(Favourite ref) {
        this(ref.getName(), ref.getMachine(), ref.getSoftwareConfiguration(), ref.getMachineConfiguration(), LocalDateTime.now(), LocalDateTime.now(), ref.getIconName() != null ? ref.getIconName().getIcon() : null);
    }

    public Favourite(String name, Image image) {
        this(name, image, true);
    }

    protected Favourite(String name, Image image, boolean machineEditable) {
        this(name, null, null, null, LocalDateTime.now(), LocalDateTime.now(), image);
        this.machineEditable = machineEditable;
    }

    public Favourite(String commandLine) {
        this(Language.Manager.getString("newCommandLine"), null, null, new MachineConfiguration(commandLine), LocalDateTime.now(), LocalDateTime.now());
    }

    public Favourite(Machine machine, SoftwareConfiguration softwareConfiguration) {
        this(softwareConfiguration != null ? softwareConfiguration.getSoftware().getDescription() : machine.getDescription(), machine, softwareConfiguration, MachineConfiguration.buildFromParameters(machine), LocalDateTime.now(), LocalDateTime.now());
    }

    public Favourite(String name, Machine machine, SoftwareConfiguration softwareConfiguration, MachineConfiguration machineConfiguration, LocalDateTime dateCreated, LocalDateTime dateModified) {
        this(name, machine, softwareConfiguration, machineConfiguration, dateCreated, dateModified, machine != null ? machine.getIconDescription().getIcon() : null);
    }

    protected Favourite(String name, Machine machine, SoftwareConfiguration softwareConfiguration, MachineConfiguration machineConfiguration, LocalDateTime dateCreated, LocalDateTime dateModified, Image image) {
        this.setName(name);
        this.setMachine(machine);
        this.setSoftwareConfiguration(softwareConfiguration);
        this.setMachineConfiguration(machineConfiguration);
        this.shortcut = name.replace(" ", "").toLowerCase();
        this.invalidated = new SimpleBooleanProperty();
        this.dateCreated.set(dateCreated);
        this.dateModified.set(dateModified);
        this.nameProperty().addListener(l -> this.dateModified.set(LocalDateTime.now()));
        this.machineProperty().addListener(l -> {
            if (!this.disableDateModifiedUpdate) {
                this.dateModified.set(LocalDateTime.now());
            }
        });
        this.softwareConfigurationProperty().addListener(l -> {
            if (!this.disableDateModifiedUpdate) {
                this.dateModified.set(LocalDateTime.now());
            }
        });
        this.machineConfigurationProperty().addListener(l -> {
            if (!this.disableDateModifiedUpdate) {
                this.dateModified.set(LocalDateTime.now());
            }
        });
        this.setIcon(image);
        this.nameProperty().addListener((o, oV, newValue) -> {
            IconDescription icon = this.getIconName();
            if (icon == null || !icon.getDescription().equals(newValue)) {
                this.setIconName(new IconDescription((String)newValue, this.getMachine() != null ? this.getMachine().getIconDescription().getIcon() : null));
            }
            this.shortcut = newValue.replace(" ", "").toLowerCase();
        });
        this.iconNameProperty().addListener((o, oV, newValue) -> {
            if (newValue != null && !newValue.getDescription().equals(this.getName())) {
                this.setName(newValue.getDescription());
            }
        });
        ChangeListener listener = (o, oV, newValue) -> this.setIcon(newValue.getIcon());
        if (machine != null) {
            machine.iconDescriptionProperty().addListener(listener);
        }
        this.machineProperty().addListener((o, oldMachine, newMachine) -> {
            if (oldMachine != null) {
                oldMachine.iconDescriptionProperty().removeListener(listener);
            }
            if (newMachine != null) {
                listener.changed(null, null, (Object)newMachine.getIconDescription());
                newMachine.iconDescriptionProperty().addListener(listener);
            }
        });
    }

    public final String getName() {
        return (String)this.name.get();
    }

    public final void setName(String value) {
        this.name.set((Object)value);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final Machine getMachine() {
        return (Machine)this.machine.get();
    }

    public final void setMachine(Machine value) {
        this.machine.set((Object)value);
    }

    public void resetMachine() {
        this.machineEditable = true;
    }

    public void resetMachine(Machine value) {
        this.disableDateModifiedUpdate = true;
        this.setMachine(value);
        this.disableDateModifiedUpdate = false;
    }

    public final ObjectProperty<Machine> machineProperty() {
        return this.machine;
    }

    public boolean isMachineEditable() {
        return this.machineEditable;
    }

    public final SoftwareConfiguration getSoftwareConfiguration() {
        return (SoftwareConfiguration)this.softwareConfiguration.get();
    }

    public final void setSoftwareConfiguration(SoftwareConfiguration value) {
        this.softwareConfiguration.set((Object)value);
    }

    public void resetSoftwareConfiguration(SoftwareConfiguration value) {
        this.disableDateModifiedUpdate = true;
        this.setSoftwareConfiguration(value);
        this.disableDateModifiedUpdate = false;
    }

    public final ObjectProperty<SoftwareConfiguration> softwareConfigurationProperty() {
        return this.softwareConfiguration;
    }

    public final MachineConfiguration getMachineConfiguration() {
        return (MachineConfiguration)this.machineConfiguration.get();
    }

    public final void setMachineConfiguration(MachineConfiguration value) {
        this.machineConfiguration.set((Object)value);
    }

    public void resetMachineConfiguration(MachineConfiguration value) {
        this.disableDateModifiedUpdate = true;
        this.setMachineConfiguration(value);
        this.disableDateModifiedUpdate = false;
    }

    public final ObjectProperty<MachineConfiguration> machineConfigurationProperty() {
        return this.machineConfiguration;
    }

    public final LocalDateTime getDateCreated() {
        return this.dateCreated.get();
    }

    public final ReadOnlyObjectProperty<LocalDateTime> dateCreatedProperty() {
        return this.dateCreated;
    }

    public final LocalDateTime getDateModified() {
        return this.dateModified.get();
    }

    public final ReadOnlyObjectProperty<LocalDateTime> dateModifiedProperty() {
        return this.dateModified;
    }

    public final IconDescription getIconName() {
        return (IconDescription)this.iconName.get();
    }

    public final void setIconName(IconDescription value) {
        this.iconName.set((Object)value);
    }

    public final void setIcon(Image icon) {
        this.setIconName(new IconDescription(this.getName(), icon));
    }

    public final ObjectProperty<IconDescription> iconNameProperty() {
        return this.iconName;
    }

    public final String getShortcut() {
        return this.shortcut;
    }

    public boolean isInvalidated() {
        return this.invalidated.get();
    }

    public void setInvalidated(boolean invalidated) {
        this.invalidated.set(invalidated);
    }

    public ReadOnlyBooleanProperty invalidatedProperty() {
        return this.invalidated;
    }

    public boolean mustMigrate() {
        return this.mustMigrate.get();
    }

    public void setMustMigrate(boolean mustMigrate) {
        this.mustMigrate.set(mustMigrate);
    }

    public ReadOnlyBooleanProperty mustMigrateProperty() {
        return this.mustMigrate;
    }

    public void checkValidity() {
        this.setInvalidated(this.isMachineInvalid() || this.isSoftwareInvalid());
    }

    public boolean isMachineInvalid() {
        Machine m = this.getMachine();
        return m != null && m.getGroup().isEmpty();
    }

    public boolean isSoftwareInvalid() {
        SoftwareConfiguration s = this.getSoftwareConfiguration();
        return s != null && s.getSoftware() != null && s.getSoftware().getGroup().isEmpty();
    }

    public Favourite copy() {
        return new Favourite(this);
    }

    public void setChildren(ObservableList<TreeItem<Favourite>> children) {
    }

    @Override
    public void write(XMLStreamWriter writer) throws XMLStreamException {
        Machine m = this.getMachine();
        MachineConfiguration machineConf = this.getMachineConfiguration();
        SoftwareConfiguration softwareConf = this.getSoftwareConfiguration();
        if (m != null || machineConf != null || softwareConf != null) {
            writer.writeStartElement("favourite");
        } else {
            writer.writeEmptyElement("favourite");
        }
        writer.writeAttribute("name", this.getName());
        writer.writeAttribute("dateModified", this.getDateModified().toString());
        writer.writeAttribute("dateCreated", this.getDateCreated().toString());
        if (m != null) {
            if (machineConf != null && (machineConf.isCommandLine() || machineConf.getParameters().size() > 0)) {
                writer.writeStartElement("machineConfiguration");
            } else {
                writer.writeEmptyElement("machineConfiguration");
            }
            writer.writeAttribute("name", m.getName());
            writer.writeAttribute("description", m.getDescription());
            if (machineConf != null) {
                writer.writeAttribute("configurable", Boolean.toString(machineConf.isConfigurable()));
                if (!machineConf.isCommandLine()) {
                    MachineElementList parameters = machineConf.getParameters();
                    if (parameters.size() > 0) {
                        writer.writeStartElement("parameters");
                        for (MachineElement parameter : parameters) {
                            parameter.write(writer);
                        }
                        writer.writeEndElement();
                    }
                } else {
                    writer.writeStartElement("commandLine");
                    writer.writeCharacters(machineConf.getCommandLine());
                    writer.writeEndElement();
                }
                if (machineConf.isCommandLine() || machineConf.getParameters().size() > 0) {
                    writer.writeEndElement();
                }
            }
        }
        if (softwareConf != null) {
            writer.writeEmptyElement("softwareConfiguration");
            Software software = softwareConf.getSoftware();
            writer.writeAttribute("name", software.getName());
            writer.writeAttribute("description", software.getDescription());
            writer.writeAttribute("list", software.getGroup());
            writer.writeAttribute("device", softwareConf.getDevice());
            if (softwareConf.getSoftwarePart() != null) {
                writer.writeAttribute("part", softwareConf.getSoftwarePart().getName());
            }
        }
        if (m != null || machineConf != null || softwareConf != null) {
            writer.writeEndElement();
        }
    }

    private final class ReadOnlyDateTimeProperty
    extends ReadOnlyObjectPropertyBase<LocalDateTime> {
        private LocalDateTime date;

        private ReadOnlyDateTimeProperty() {
        }

        private void set(LocalDateTime newValue) {
            this.date = newValue;
            this.fireValueChangedEvent();
        }

        public final LocalDateTime get() {
            return this.date;
        }

        public Object getBean() {
            return Favourite.this;
        }

        public String getName() {
            return "datetime";
        }
    }
}

