/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.favourites;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.babelsoft.negatron.io.XmlOutput;
import net.babelsoft.negatron.model.favourites.Favourite;

public class Folder
extends Favourite {
    private ObservableList<TreeItem<Favourite>> children;

    protected Folder(Folder ref) {
        this(ref.getName(), ref.getIconName() != null ? ref.getIconName().getIcon() : null);
    }

    public Folder(String name, Image image) {
        super(name, image, false);
    }

    public Folder(String name, LocalDateTime dateCreated, LocalDateTime dateModified) {
        super(name, null, null, null, dateCreated, dateModified);
    }

    private boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    private List<XmlOutput> getChildren() {
        return this.children.stream().map(item -> (XmlOutput)item.getValue()).collect(Collectors.toList());
    }

    @Override
    public void setChildren(ObservableList<TreeItem<Favourite>> children) {
        this.children = children;
    }

    @Override
    public Favourite copy() {
        return new Folder(this);
    }

    @Override
    public void write(XMLStreamWriter writer, boolean isRoot) throws XMLStreamException {
        String tag;
        String string = tag = isRoot ? "root" : "folder";
        if (this.hasChildren()) {
            writer.writeStartElement(tag);
        } else {
            writer.writeEmptyElement(tag);
        }
        if (isRoot) {
            writer.writeDefaultNamespace("http://www.babelsoft.net/products/negatron/favourites");
            writer.writeAttribute("version", "1.1");
            writer.writeAttribute("dateTreeModified", LocalDateTime.now().toString());
        }
        writer.writeAttribute("name", this.getName());
        writer.writeAttribute("dateModified", this.getDateModified().toString());
        writer.writeAttribute("dateCreated", this.getDateCreated().toString());
        if (this.hasChildren()) {
            writer.writeStartElement("children");
            for (XmlOutput child : this.getChildren()) {
                child.write(writer);
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    @Override
    public void write(XMLStreamWriter writer) throws XMLStreamException {
        this.write(writer, false);
    }
}

