/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.favourites;

import net.babelsoft.negatron.model.component.MachineElementList;
import net.babelsoft.negatron.model.item.Machine;

public class MachineConfiguration {
    private final String commandLine;
    private final boolean configurable;
    private final MachineElementList parameters;

    public MachineConfiguration(String commandLine) {
        this.commandLine = commandLine != null ? commandLine : "";
        this.configurable = true;
        this.parameters = null;
    }

    public MachineConfiguration(MachineElementList parameters, boolean configurable) {
        this.commandLine = null;
        this.configurable = configurable;
        this.parameters = parameters;
    }

    public static MachineConfiguration buildFromCommandLine(Machine machine) {
        return new MachineConfiguration(machine.toCommandLine());
    }

    public static MachineConfiguration buildFromParameters(Machine machine) {
        return new MachineConfiguration(machine.copyParameters(), machine.isConfigurable());
    }

    public boolean isCommandLine() {
        return this.commandLine != null;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public MachineElementList getParameters() {
        return this.parameters;
    }
}

