/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.favourites;

import net.babelsoft.negatron.model.Describable;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.model.item.SoftwarePart;

public class SoftwareConfiguration
implements Describable {
    private final String machine;
    private final String device;
    private final Software software;
    private final SoftwarePart softwarePart;

    public SoftwareConfiguration(Machine machine, Device device, Software software) {
        this.machine = machine.getName();
        this.device = device.getName();
        this.software = software;
        String deviceValue = device.getValue();
        if (deviceValue.contains(":")) {
            String softwarePartName = deviceValue.split(":")[1];
            this.softwarePart = software.getSoftwareParts().stream().filter(part -> part.getName().equals(softwarePartName)).findAny().orElse(null);
        } else {
            this.softwarePart = null;
        }
    }

    public String getMachine() {
        return this.machine;
    }

    public String getDevice() {
        return this.device;
    }

    public Software getSoftware() {
        return this.software;
    }

    public SoftwarePart getSoftwarePart() {
        return this.softwarePart;
    }

    @Override
    public String getDescription() {
        return this.software.getDescription();
    }

    public String toString() {
        return String.format("-%s %s%s", this.device, this.software.getName(), this.softwarePart != null ? ":" + this.softwarePart.getName() : "");
    }
}

