/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.item;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.image.Image;
import net.babelsoft.negatron.io.extras.Icons;
import net.babelsoft.negatron.model.IconDescription;
import net.babelsoft.negatron.model.Status;
import net.babelsoft.negatron.model.Support;
import net.babelsoft.negatron.model.item.Item;

public abstract class EmulatedItem<T>
extends Item {
    private static final long serialVersionUID = 4L;
    private String group;
    private String year;
    private boolean configurable;
    private T parent;
    private String shortcut;
    private Support support;
    private transient ObjectProperty<Status> status;
    private transient ObjectProperty<IconDescription> iconDescription;

    public EmulatedItem(String name, String group) {
        super(name);
        this.setGroup(group);
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
        this.shortcut = description.replace(" ", "").toLowerCase();
    }

    private void setShortcut(String shortcut) {
        this.shortcut = shortcut;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    private void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getYear() {
        return this.year;
    }

    public void setConfigurable(boolean configurable) {
        this.configurable = configurable;
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public abstract void setNotCompatible();

    public abstract boolean isNotCompatible();

    public Support getSupport() {
        return this.support;
    }

    public void setSupport(Support support) {
        this.support = support;
    }

    public void setSupport(String support) {
        this.setSupport(Support.fromString(support));
    }

    public ObjectProperty<Status> statusProperty() {
        if (this.status == null) {
            this.status = new SimpleObjectProperty((Object)Status.UNKNOWN);
        }
        return this.status;
    }

    public Status getStatus() {
        return (Status)this.statusProperty().get();
    }

    public void setStatus(Status status) {
        this.statusProperty().set((Object)status);
    }

    public ObjectProperty<IconDescription> iconDescriptionProperty() {
        if (this.iconDescription == null) {
            this.iconDescription = new SimpleObjectProperty((Object)new IconDescription(this.getDescription(), Icons.DEFAULT_ICON));
        }
        return this.iconDescription;
    }

    public IconDescription getIconDescription() {
        return (IconDescription)this.iconDescriptionProperty().get();
    }

    public void setIconDescription(IconDescription iconDescription) {
        this.iconDescriptionProperty().set((Object)iconDescription);
    }

    public void setIcon(Image icon) {
        if (icon == null) {
            icon = Icons.DEFAULT_ICON;
        }
        this.setIconDescription(new IconDescription(this.getDescription(), icon));
    }

    public abstract String getCompany();

    public void setParent(T parent) {
        this.parent = parent;
    }

    public T getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isRunnable() {
        return true;
    }

    public void reset() {
    }
}

