/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.item;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.util.Pair;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.model.ControllerType;
import net.babelsoft.negatron.model.Describable;
import net.babelsoft.negatron.model.DisplayType;
import net.babelsoft.negatron.model.ParametrisedElement;
import net.babelsoft.negatron.model.ScreenOrientation;
import net.babelsoft.negatron.model.SoftwareListFilter;
import net.babelsoft.negatron.model.SoundType;
import net.babelsoft.negatron.model.Status;
import net.babelsoft.negatron.model.Support;
import net.babelsoft.negatron.model.comparing.InternalDeviceComparator;
import net.babelsoft.negatron.model.comparing.Merger;
import net.babelsoft.negatron.model.component.Bios;
import net.babelsoft.negatron.model.component.BiosSet;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.model.component.MachineElementList;
import net.babelsoft.negatron.model.component.Ram;
import net.babelsoft.negatron.model.component.RamOption;
import net.babelsoft.negatron.model.component.Slot;
import net.babelsoft.negatron.model.component.SlotOption;
import net.babelsoft.negatron.model.item.EmulatedItem;
import net.babelsoft.negatron.model.item.SoftwareList;

public class Machine
extends EmulatedItem<Machine>
implements Describable,
ParametrisedElement {
    private static final long serialVersionUID = 11L;
    private boolean runnable;
    private boolean mechanical;
    private boolean coinSlot;
    private boolean serviceMode;
    private boolean tilt;
    private boolean softwareEmbedded;
    private int maxNumberPlayers;
    private String manufacturer;
    private DisplayType displayType;
    private ScreenOrientation screenOrientation;
    private SoundType soundType;
    private EnumSet<ControllerType> controllerTypes;
    private Map<String, String> internalDevices;
    private List<SoftwareListFilter> softwareLists;
    private transient MachineElementList parameters;
    private transient Merger merger;
    private transient InternalDeviceComparator internalDeviceComparator;
    private Bios bios;
    private Ram ram;
    private List<Device> devices;
    private List<Slot> slots;
    private List<Pair<String, String>> defaultSlotOptions;

    public Machine(String name, String sourceFile) {
        super(name, Machine.sourceFileToGroup(sourceFile));
        this.mechanical = false;
        this.coinSlot = false;
        this.serviceMode = false;
        this.tilt = false;
        this.softwareEmbedded = true;
        this.maxNumberPlayers = 0;
        this.displayType = DisplayType.none;
        this.screenOrientation = ScreenOrientation.NONE;
        this.soundType = SoundType.NONE;
        this.controllerTypes = EnumSet.noneOf(ControllerType.class);
    }

    protected Machine(String name) {
        super(name, null);
        this.setDescription(name);
        this.setSupport(Support.NOT_COMPATIBLE);
        this.setStatus(Status.GOOD);
    }

    private static String sourceFileToGroup(String sourceFile) {
        if (sourceFile.contains(".")) {
            int index = sourceFile.lastIndexOf(".");
            return sourceFile.substring(0, index);
        }
        return sourceFile;
    }

    public boolean isFolder() {
        return this.getGroup() == null;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    private String getManufacturer() {
        return this.manufacturer;
    }

    public void setRunnable(boolean isRunnable) {
        this.runnable = isRunnable;
    }

    @Override
    public boolean isRunnable() {
        return this.runnable;
    }

    public void setMechanical(boolean isMechanical) {
        this.mechanical = isMechanical;
    }

    public boolean isMechanical() {
        return this.mechanical;
    }

    public void setCoinSlot(boolean hasCoinSlot) {
        this.coinSlot = hasCoinSlot;
    }

    public boolean hasCoinSlot() {
        return this.coinSlot;
    }

    public void setServiceMode(boolean hasServiceMode) {
        this.serviceMode = hasServiceMode;
    }

    public boolean hasServiceMode() {
        return this.serviceMode;
    }

    public void setTilt(boolean hasTilt) {
        this.tilt = hasTilt;
    }

    public boolean hasTilt() {
        return this.tilt;
    }

    public void setSoftwareEmbedded(boolean softwareEmbedded) {
        this.softwareEmbedded = softwareEmbedded;
    }

    public boolean isSoftwareEmbedded() {
        return this.softwareEmbedded;
    }

    public void setMaxNumberPlayers(int maxNumberPlayers) {
        this.maxNumberPlayers = maxNumberPlayers;
    }

    public void setMaxNumberPlayers(String maxNumberPlayers) {
        this.maxNumberPlayers = Integer.valueOf(maxNumberPlayers);
    }

    public int getMaxNumberPlayers() {
        return this.maxNumberPlayers;
    }

    public void setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = DisplayType.valueOf(displayType);
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setScreenOrientation(ScreenOrientation screenOrientation) {
        this.screenOrientation = screenOrientation;
    }

    public void setScreenOrientation(String screenOrientation) {
        this.screenOrientation = ScreenOrientation.getValue(screenOrientation);
    }

    public ScreenOrientation getScreenOrientation() {
        return this.screenOrientation;
    }

    public void setSoundType(SoundType soundType) {
        this.soundType = soundType;
    }

    public void setSoundType(String soundType) {
        this.soundType = SoundType.getValue(soundType);
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public void addControllerType(String controllerType) {
        ControllerType value;
        try {
            value = ControllerType.valueOf(controllerType);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        this.controllerTypes.add(value);
    }

    public boolean hasControllerTypes() {
        return !this.controllerTypes.isEmpty();
    }

    public boolean hasControllerType(ControllerType type) {
        return this.controllerTypes.contains((Object)type);
    }

    @Override
    public void setNotCompatible() {
    }

    @Override
    public boolean isNotCompatible() {
        return false;
    }

    @Override
    public String getCompany() {
        return this.getManufacturer();
    }

    public void addInternalDevice(String name, String description) {
        if (this.internalDevices == null) {
            this.internalDevices = new HashMap<String, String>();
        }
        this.internalDevices.put(name, description);
    }

    public Map<String, String> getInternalDevices() {
        return this.internalDevices;
    }

    public void processInternalDevices() {
        this.internalDeviceComparator.compare(this.internalDevices);
    }

    public boolean hasNewInternalDevices() {
        return this.internalDeviceComparator.hasChanged();
    }

    public void addSoftwareList(String softwareList, String filter) {
        if (this.softwareLists == null) {
            this.softwareLists = new ArrayList<SoftwareListFilter>();
        }
        this.softwareLists.add(new SoftwareListFilter(softwareList, filter));
    }

    public List<SoftwareListFilter> getSoftwareLists() {
        return this.softwareLists;
    }

    public Merger reset(String origin) {
        if (this.merger == null) {
            this.merger = new Merger(this);
            this.internalDeviceComparator = new InternalDeviceComparator();
        }
        this.merger.reset(origin);
        if (Configuration.Manager.isAsyncExecutionMode()) {
            this.internalDevices = new HashMap<String, String>();
            this.softwareLists = null;
        }
        return this.merger;
    }

    public void setParameters(MachineElementList parameters) {
        this.parameters = parameters;
        if (Configuration.Manager.isSyncExecutionMode()) {
            if (this.slots != null) {
                this.slots.clear();
            }
            if (this.devices != null) {
                this.devices.clear();
            }
            parameters.forEach(param -> {
                if (param instanceof Slot) {
                    if (this.slots == null) {
                        this.slots = new ArrayList<Slot>();
                    }
                    this.slots.add((Slot)param);
                } else if (param instanceof Device) {
                    if (this.devices == null) {
                        this.devices = new ArrayList<Device>();
                    }
                    this.devices.add((Device)param);
                }
            });
        }
    }

    public MachineElementList getParameters() {
        return this.parameters;
    }

    public void forceParameters(MachineElementList parameters) {
        this.setParameters(parameters);
        this.merger = new Merger(this, parameters);
        this.internalDeviceComparator = new InternalDeviceComparator();
    }

    @Override
    public boolean isReady() {
        return !this.parameters.stream().anyMatch(param -> !param.isReady());
    }

    public MachineElementList copyParameters() {
        if (this.parameters != null) {
            return this.parameters.copy();
        }
        return new MachineElementList(this);
    }

    @Override
    public List<String> parameters() {
        return this.parameters(null);
    }

    public List<String> parameters(String origin) {
        if (this.parameters == null) {
            this.parameters = new MachineElementList(this);
        }
        return this.parameters.toParameters(origin);
    }

    public String toCommandLine() {
        if (this.parameters == null) {
            this.parameters = new MachineElementList(this);
        }
        return this.parameters.toString();
    }

    public Bios getBios() {
        return this.bios;
    }

    public void addBiosSet(String name, String description, boolean isDefault) {
        BiosSet set = new BiosSet(name, description);
        if (this.bios == null) {
            this.bios = new Bios();
        }
        this.bios.addOption(set, isDefault);
    }

    public Ram getRam() {
        return this.ram;
    }

    public void addRamOption(String name, boolean isDefault) {
        RamOption option = new RamOption(name);
        if (this.ram == null) {
            this.ram = new Ram();
        }
        this.ram.addOption(option, isDefault);
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public void addDevice(String name, String type, String tag, String interfaceFormat, boolean mandatory) {
        Device device = new Device(name, type, tag, mandatory);
        device.setInterfaceFormats(interfaceFormat != null ? interfaceFormat.split(",") : new String[]{});
        if (this.devices == null) {
            this.devices = new ArrayList<Device>();
        }
        this.devices.add(device);
    }

    public void addExtensionToLastDevice(String name) {
        this.devices.get(this.devices.size() - 1).addExtension(name);
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public void addSlot(String name) {
        Slot slot = new Slot(name);
        if (this.slots == null) {
            this.slots = new ArrayList<Slot>();
        }
        this.slots.add(slot);
    }

    public SlotOption addSlotOptionToLastSlot(String name, boolean isDefault) {
        SlotOption option = new SlotOption(name);
        this.slots.get(this.slots.size() - 1).addOption(option, isDefault);
        return option;
    }

    public List<Pair<String, String>> getDefaultSlotOptions() {
        return this.defaultSlotOptions;
    }

    public void initialise(Map<String, SoftwareList> softwareListMap) {
        if (this.slots != null) {
            this.slots.removeIf(slot -> slot.size() == 0);
            if (!this.slots.isEmpty()) {
                this.defaultSlotOptions = new ArrayList<Pair<String, String>>();
                this.slots.stream().forEach(slot -> this.defaultSlotOptions.add((Pair<String, String>)new Pair((Object)slot.getName(), (Object)((SlotOption)slot.getDefaultValue()).getName())));
            } else {
                this.slots = null;
            }
        }
        if (this.devices != null && this.softwareLists != null) {
            this.devices.stream().forEach(device -> this.softwareLists.stream().flatMap(softwareListFilter -> {
                SoftwareList softwareList = (SoftwareList)softwareListMap.get(softwareListFilter.getSoftwareList());
                if (softwareList != null) {
                    return softwareList.getSoftwares(device.getInterfaceFormats(), softwareListFilter.getFilter()).stream();
                }
                return null;
            }).findAny().ifPresent(software -> device.setCompatibleSoftwareLists(true)));
        }
    }
}

