/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.item;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.babelsoft.negatron.model.Support;
import net.babelsoft.negatron.model.item.EmulatedItem;
import net.babelsoft.negatron.model.item.SoftwarePart;

public class Software
extends EmulatedItem<Software> {
    private static final long serialVersionUID = 3L;
    private static final List<SoftwarePart> EMPTY = Collections.emptyList();
    private List<SoftwarePart> parts;
    private String[] compatibility;
    private Requirement requirement;
    private String publisher;
    private transient Support displayedSupport;

    public Software(String name, String softwareList, Support support) {
        super(name, softwareList);
        this.setSupport(support);
    }

    public Software(String name, String softwareList, String support) {
        this(name, softwareList, Support.fromString(support));
    }

    public Software(String name, String softwareList) {
        this(name, softwareList, Support.NOT_AVAILABLE);
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    private String getPublisher() {
        return this.publisher;
    }

    public void addSoftwarePart(SoftwarePart part) {
        if (this.parts == null) {
            this.parts = new ArrayList<SoftwarePart>(1);
        }
        this.parts.add(part);
    }

    public void setLastPartDescription(String description) {
        this.parts.get(this.parts.size() - 1).setDescription(description);
    }

    public void trimSoftwareParts() {
        if (this.parts.size() <= 1) {
            this.parts = null;
        } else {
            this.setConfigurable(true);
        }
    }

    public void setSoftwareParts(List<SoftwarePart> parts) {
        this.parts = parts;
    }

    public List<SoftwarePart> getSoftwareParts() {
        if (this.parts == null) {
            return EMPTY;
        }
        return this.parts;
    }

    public void setCompatibility(String[] compatibility) {
        this.compatibility = compatibility;
    }

    public String[] getCompatibility() {
        return this.compatibility;
    }

    public void setRequirement(String requirementCommand) {
        if (requirementCommand.contains(":")) {
            String[] requirementArray = requirementCommand.split(":");
            this.requirement = new Requirement(requirementArray[0], requirementArray[1]);
        } else {
            this.requirement = new Requirement(requirementCommand);
        }
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    @Override
    public void setNotCompatible() {
        this.displayedSupport = Support.NOT_COMPATIBLE;
    }

    @Override
    public boolean isNotCompatible() {
        return this.displayedSupport == Support.NOT_COMPATIBLE;
    }

    @Override
    public Support getSupport() {
        return this.displayedSupport;
    }

    @Override
    public String getCompany() {
        return this.getPublisher();
    }

    @Override
    public void reset() {
        this.displayedSupport = super.getSupport();
    }

    public static class Requirement
    implements Serializable {
        private static final long serialVersionUID = 2L;
        private String softwareList;
        private String software;

        private Requirement(String softwareList, String software) {
            this.softwareList = softwareList;
            this.software = software;
        }

        private Requirement(String software) {
            this.software = software;
        }

        public String getSoftwareList() {
            return this.softwareList;
        }

        public String getSoftware() {
            return this.software;
        }
    }
}

