/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.model.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.babelsoft.negatron.model.item.Item;
import net.babelsoft.negatron.model.item.Software;

public class SoftwareList
extends Item {
    private static final long serialVersionUID = 5L;
    private final Map<String, Software> softwareMap = new HashMap<String, Software>();
    private final Map<String, List<Software>> interfaceSoftwareMap = new HashMap<String, List<Software>>();
    private final Map<String, List<String>> softwareInterfaceMap = new HashMap<String, List<String>>();

    public SoftwareList(String name, String description) {
        super(name);
        this.setDescription(description);
    }

    public void addSoftware(Software software) {
        this.softwareMap.put(software.getName(), software);
        ArrayList interfaceFormats = new ArrayList(1);
        software.getSoftwareParts().stream().map(part -> part.getInterfaceFormat()).distinct().forEach(interfaceFormat -> {
            interfaceFormats.add(interfaceFormat);
            List<Software> softwares = this.interfaceSoftwareMap.get(interfaceFormat);
            if (softwares == null) {
                softwares = new ArrayList<Software>();
                this.interfaceSoftwareMap.put((String)interfaceFormat, softwares);
            }
            softwares.add(software);
        });
        this.softwareInterfaceMap.put(software.getName(), interfaceFormats);
        software.trimSoftwareParts();
    }

    public Software getSoftware(String name) {
        return this.softwareMap.get(name);
    }

    public List<Software> getSoftwares(List<String> interfaceFormats, String filter) {
        return interfaceFormats.stream().flatMap(interfaceFormat -> this.getSoftwares((String)interfaceFormat, filter).stream()).collect(Collectors.toList());
    }

    private List<Software> getSoftwares(String interfaceFormat, String filter) {
        List<Software> softwares = this.interfaceSoftwareMap.get(interfaceFormat);
        if (softwares != null) {
            if (filter != null) {
                if (filter.charAt(0) == '!') {
                    String unwantedFormat = filter.substring(1);
                    return softwares.stream().filter(software -> {
                        String[] compatibility = software.getCompatibility();
                        return compatibility == null || Arrays.stream(compatibility).allMatch(format -> !format.equals(unwantedFormat));
                    }).collect(Collectors.toList());
                }
                String expectedFormat = filter;
                return softwares.stream().filter(software -> {
                    String[] compatibility = software.getCompatibility();
                    return compatibility == null || Arrays.stream(compatibility).anyMatch(format -> format.equals(expectedFormat));
                }).collect(Collectors.toList());
            }
            return softwares;
        }
        return new ArrayList<Software>();
    }

    public String getInterfaceFormat(String software) {
        List<String> interfaceFormats = this.softwareInterfaceMap.get(software);
        if (interfaceFormats != null && interfaceFormats.size() > 0) {
            return interfaceFormats.get(0);
        }
        return null;
    }
}

