/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.theme;

import java.util.function.Consumer;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import net.babelsoft.negatron.model.component.Bios;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.model.component.MachineComponent;
import net.babelsoft.negatron.model.component.Slot;
import net.babelsoft.negatron.model.item.Machine;

public class Components {
    private static final String imagePath = "/net/babelsoft/negatron/resource/icon/device/";

    private Components() {
    }

    public static ImageView loadIcon(Machine machine, MachineComponent<?, ?> machineComponent) {
        Image[] image = new Image[1];
        Consumer<String> setImage = filename -> {
            image[0] = new Image(Components.class.getResourceAsStream(imagePath + filename));
        };
        if (machineComponent instanceof Device) {
            Device device = (Device)machineComponent;
            block19 : switch (device.getType()) {
                case "cartridge": {
                    switch (device.getTag()) {
                        case "mdslot:rom_sk:subslot": {
                            setImage.accept("megadriv_cart.rom_sk.png");
                            break block19;
                        }
                        case "mdslot:rom_ggenie:subslot": {
                            setImage.accept("megadriv_cart.rom_ggenie.png");
                            break block19;
                        }
                        case "snsslot:bsxrom:bs_slot": {
                            setImage.accept("bspack.bsxrom.png");
                            break block19;
                        }
                        case "snsslot:lorom_sgb:gb_slot": {
                            setImage.accept("gameboy_cart.lorom_sgb.png");
                            break block19;
                        }
                        case "snsslot:lorom_sufami:st_slot1": 
                        case "snsslot:lorom_sufami:st_slot2": {
                            setImage.accept("snes_cart.lorom_sufami.png");
                            break block19;
                        }
                        case "slot:mgear:subslot": {
                            setImage.accept("sms_cart.mgear.png");
                            break block19;
                        }
                    }
                    setImage.accept("media-cartridge.png");
                    break;
                }
                case "harddisk": {
                    setImage.accept("drive-harddisk.png");
                    break;
                }
                case "cdrom": {
                    setImage.accept("media-optical.png");
                    break;
                }
                case "floppydisk": {
                    if (device.getInterfaceFormats().contains("floppy_3_5")) {
                        setImage.accept("media-floppy_3_5.png");
                        break;
                    }
                    if (device.getInterfaceFormats().contains("floppy_8")) {
                        setImage.accept("media-floppy_8.png");
                        break;
                    }
                    if (device.getInterfaceFormats().contains("floppy_3")) {
                        setImage.accept("media-floppy_3_5.png");
                        break;
                    }
                    setImage.accept("media-floppy_5_25.png");
                    break;
                }
                case "cassette": {
                    setImage.accept("media-tape.png");
                    break;
                }
                case "printer": 
                case "printout": {
                    setImage.accept("printer.png");
                    break;
                }
                case "quickload": {
                    setImage.accept("application-x-trash.png");
                    break;
                }
                case "midiin": 
                case "midiout": 
                case "serial": {
                    setImage.accept("audio-input-line.png");
                    break;
                }
                case "memcard": {
                    setImage.accept("media-flash-memory-stick.png");
                    break;
                }
                case "snapshot": {
                    setImage.accept("digikam.png");
                    break;
                }
                case "cylinder": {
                    setImage.accept("media-cylinder.png");
                    break;
                }
                case "punchtape": {
                    setImage.accept("media-punchtape.png");
                    break;
                }
                case "magtape": {
                    setImage.accept("media-magtape.png");
                    break;
                }
                case "romimage": {
                    setImage.accept("media-flash.png");
                }
            }
        } else if (machineComponent instanceof Slot) {
            String name = ((Slot)machineComponent).getName();
            if (name.contains("ctrl") || name.contains("joy")) {
                setImage.accept("input-gaming.png");
            } else if (name.startsWith("ext")) {
                setImage.accept("audio-input-line.png");
            } else if (name.endsWith("kbd")) {
                setImage.accept("input-keyboard.png");
            } else if (name.startsWith("tape")) {
                setImage.accept("tape.png");
            } else {
                setImage.accept("audio-card.png");
            }
        } else if (machineComponent instanceof Bios) {
            setImage.accept("media-flash.png");
        } else {
            setImage.accept("ram.png");
        }
        return new ImageView(image[0]);
    }

    public static Label loadLabel(MachineComponent<?, ?> machineComponent) {
        return new Label(machineComponent.getName());
    }
}

