/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.theme;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public enum Language {
    Manager;

    private final ResourceBundle.Control CONTROL = new FileResourceControl();
    public final String ROOT_PATH = "theme/language";
    public final String MASK = "ui.*\\.properties";
    private final String FILE_PATH = "theme/language/ui";

    public ResourceBundle getBundle() {
        return ResourceBundle.getBundle("theme/language/ui", this.CONTROL);
    }

    public String getString(String key) {
        return this.getBundle().getString(key);
    }

    public String tryGetString(String key) {
        try {
            return this.getBundle().getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.getBundle().getString(key));
    }

    private static class FileResourceControl
    extends ResourceBundle.Control {
        private FileResourceControl() {
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            PropertyResourceBundle bundle = null;
            String resourceName = this.toResourceName(bundleName, "properties");
            if (resourceName == null) {
                return bundle;
            }
            Path path = Paths.get(resourceName, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);
                     InputStreamReader reader = new InputStreamReader(stream, "UTF-8");){
                    bundle = new PropertyResourceBundle(reader);
                }
            }
            return bundle;
        }
    }
}

