/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.babelsoft.negatron.util.DirectoryWatchService;

public class SimpleDirectoryWatchService
implements DirectoryWatchService,
Runnable {
    private final WatchService mWatchService = FileSystems.getDefault().newWatchService();
    private final AtomicBoolean mIsRunning = new AtomicBoolean(false);
    private final ConcurrentMap<WatchKey, Path> mWatchKeyToDirPathMap = SimpleDirectoryWatchService.newConcurrentMap();
    private final ConcurrentMap<Path, Set<DirectoryWatchService.OnFileChangeListener>> mDirPathToListenersMap = SimpleDirectoryWatchService.newConcurrentMap();
    private final ConcurrentMap<DirectoryWatchService.OnFileChangeListener, Set<PathMatcher>> mListenerToFilePatternsMap = SimpleDirectoryWatchService.newConcurrentMap();

    private SimpleDirectoryWatchService() throws IOException {
    }

    public static SimpleDirectoryWatchService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    private static <T> Set<T> newConcurrentSet() {
        return Collections.newSetFromMap(SimpleDirectoryWatchService.newConcurrentMap());
    }

    public static PathMatcher matcherForGlobExpression(String globPattern) {
        return FileSystems.getDefault().getPathMatcher("glob:" + globPattern);
    }

    public static boolean matches(Path input, PathMatcher pattern) {
        return pattern.matches(input);
    }

    public static boolean matchesAny(Path input, Set<PathMatcher> patterns) {
        return patterns.stream().anyMatch(pattern -> SimpleDirectoryWatchService.matches(input, pattern));
    }

    private Path getDirPath(WatchKey key) {
        return (Path)this.mWatchKeyToDirPathMap.get(key);
    }

    private Set<DirectoryWatchService.OnFileChangeListener> getListeners(Path dir) {
        return (Set)this.mDirPathToListenersMap.get(dir);
    }

    private Set<PathMatcher> getPatterns(DirectoryWatchService.OnFileChangeListener listener) {
        return (Set)this.mListenerToFilePatternsMap.get(listener);
    }

    private Set<DirectoryWatchService.OnFileChangeListener> matchedListeners(Path dir, Path file) {
        return this.getListeners(dir).stream().filter(listener -> SimpleDirectoryWatchService.matchesAny(file, this.getPatterns((DirectoryWatchService.OnFileChangeListener)listener))).collect(Collectors.toSet());
    }

    private void notifyListeners(WatchKey key) {
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> eventKind = event.kind();
            if (eventKind.equals(StandardWatchEventKinds.OVERFLOW)) {
                return;
            }
            WatchEvent pathEvent = SimpleDirectoryWatchService.cast(event);
            Path file = (Path)pathEvent.context();
            if (eventKind.equals(StandardWatchEventKinds.ENTRY_CREATE)) {
                this.matchedListeners(this.getDirPath(key), file).forEach(listener -> listener.onFileCreate(file));
                continue;
            }
            if (eventKind.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
                this.matchedListeners(this.getDirPath(key), file).forEach(listener -> listener.onFileModify(file));
                continue;
            }
            if (!eventKind.equals(StandardWatchEventKinds.ENTRY_DELETE)) continue;
            this.matchedListeners(this.getDirPath(key), file).forEach(listener -> listener.onFileDelete(file));
        }
    }

    @Override
    public void register(DirectoryWatchService.OnFileChangeListener listener, Path dirPath, String ... globPatterns) throws IOException {
        String dir = dirPath.toString();
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            throw new IllegalArgumentException(dir + " is not a directory.");
        }
        if (!this.mDirPathToListenersMap.containsKey(dirPath)) {
            WatchKey key = dirPath.register(this.mWatchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            this.mWatchKeyToDirPathMap.put(key, dirPath);
            this.mDirPathToListenersMap.put(dirPath, SimpleDirectoryWatchService.newConcurrentSet());
        }
        this.getListeners(dirPath).add(listener);
        Set patterns = SimpleDirectoryWatchService.newConcurrentSet();
        for (String globPattern : globPatterns) {
            patterns.add(SimpleDirectoryWatchService.matcherForGlobExpression(globPattern));
        }
        if (patterns.isEmpty()) {
            patterns.add(SimpleDirectoryWatchService.matcherForGlobExpression("*"));
        }
        this.mListenerToFilePatternsMap.put(listener, patterns);
        Logger.getLogger(SimpleDirectoryWatchService.class.getName()).log(Level.INFO, "Watching files matching {0} under {1} for changes.", new Object[]{Arrays.toString(globPatterns), dir});
    }

    public void start() {
        if (this.mIsRunning.compareAndSet(false, true)) {
            Thread runnerThread = new Thread((Runnable)this, DirectoryWatchService.class.getSimpleName());
            runnerThread.setDaemon(true);
            runnerThread.start();
        }
    }

    public void stop() {
        this.mIsRunning.set(false);
    }

    @Override
    public void run() {
        Logger.getLogger(SimpleDirectoryWatchService.class.getName()).log(Level.INFO, "Starting file watcher service.");
        while (this.mIsRunning.get()) {
            WatchKey key;
            try {
                key = this.mWatchService.take();
            }
            catch (InterruptedException e) {
                Logger.getLogger(SimpleDirectoryWatchService.class.getName()).log(Level.INFO, "{0} service interrupted.", DirectoryWatchService.class.getSimpleName());
                break;
            }
            if (null == this.getDirPath(key)) {
                Logger.getLogger(SimpleDirectoryWatchService.class.getName()).log(Level.SEVERE, "Watch key not recognized.");
                continue;
            }
            this.notifyListeners(key);
            boolean valid = key.reset();
            if (valid) continue;
            this.mWatchKeyToDirPathMap.remove(key);
            if (!this.mWatchKeyToDirPathMap.isEmpty()) continue;
            break;
        }
        this.mIsRunning.set(false);
        Logger.getLogger(SimpleDirectoryWatchService.class.getName()).log(Level.INFO, "Stopping file watcher service.");
    }

    private static class SingletonHolder {
        private static final SimpleDirectoryWatchService INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new SimpleDirectoryWatchService();
            }
            catch (IOException | UnsupportedOperationException e) {
                throw new ExceptionInInitializerError("Unable to start " + DirectoryWatchService.class.getSimpleName() + " instance.");
            }
        }
    }
}

