/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Window;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.Shell;

public class AdvancedParametrisationDialog
extends Dialog<String> {
    private final GridPane grid;
    private final Label label;
    private final TextArea textArea;
    private final String defaultValue;

    static Label createContentLabel(String text) {
        Label label = new Label(text);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.getStyleClass().add((Object)"content");
        label.setWrapText(true);
        label.setPrefWidth(360.0);
        return label;
    }

    public AdvancedParametrisationDialog(Window owner, String params) {
        this(owner, params, ButtonType.OK);
    }

    public AdvancedParametrisationDialog(Window owner, String params, ButtonType okButtonType) {
        DialogPane dialogPane = this.getDialogPane();
        this.textArea = new TextArea(params);
        this.textArea.setMaxWidth(Double.MAX_VALUE);
        this.textArea.setWrapText(true);
        GridPane.setHgrow((Node)this.textArea, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.textArea, (Boolean)true);
        GridPane.setFillHeight((Node)this.textArea, (Boolean)true);
        this.label = AdvancedParametrisationDialog.createContentLabel(dialogPane.getContentText());
        this.label.setPrefWidth(-1.0);
        this.label.setAlignment(Pos.TOP_LEFT);
        this.label.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        this.defaultValue = params;
        this.grid = new GridPane();
        this.grid.setHgap(10.0);
        this.grid.setMaxWidth(Double.MAX_VALUE);
        this.grid.setAlignment(Pos.CENTER_LEFT);
        dialogPane.contentTextProperty().addListener(o -> this.updateGrid());
        this.setTitle(ControlResources.getString((String)"Dialog.confirm.title"));
        dialogPane.setHeaderText(ControlResources.getString((String)"Dialog.confirm.header"));
        dialogPane.getStyleClass().add((Object)"text-input-dialog");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.updateGrid();
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? this.textArea.getText() : null;
        });
        boolean isMess = Configuration.Manager.isMess();
        ResourceBundle language = Language.Manager.getBundle();
        this.setResizable(true);
        this.setTitle(language.getString("advancedParametrisation"));
        this.setHeaderText(isMess ? language.getString("advancedParametrisation.text").replaceFirst("MAME", "MESS") : language.getString("advancedParametrisation.text"));
        if (Shell.isWindows()) {
            this.setContentText((isMess ? "mess" : "mame") + ".exe");
        } else {
            this.setContentText(isMess ? "mess" : "mame");
        }
        this.setGraphic((Node)new ImageView(((Object)((Object)this)).getClass().getResource("/net/babelsoft/negatron/resource/icon/" + (isMess ? "MESS" : "MAME") + ".png").toExternalForm()));
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{okButtonType, ButtonType.CANCEL});
        Button noDrcButton = new Button(language.getString("noDynaRec"));
        noDrcButton.setTooltip(new Tooltip(language.getString("noDynaRec.tooltip")));
        noDrcButton.setOnAction(evt -> this.getEditor().appendText(" -nodrc"));
        Button biosButton = new Button(language.getString("bios"));
        biosButton.setTooltip(new Tooltip(language.getString("bios.tooltip")));
        biosButton.setOnAction(evt -> this.getEditor().appendText(String.format(" -bios <%s>", language.getString("bios.parameter"))));
        Button ramSizeButton = new Button(language.getString("ramSize"));
        ramSizeButton.setTooltip(new Tooltip(language.getString("ramSize.tooltip")));
        ramSizeButton.setOnAction(evt -> this.getEditor().appendText(String.format(" -ramsize <%s>", language.getString("ramSize.parameter"))));
        HBox box = new HBox();
        box.setSpacing(5.0);
        box.getChildren().add((Object)noDrcButton);
        box.getChildren().add((Object)biosButton);
        box.getChildren().add((Object)ramSizeButton);
        GridPane content = (GridPane)this.getDialogPane().getContent();
        content.setVgap(5.0);
        content.add((Node)box, 1, 1);
        this.initOwner(owner);
    }

    public final TextArea getEditor() {
        return this.textArea;
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }

    private void updateGrid() {
        this.grid.getChildren().clear();
        this.grid.add((Node)this.label, 0, 0);
        this.grid.add((Node)this.textArea, 1, 0);
        this.getDialogPane().setContent((Node)this.grid);
        Platform.runLater(() -> this.textArea.requestFocus());
    }
}

