/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import net.babelsoft.negatron.controller.EmulatedItemTreePaneController;
import net.babelsoft.negatron.controller.FilterPaneController;
import net.babelsoft.negatron.model.Statistics;
import net.babelsoft.negatron.model.item.EmulatedItem;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.EmulatedItemTreeView;
import net.babelsoft.negatron.view.control.FilterPane;
import net.babelsoft.negatron.view.control.tree.SortableTreeItem;

public class EmulatedItemTreePane<T extends EmulatedItem<T>>
extends VBox {
    private EmulatedItemTreePaneController<T> controller;
    private EmulatedItemTreeView<T> tree;

    public EmulatedItemTreePane() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("fxml/EmulatedItemTreePane.fxml"), Language.Manager.getBundle());
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
            this.controller = (EmulatedItemTreePaneController)fxmlLoader.getController();
            this.tree = this.controller.getTreeView();
            this.idProperty().addListener((o, oV, newValue) -> this.controller.setId((String)newValue));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void reset() {
        this.controller.reset();
    }

    public void setFilterPane(FilterPane<T, ? extends FilterPaneController<T>> pane) {
        pane.setTreeView(this.tree);
        this.controller.setOnFilter(pane);
    }

    public void setOnMoreFilters(Consumer<Boolean> onMoreFilters) {
        this.controller.setOnMoreFilters(onMoreFilters);
    }

    public void setFilterButtonSelected(boolean selected) {
        this.controller.setFilterButtonSelected(selected);
    }

    public Property<String> filterProperty() {
        return this.controller.filterProperty();
    }

    public void closeFilterPane() {
        if (this.controller.isFilterButtonSelected()) {
            this.controller.fireFilterButton();
        }
    }

    void unbindFilter() {
        this.controller.unbindFilter();
    }

    public void clearSelection() {
        this.tree.getSelectionModel().clearSelection();
    }

    public Statistics setItems(List<T> emulatedItems) {
        return this.controller.setItems(emulatedItems);
    }

    public void setOnAction(Delegate delegate) {
        this.tree.setOnAction(delegate);
    }

    public void setOnAllowAction(Delegate delegate) {
        this.tree.setOnAllowAction(delegate);
    }

    public void setOnForbidAction(Delegate delegate) {
        this.tree.setOnForbidAction(delegate);
    }

    public void setOnSpaceKeyPressed(Delegate delegate) {
        this.tree.setOnSpaceKeyPressed(delegate);
    }

    public void setOnEscapeNode(Node node) {
        this.tree.setOnEscapeNode(node);
    }

    public void setOnTreeWiseOperation(Consumer<Boolean> delegate) {
        this.tree.setOnTreeWiseOperation(delegate);
    }

    public T getCurrentItem() {
        TreeItem treeItem = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (treeItem != null) {
            return (T)((EmulatedItem)treeItem.getValue());
        }
        return null;
    }

    public void setCurrentItem(T item) {
        this.tree.select(item);
    }

    public ReadOnlyObjectProperty<TreeItem<T>> currentItemProperty() {
        return this.tree.getSelectionModel().selectedItemProperty();
    }

    public void setOnMoreViews(Consumer<Boolean> onMoreViews) {
        this.controller.setOnMoreViews(onMoreViews);
    }

    public void setMoreViews(boolean enable) {
        this.controller.setMoreViews(enable);
    }

    public boolean isMoreViews() {
        return true;
    }

    public void setViewButtonSelected(boolean selected) {
        this.controller.setViewButtonSelected(selected);
    }

    public void setConfigurationIcon(Image icon) {
        this.tree.setConfigurationIcon(icon);
    }

    public Image getConfigurationIcon() {
        return null;
    }

    public void setHeaders(Map<String, String> headers) {
        this.tree.setHeaders(headers);
    }

    public Map<String, String> getHeaders() {
        return null;
    }

    public void setOnTreeMouseClicked(EventHandler<? super MouseEvent> value) {
        this.tree.setOnMouseClicked(value);
    }

    public ObjectProperty<EventHandler<? super MouseEvent>> onTreeMouseClickedProperty() {
        return this.tree.onMouseClickedProperty();
    }

    public void requestTreeFocus() {
        this.tree.requestFocus();
    }

    public void setViewType(Map<SortableTreeItem<T>, List<String>> viewType) {
        this.controller.setViewType(viewType);
    }
}

