/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeSortMode;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import net.babelsoft.negatron.io.Audio;
import net.babelsoft.negatron.model.item.EmulatedItem;
import net.babelsoft.negatron.model.item.Item;
import net.babelsoft.negatron.model.item.MachineFolder;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.NegatronTreeView;
import net.babelsoft.negatron.view.control.tree.ConfigurableTreeTableCell;
import net.babelsoft.negatron.view.control.tree.DisclosureNode;
import net.babelsoft.negatron.view.control.tree.IconDescriptionTreeTableCell;
import net.babelsoft.negatron.view.control.tree.ImageEnumTreeTableCell;
import net.babelsoft.negatron.view.control.tree.LabelTreeTableCell;
import net.babelsoft.negatron.view.control.tree.NegatronTreeTableCell;
import net.babelsoft.negatron.view.control.tree.SortableTreeItem;

public class EmulatedItemTreeView<T extends EmulatedItem<T>>
extends NegatronTreeView<T> {
    private final Timeline timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), actionEvent -> {
        this.shortcut = "";
    }, new KeyValue[0])});
    private Map<Character, Collection<TreeItem<T>>> shortcutMap;
    private Map<String, SortableTreeItem<T>> map;
    private String shortcut = "";
    private T selectedItem;
    private Delegate onAllowAction;
    private Delegate onForbidAction;
    private Delegate onSpaceKeyPressed;
    private Node onEscapeNode;
    private Image configurationIcon;

    public void initialize(URL location, ResourceBundle resources) {
        this.setRowFactory(tree -> {
            TreeTableRow cell = new TreeTableRow();
            DisclosureNode disclosureNode = new DisclosureNode(cell);
            cell.setDisclosureNode((Node)disclosureNode);
            return cell;
        });
        this.getColumns().stream().forEach(col -> {
            switch (col.getId()) {
                case "iconDescription": {
                    TreeTableColumn col1 = col;
                    this.setColumnFactory(col1, IconDescriptionTreeTableCell::new, cell -> ((EmulatedItem)cell.getValue().getValue()).iconDescriptionProperty());
                    col1.setComparator(Comparator.comparing(iconDescription -> iconDescription.getDescription(), (desc1, desc2) -> desc1.compareToIgnoreCase((String)desc2)));
                    break;
                }
                case "configurable": {
                    TreeTableColumn col2 = col;
                    this.setColumnFactory(col2, ConfigurableTreeTableCell::new, cell -> new ReadOnlyBooleanWrapper(((EmulatedItem)cell.getValue().getValue()).isConfigurable()));
                    break;
                }
                case "support": {
                    TreeTableColumn col3 = col;
                    this.setColumnFactory(col3, ImageEnumTreeTableCell::new, cell -> new ReadOnlyObjectWrapper((Object)((EmulatedItem)cell.getValue().getValue()).getSupport()));
                    break;
                }
                case "status": {
                    TreeTableColumn col4 = col;
                    this.setColumnFactory(col4, ImageEnumTreeTableCell::new, cell -> ((EmulatedItem)cell.getValue().getValue()).statusProperty());
                    break;
                }
                default: {
                    Callback valueFactory;
                    TreeTableColumn col5 = col;
                    switch (col.getId()) {
                        case "name": {
                            valueFactory = cell -> new ReadOnlyStringWrapper(((EmulatedItem)cell.getValue().getValue()).getName());
                            break;
                        }
                        case "group": {
                            valueFactory = cell -> new ReadOnlyStringWrapper(((EmulatedItem)cell.getValue().getValue()).getGroup());
                            break;
                        }
                        case "year": {
                            valueFactory = cell -> new ReadOnlyStringWrapper(((EmulatedItem)cell.getValue().getValue()).getYear());
                            break;
                        }
                        default: {
                            valueFactory = cell -> new ReadOnlyStringWrapper(((EmulatedItem)cell.getValue().getValue()).getCompany());
                        }
                    }
                    this.setColumnFactory(col5, LabelTreeTableCell::new, valueFactory);
                }
            }
        });
        this.setSortPolicy(tree -> {
            TreeSortMode sortMode = this.getSortMode();
            if (sortMode == null) {
                return false;
            }
            SortableTreeItem<T> rootItem = this.getSortableRoot();
            rootItem.setComparator(tree.getComparator());
            return true;
        });
        this.getSelectionModel().selectedItemProperty().addListener((o, oV, newValue) -> {
            if (newValue != null) {
                this.selectedItem = (EmulatedItem)newValue.getValue();
                if (((EmulatedItem)this.selectedItem).isNotCompatible() && this.onForbidAction != null) {
                    this.onForbidAction.fire();
                } else if (this.onAllowAction != null) {
                    this.onAllowAction.fire();
                }
            } else {
                this.selectedItem = null;
            }
        });
        this.setOnKeyTyped(event -> this.handleKeyTyped((KeyEvent)event));
    }

    private <S> void setColumnFactory(TreeTableColumn<T, S> col, Supplier<? extends NegatronTreeTableCell<T, S>> builder, Callback<TreeTableColumn.CellDataFeatures<T, S>, ObservableValue<S>> valueFactory) {
        col.setCellValueFactory(valueFactory);
        col.setCellFactory(column -> {
            NegatronTreeTableCell cell = (NegatronTreeTableCell)((Object)((Object)builder.get()));
            cell.setOnMouseClicked(evt -> this.handleMouseClicked((MouseEvent)evt));
            return cell;
        });
    }

    public void reset() {
        this.getSelectionModel().clearSelection();
        SortableTreeItem<T> root = this.getSortableRoot();
        root.getInternalChildren().clear();
        this.shortcutMap = null;
        this.map = null;
    }

    public SortableTreeItem<T> getSortableRoot() {
        SortableTreeItem root = (SortableTreeItem)this.getRoot();
        if (root == null) {
            root = new SortableTreeItem();
            root.setExpanded(true);
            this.setRoot(root);
        }
        return root;
    }

    public void setShortcutMap(Map<Character, Collection<TreeItem<T>>> shortcutMap) {
        this.shortcutMap = shortcutMap;
    }

    public void setMap(Map<String, SortableTreeItem<T>> map) {
        this.map = map;
    }

    public SortableTreeItem<T> getTreeItem(String name) {
        return this.map.get(name);
    }

    public Image getConfigurationIcon() {
        return this.configurationIcon;
    }

    void setConfigurationIcon(Image icon) {
        this.configurationIcon = icon;
    }

    public void setHeaders(Map<String, String> headers) {
        headers.entrySet().forEach(entry -> this.getColumns().filtered(column -> column.getId().equals(entry.getKey())).stream().forEach(column -> column.setText((String)entry.getValue())));
    }

    public void setOnAllowAction(Delegate delegate) {
        this.onAllowAction = delegate;
    }

    public void setOnForbidAction(Delegate delegate) {
        this.onForbidAction = delegate;
    }

    public void setOnSpaceKeyPressed(Delegate delegate) {
        this.onSpaceKeyPressed = delegate;
    }

    public void setOnEscapeNode(Node node) {
        this.onEscapeNode = node;
    }

    public void select(T item) {
        if (item != null) {
            this.getSelectionModel().clearSelection();
            SortableTreeItem<T> treeItem = this.map.get(((Item)item).getName());
            if (treeItem.getParent() != null && !treeItem.getParent().isExpanded()) {
                treeItem.getParent().setExpanded(true);
            }
            this.getSelectionModel().select(treeItem);
        } else {
            this.getSelectionModel().clearSelection();
        }
    }

    public void sort() {
        this.beginTreeWiseOperation();
        super.sort();
        this.endTreeWiseOperation();
    }

    @Override
    protected void performAllExpanded(List<TreeItem<T>> children, boolean value) {
        children.stream().filter(child -> child != null && !child.isLeaf()).forEach(child -> child.setExpanded(value));
    }

    public void beginResetOperation() {
        this.beginTreeWiseOperation();
    }

    public void endResetOperation() {
        if (this.selectedTreeItem != null) {
            String ref = ((EmulatedItem)this.selectedTreeItem.getValue()).getName();
            TreeTableView.TreeTableViewSelectionModel selection = this.getSelectionModel();
            int max = this.getExpandedItemCount();
            for (int i = 0; i < max; ++i) {
                TreeItem rowObj = selection.getModelItem(i);
                if (((EmulatedItem)rowObj.getValue()).getName().equals(ref)) {
                    this.selectedTreeItem = rowObj;
                    this.endTreeWiseOperation();
                    return;
                }
                if (rowObj.getChildren().isEmpty()) continue;
                for (TreeItem child : rowObj.getChildren()) {
                    if (!((EmulatedItem)child.getValue()).getName().equals(ref)) continue;
                    rowObj.setExpanded(true);
                    this.selectedTreeItem = child;
                    this.endTreeWiseOperation();
                    return;
                }
            }
        }
    }

    private void handleKeyTyped(KeyEvent event) {
        if (!event.getCharacter().matches("[a-z0-9]")) {
            return;
        }
        this.timer.stop();
        this.shortcut = this.shortcut + event.getCharacter().toLowerCase();
        char index = this.shortcut.charAt(0);
        Collection<TreeItem<T>> items = this.shortcutMap.get(Character.valueOf(index));
        if (items != null) {
            items.stream().filter(item -> item.getParent() != null && ((EmulatedItem)item.getValue()).getName().matches("^" + this.shortcut + ".*")).findFirst().ifPresent(item -> {
                TreeItem parent = item.getParent();
                if (parent != this.getRoot() && !parent.isExpanded()) {
                    parent.setExpanded(true);
                }
                int idx = this.getRow((TreeItem)item);
                this.scrollTo(idx);
                this.getSelectionModel().select(idx);
            });
        }
        this.timer.playFromStart();
    }

    @Override
    protected void handleAction() {
        if (this.selectedItem != null) {
            if (((EmulatedItem)this.selectedItem).isNotCompatible()) {
                if (this.selectedItem instanceof MachineFolder) {
                    TreeItem item;
                    item.setExpanded(!(item = (TreeItem)this.getSelectionModel().getSelectedItem()).isExpanded());
                } else {
                    Alert alert = new Alert(Alert.AlertType.ERROR, Language.Manager.getString("invalidSelection.error"), new ButtonType[0]);
                    alert.initOwner(this.getScene().getWindow());
                    alert.show();
                    Audio.play(Audio.Sound.ERROR);
                }
            } else {
                super.handleAction();
            }
        }
    }

    @Override
    public void handleKeyPressed(KeyEvent event) {
        super.handleKeyPressed(event);
        if (!event.isConsumed()) {
            if (event.getCode() == KeyCode.SPACE && this.onSpaceKeyPressed != null) {
                this.onSpaceKeyPressed.fire();
            } else if (event.getCode() == KeyCode.ESCAPE && this.onEscapeNode != null && this.onEscapeNode.getOnKeyPressed() != null) {
                this.onEscapeNode.getOnKeyPressed().handle((Event)event);
            }
        }
    }
}

