/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import java.io.IOException;
import java.util.function.Consumer;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.SplitPane;
import net.babelsoft.negatron.controller.EditController;
import net.babelsoft.negatron.controller.FavouriteTreePaneController;
import net.babelsoft.negatron.io.configuration.FavouriteTree;
import net.babelsoft.negatron.model.favourites.Favourite;
import net.babelsoft.negatron.model.favourites.SoftwareConfiguration;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.function.Delegate;

public class FavouriteTreePane
extends SplitPane {
    private FavouriteTreePaneController controller;

    public FavouriteTreePane() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("fxml/FavouriteTreePane.fxml"), Language.Manager.getBundle());
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
            this.controller = (FavouriteTreePaneController)fxmlLoader.getController();
            this.controller.setId(this.getId());
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setFavouriteTree(FavouriteTree favourites) {
        this.controller.setFavouriteTree(favourites);
    }

    public void setEditController(EditController editController) {
        this.controller.setEditController(editController);
    }

    public boolean isEditing() {
        return this.controller.isEditing();
    }

    public boolean isEditingMachine() {
        return this.controller.isEditingMachine();
    }

    public boolean isEditingSoftware() {
        return this.controller.isEditingSoftware();
    }

    public boolean isEditingConfiguration() {
        return this.controller.isEditingConfiguration();
    }

    public void setOnCommitted(Consumer<Favourite> onCommitted) {
        this.controller.setOnCommitted(onCommitted);
    }

    public boolean isCommitting() {
        return this.controller.isCommitting();
    }

    public void setOnAction(Delegate delegate) {
        this.controller.setOnAction(delegate);
    }

    public void insert(Machine currentMachine, SoftwareConfiguration currentSoftware) {
        this.controller.insert(currentMachine, currentSoftware);
    }

    public void cancelEdit() {
        this.controller.cancelEdit();
    }

    public void showSoftwareList() {
        this.controller.showSoftwareList();
    }

    public void hideSoftwareList() {
        this.controller.hideSoftwareList();
    }

    public void hideListBackground() {
        this.controller.hideListBackground();
    }

    public void requestTreeFocus() {
        this.controller.requestTreeFocus();
    }
}

