/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.cell.TreeItemPropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import javafx.util.Duration;
import net.babelsoft.negatron.model.favourites.Favourite;
import net.babelsoft.negatron.model.favourites.Folder;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.ReversedIterator;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.NegatronTreeView;
import net.babelsoft.negatron.view.control.PopOver;
import net.babelsoft.negatron.view.control.tree.CopyPastableTreeItem;
import net.babelsoft.negatron.view.control.tree.DisclosureNode;

public class FavouriteTreeView
extends NegatronTreeView<Favourite> {
    private static final DataFormat SERIALIZED_MIME_TYPE = new DataFormat(new String[]{"application/x-java-serialized-object"});
    private static final PseudoClass CSS_CUT = PseudoClass.getPseudoClass((String)"cut");
    private static final PseudoClass CSS_COPIED = PseudoClass.getPseudoClass((String)"copied");
    private static final PseudoClass CSS_INVALIDATED = PseudoClass.getPseudoClass((String)"invalidated");
    private static final PseudoClass CSS_MOVE_BEFORE = PseudoClass.getPseudoClass((String)"move-before");
    private static final PseudoClass CSS_MOVE_AFTER = PseudoClass.getPseudoClass((String)"move-after");
    private static final PseudoClass CSS_MOVE_INSIDE = PseudoClass.getPseudoClass((String)"move-inside");
    private final Timeline scrollTimeline = new Timeline();
    private double scrollDirection = 0.0;
    private List<CopyPastableTreeItem> cutCopyList;
    private Delegate onInsertFavourite;
    private Delegate onDragDone;
    private boolean isDragDropping;
    private PopOver popup;

    public void initialize(URL location, ResourceBundle resources) {
        this.setRowFactory(tree -> {
            TreeTableRow cell = new TreeTableRow();
            ChangeListener cutCopyStateListener = (o, oV, cutState) -> {
                cell.pseudoClassStateChanged(CSS_CUT, !this.isDragDropping && cutState == CopyPastableTreeItem.CutCopyState.Cut);
                cell.pseudoClassStateChanged(CSS_COPIED, !this.isDragDropping && cutState == CopyPastableTreeItem.CutCopyState.Copied);
            };
            ChangeListener invalidatedListener = (o, oV, invalidated) -> {
                Favourite favourite;
                cell.pseudoClassStateChanged(CSS_INVALIDATED, invalidated.booleanValue());
                if (!invalidated.booleanValue() && (favourite = (Favourite)cell.getItem()) != null && favourite.getMachine() != null && favourite.getMachine().getIconDescription() != null) {
                    favourite.setIcon(favourite.getMachine().getIconDescription().getIcon());
                }
            };
            cell.treeItemProperty().addListener((o, oldItem, newItem) -> {
                if (oldItem != null) {
                    ((CopyPastableTreeItem)((Object)((Object)oldItem))).cutCopyStateProperty().removeListener(cutCopyStateListener);
                    ReadOnlyBooleanProperty invalidated = ((Favourite)oldItem.getValue()).invalidatedProperty();
                    if (invalidated != null) {
                        invalidated.removeListener(invalidatedListener);
                    }
                }
                if (newItem != null) {
                    CopyPastableTreeItem item = (CopyPastableTreeItem)((Object)((Object)newItem));
                    item.cutCopyStateProperty().addListener(cutCopyStateListener);
                    cutCopyStateListener.changed(null, null, (Object)item.getCutCopyState());
                    ReadOnlyBooleanProperty invalidated = ((Favourite)item.getValue()).invalidatedProperty();
                    if (invalidated != null) {
                        invalidated.addListener(invalidatedListener);
                        invalidatedListener.changed(null, null, (Object)((Favourite)item.getValue()).isInvalidated());
                    }
                } else {
                    cutCopyStateListener.changed(null, null, (Object)CopyPastableTreeItem.CutCopyState.None);
                    invalidatedListener.changed(null, null, (Object)false);
                }
            });
            cell.setOnDragDetected(event -> {
                this.isDragDropping = true;
                this.cutCopy(CopyPastableTreeItem.CutCopyState.Cut);
                if (this.isCutCopying()) {
                    Dragboard db = cell.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                    db.setDragView((Image)cell.snapshot(null, null));
                    ClipboardContent cc = new ClipboardContent();
                    cc.put((Object)SERIALIZED_MIME_TYPE, (Object)cell.getIndex());
                    db.setContent((Map)cc);
                    event.consume();
                } else {
                    this.isDragDropping = false;
                }
            });
            cell.setOnDragOver(event -> {
                if (this.acceptable((TreeTableRow<Favourite>)cell)) {
                    event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                    Position position = FavouriteTreeView.getDragDroppedPosition((TreeTableRow<Favourite>)cell, event);
                    switch (position) {
                        case BEFORE: {
                            cell.pseudoClassStateChanged(CSS_MOVE_BEFORE, true);
                            cell.pseudoClassStateChanged(CSS_MOVE_AFTER, false);
                            cell.pseudoClassStateChanged(CSS_MOVE_INSIDE, false);
                            break;
                        }
                        case AFTER: {
                            cell.pseudoClassStateChanged(CSS_MOVE_BEFORE, false);
                            cell.pseudoClassStateChanged(CSS_MOVE_AFTER, true);
                            cell.pseudoClassStateChanged(CSS_MOVE_INSIDE, false);
                            break;
                        }
                        default: {
                            cell.pseudoClassStateChanged(CSS_MOVE_BEFORE, false);
                            cell.pseudoClassStateChanged(CSS_MOVE_AFTER, false);
                            cell.pseudoClassStateChanged(CSS_MOVE_INSIDE, true);
                        }
                    }
                    event.consume();
                }
            });
            cell.setOnDragExited(event -> {
                cell.pseudoClassStateChanged(CSS_MOVE_BEFORE, false);
                cell.pseudoClassStateChanged(CSS_MOVE_AFTER, false);
                cell.pseudoClassStateChanged(CSS_MOVE_INSIDE, false);
                event.consume();
            });
            cell.setOnDragDropped(event -> {
                ArrayList<CopyPastableTreeItem> processList;
                CopyPastableTreeItem selected = (CopyPastableTreeItem)cell.getTreeItem();
                if (this.acceptable(selected, processList = new ArrayList<CopyPastableTreeItem>(this.cutCopyList.size()))) {
                    this.paste(selected, processList, FavouriteTreeView.getDragDroppedPosition((TreeTableRow<Favourite>)cell, event));
                    event.consume();
                }
            });
            cell.setOnDragDone(event -> {
                this.resetCutCopy();
                this.isDragDropping = false;
                this.onDragDone.fire();
            });
            DisclosureNode disclosureNode = new DisclosureNode(cell);
            cell.setDisclosureNode((Node)disclosureNode);
            return cell;
        });
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setupScrolling();
    }

    private boolean acceptable(TreeTableRow<Favourite> cell) {
        return this.acceptable((CopyPastableTreeItem)cell.getTreeItem(), new ArrayList<CopyPastableTreeItem>(this.cutCopyList.size()));
    }

    private boolean acceptable(CopyPastableTreeItem selected, List<CopyPastableTreeItem> processList) {
        if (this.cutCopyList == null) {
            return false;
        }
        if (selected == null) {
            return false;
        }
        CopyPastableTreeItem.CutCopyState cutCopyState = this.cutCopyList.get(0).getCutCopyState();
        if (cutCopyState == CopyPastableTreeItem.CutCopyState.Cut && this.cutCopyList.stream().filter(item -> {
            if (item == selected) {
                return false;
            }
            for (TreeItem parent = selected.getParent(); parent != null; parent = parent.getParent()) {
                if (parent != item) continue;
                return true;
            }
            return false;
        }).findAny().isPresent()) {
            return false;
        }
        processList.addAll(this.cutCopyList);
        if (cutCopyState == CopyPastableTreeItem.CutCopyState.Cut) {
            processList.removeIf(item -> item == selected);
        }
        this.cutCopyList.stream().filter(item -> item.getValue() instanceof Folder).forEach(folder -> processList.removeIf(item -> {
            for (TreeItem parent = item.getParent(); parent != null; parent = parent.getParent()) {
                if (parent != folder) continue;
                return true;
            }
            return false;
        }));
        return processList.size() > 0;
    }

    private CopyPastableTreeItem getTarget(TreeTableRow<Favourite> row) {
        CopyPastableTreeItem target = (CopyPastableTreeItem)this.getRoot();
        if (!row.isEmpty()) {
            target = (CopyPastableTreeItem)row.getTreeItem();
        }
        return target;
    }

    private boolean isParent(TreeItem parent, TreeItem child) {
        boolean result = false;
        while (!result && child != null) {
            result = child.getParent() == parent;
            child = child.getParent();
        }
        return result;
    }

    private void setupScrolling() {
        this.scrollTimeline.setCycleCount(-1);
        this.scrollTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)20.0), e -> this.dragScroll(), new KeyValue[0]));
        this.setOnDragExited(event -> {
            this.scrollDirection = event.getY() > 0.0 ? 1.0 / (double)this.getExpandedItemCount() : -1.0 / (double)this.getExpandedItemCount();
            this.scrollTimeline.play();
        });
        this.setOnDragEntered(event -> this.scrollTimeline.stop());
        this.setOnDragDone(event -> this.scrollTimeline.stop());
    }

    private void dragScroll() {
        ScrollBar sb = null;
        for (Node n : this.lookupAll(".scroll-bar")) {
            ScrollBar bar;
            if (!(n instanceof ScrollBar) || !(bar = (ScrollBar)n).getOrientation().equals((Object)Orientation.VERTICAL)) continue;
            sb = bar;
        }
        if (sb != null) {
            double newValue = sb.getValue() + this.scrollDirection;
            newValue = Math.min(newValue, 1.0);
            newValue = Math.max(newValue, 0.0);
            sb.setValue(newValue);
        }
    }

    private static Position getDragDroppedPosition(TreeTableRow<Favourite> cell, DragEvent event) {
        double position = event.getY();
        double limit = cell.getHeight();
        if (cell.getItem() instanceof Folder) {
            if (position <= (limit /= 3.0)) {
                return Position.BEFORE;
            }
            if (position <= limit * 2.0) {
                return Position.INSIDE;
            }
            return Position.AFTER;
        }
        if (position <= (limit /= 2.0)) {
            return Position.BEFORE;
        }
        return Position.AFTER;
    }

    public void insert(CopyPastableTreeItem reference, TreeItem<Favourite> favourite, Position position) {
        switch (position) {
            case BEFORE: {
                CopyPastableTreeItem parent = (CopyPastableTreeItem)reference.getParent();
                ObservableList list = parent.getInternalChildren();
                list.add(list.indexOf((Object)reference), favourite);
                break;
            }
            case INSIDE: {
                reference.getInternalChildren().add(favourite);
                break;
            }
            default: {
                return;
            }
        }
        this.onInsertFavourite.fire();
    }

    public boolean isCutCopying() {
        return this.cutCopyList != null;
    }

    public void resetCutCopy() {
        if (this.cutCopyList != null) {
            this.cutCopyList.stream().map(item -> item).forEach(item -> item.setCutCopyState(CopyPastableTreeItem.CutCopyState.None));
            this.cutCopyList = null;
        }
    }

    public void cutCopy(CopyPastableTreeItem.CutCopyState state) {
        this.resetCutCopy();
        ObservableList list = this.getSelectionModel().getSelectedItems();
        if (list != null && list.size() > 0) {
            this.cutCopyList = new ArrayList<CopyPastableTreeItem>(list.size());
            TreeItem root = this.getRoot();
            list.stream().filter(item -> item != root).map(item -> (CopyPastableTreeItem)((Object)item)).forEach(item -> {
                this.cutCopyList.add((CopyPastableTreeItem)((Object)item));
                item.setCutCopyState(state);
            });
            if (this.cutCopyList.isEmpty()) {
                this.cutCopyList = null;
            }
        }
    }

    public void paste() {
        ArrayList<CopyPastableTreeItem> processList;
        CopyPastableTreeItem selected = (CopyPastableTreeItem)((Object)this.getSelectionModel().getSelectedItem());
        if (this.acceptable(selected, processList = new ArrayList<CopyPastableTreeItem>())) {
            if (selected.getValue() instanceof Folder) {
                this.paste(selected, processList, Position.INSIDE);
            } else {
                this.paste(selected, processList, Position.BEFORE);
            }
        }
        this.resetCutCopy();
    }

    private void paste(CopyPastableTreeItem selected, List<CopyPastableTreeItem> processList, Position position) {
        CopyPastableTreeItem.CutCopyState cutCopyState = this.cutCopyList.get(0).getCutCopyState();
        this.getSelectionModel().clearSelection();
        switch (position) {
            case BEFORE: {
                CopyPastableTreeItem parent = (CopyPastableTreeItem)selected.getParent();
                ObservableList list = parent.getInternalChildren();
                processList.forEach(favourite -> {
                    if (cutCopyState == CopyPastableTreeItem.CutCopyState.Cut) {
                        ((CopyPastableTreeItem)favourite.getParent()).getInternalChildren().remove((Object)favourite);
                    } else {
                        favourite = favourite.copy();
                    }
                    list.add(list.indexOf((Object)selected), (Object)favourite);
                });
                break;
            }
            case AFTER: {
                CopyPastableTreeItem parent = (CopyPastableTreeItem)selected.getParent();
                ObservableList list = parent.getInternalChildren();
                ReversedIterator.stream(processList).forEachOrdered(favourite -> {
                    if (cutCopyState == CopyPastableTreeItem.CutCopyState.Cut) {
                        ((CopyPastableTreeItem)favourite.getParent()).getInternalChildren().remove((Object)favourite);
                    } else {
                        favourite = favourite.copy();
                    }
                    list.add(list.indexOf((Object)selected) + 1, (Object)favourite);
                });
                break;
            }
            case INSIDE: {
                if (!selected.isExpanded()) {
                    selected.setExpanded(true);
                }
                processList.forEach(favourite -> {
                    if (cutCopyState == CopyPastableTreeItem.CutCopyState.Cut) {
                        ((CopyPastableTreeItem)favourite.getParent()).getInternalChildren().remove((Object)favourite);
                    } else {
                        favourite = favourite.copy();
                    }
                    selected.getInternalChildren().add((Object)favourite);
                });
                break;
            }
            default: {
                return;
            }
        }
        if (processList.size() == 1) {
            this.getSelectionModel().select((Object)processList.get(0));
        }
        this.onInsertFavourite.fire();
        this.refresh();
    }

    public <S> void setColumnFactory(TreeTableColumn<Favourite, S> col, Supplier<? extends TreeTableCell<Favourite, S>> builder) {
        col.setCellValueFactory((Callback)new TreeItemPropertyValueFactory(col.getId()));
        col.setCellFactory(column -> {
            TreeTableCell cell = (TreeTableCell)builder.get();
            cell.setOnMouseClicked(evt -> this.handleMouseClicked((MouseEvent)evt));
            EventHandler eventFilter = e -> {
                if (e.isAltDown()) {
                    this.handleMouseClicked((MouseEvent)e);
                }
            };
            cell.addEventFilter(MouseEvent.MOUSE_PRESSED, eventFilter);
            cell.addEventFilter(MouseEvent.MOUSE_RELEASED, eventFilter);
            return cell;
        });
    }

    public void setOnInsertFavourite(Delegate delegate) {
        this.onInsertFavourite = delegate;
    }

    public void setOnDragDone(Delegate delegate) {
        this.onDragDone = delegate;
    }

    public void cancelEdit() {
        this.edit(-1, null);
    }

    @Override
    protected void performAllExpanded(List<TreeItem<Favourite>> children, boolean value) {
        children.stream().filter(child -> child != null && !child.isLeaf()).forEach(child -> {
            this.performAllExpanded((List<TreeItem<Favourite>>)child.getChildren(), value);
            child.setExpanded(value);
        });
    }

    @Override
    protected void handleMouseClicked(MouseEvent event) {
        TreeTableCell cell = (TreeTableCell)event.getSource();
        if (!event.isAltDown()) {
            if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 1 && !cell.isEditing()) {
                this.cancelEdit();
            } else if (event.getButton() == MouseButton.MIDDLE) {
                this.edit(cell.getIndex(), cell.getTableColumn());
            }
        } else {
            if (event.getClickCount() == 1) {
                this.getSelectionModel().clearAndSelect(cell.getIndex(), (TableColumnBase)cell.getTableColumn());
            } else if (cell.getTreeTableRow().getItem() == null || !((Favourite)cell.getTreeTableRow().getItem()).mustMigrate()) {
                super.handleMouseClicked(event);
            } else {
                this.showFavouriteMigrationPopup();
            }
            event.consume();
        }
    }

    @Override
    public void handleKeyPressed(KeyEvent event) {
        Favourite fav = (Favourite)((TreeItem)this.getSelectionModel().getSelectedItem()).getValue();
        if (fav == null || !fav.mustMigrate()) {
            super.handleKeyPressed(event);
        } else if ((event.getCode() == KeyCode.ENTER || event.getCode() == KeyCode.ALT) && fav.mustMigrate()) {
            this.showFavouriteMigrationPopup();
            event.consume();
        }
    }

    private void showFavouriteMigrationPopup() {
        if (this.popup == null) {
            this.popup = new PopOver();
            this.popup.setAnimated(true);
            this.popup.setTitle(Language.Manager.getString("favouriteMigration.title"));
            Label label = new Label(Language.Manager.getString("favouriteMigration.text"));
            label.setPadding(new Insets(8.0));
            label.getStyleClass().add((Object)"text");
            this.popup.setContentNode((Node)label);
        }
        int rowIndex = this.getSelectionModel().getSelectedIndex();
        Set treeTableRowCell = this.lookupAll(".tree-table-row-cell");
        block0: for (Node tableRow : treeTableRowCell) {
            TreeTableRow row = (TreeTableRow)tableRow;
            if (row.getIndex() != rowIndex) continue;
            Set cells = row.lookupAll(".tree-table-cell");
            for (Node node : cells) {
                TreeTableCell cell = (TreeTableCell)node;
                if (this.getColumns().indexOf((Object)cell.getTableColumn()) != 1) continue;
                this.popup.show((Node)cell);
                break block0;
            }
        }
    }

    public static enum Position {
        NONE,
        BEFORE,
        AFTER,
        INSIDE;

    }
}

