/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import java.io.IOException;
import java.util.function.Consumer;
import javafx.fxml.FXMLLoader;
import net.babelsoft.negatron.controller.FilterPaneController;
import net.babelsoft.negatron.model.item.EmulatedItem;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.view.control.EmulatedItemTreePane;
import net.babelsoft.negatron.view.control.EmulatedItemTreeView;
import net.babelsoft.negatron.view.control.TitledWindowPane;

public abstract class FilterPane<T extends EmulatedItem<T>, C extends FilterPaneController<T>>
extends TitledWindowPane {
    protected final C controller;

    protected FilterPane(String fxmlPath) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(fxmlPath), Language.Manager.getBundle());
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
            this.controller = (FilterPaneController)fxmlLoader.getController();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setTreeView(EmulatedItemTreeView<T> treeView) {
        ((FilterPaneController)this.controller).setTreeView(treeView);
    }

    public void setOnFilter(Consumer<Boolean> onFilter) {
        ((FilterPaneController)this.controller).setOnFilter(onFilter);
    }

    public void disableStatusCriteria(boolean disable) {
        ((FilterPaneController)this.controller).disableStatusCriteria(disable);
    }

    public void bind(EmulatedItemTreePane<T> treePane) {
        treePane.unbindFilter();
        ((FilterPaneController)this.controller).bind(treePane.filterProperty());
    }
}

