/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.babelsoft.negatron.model.HddGeometry;
import net.babelsoft.negatron.model.SizeUnit;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.SizeField;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class HddCreationDialog
extends Dialog<HddGeometry> {
    private static final ButtonType BTN_TYPE_CREATE = new ButtonType(Language.Manager.getString("create"), ButtonBar.ButtonData.OK_DONE);
    private ComboBox<HddGeometry> hddModels;
    private TextField path;
    private SizeField cylinder;
    private SizeField head;
    private SizeField sector;
    private ComboBox<Long> sectorSize;
    private Button createButton;
    private boolean modifyingComboBox;
    private boolean modifyingSpinners;

    public HddCreationDialog(Window owner) {
        this.initOwner(owner);
        ResourceBundle language = Language.Manager.getBundle();
        this.setTitle(language.getString("hddCreation"));
        this.setGraphic((Node)new ImageView(new Image(HddCreationDialog.class.getResourceAsStream("/net/babelsoft/negatron/resource/icon/device/drive-harddisk.png"))));
        this.setHeaderText(language.getString("hddCreation.text"));
        this.hddModels = new ComboBox();
        this.path = new TextField();
        Button browseButton = new Button(language.getString("browse..."));
        browseButton.onActionProperty().set(event -> {
            FileChooser fc = new FileChooser();
            fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(language.getString("chdFiles"), new String[]{"*.chd"}), new FileChooser.ExtensionFilter(language.getString("allFiles"), new String[]{"*.*"})});
            File f = fc.showSaveDialog(this.getOwner());
            if (f != null) {
                this.path.setText(f.getAbsolutePath());
            }
        });
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setAlignment(Pos.CENTER);
        grid.add((Node)new Label(language.getString("hddModel")), 0, 0);
        grid.add(this.hddModels, 1, 0);
        grid.add((Node)new Label(language.getString("outputPath")), 0, 1);
        grid.add((Node)this.path, 1, 1);
        grid.add((Node)browseButton, 2, 1);
        this.getDialogPane().setContent((Node)grid);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{BTN_TYPE_CREATE, ButtonType.CANCEL});
        this.createButton = (Button)this.getDialogPane().lookupButton(BTN_TYPE_CREATE);
        this.createButton.setDisable(true);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(false);
        try {
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            xmlReader.setContentHandler(new HddModelDataHandler());
            xmlReader.parse(new InputSource(HddCreationDialog.class.getResourceAsStream("/net/babelsoft/negatron/resource/data/HDDModels.xml")));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(HddCreationDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.cylinder = new SizeField();
        this.head = new SizeField();
        this.sector = new SizeField();
        this.sectorSize = new ComboBox(FXCollections.observableArrayList((Object[])new Long[]{128L, 256L, 512L, 520L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L}));
        TextField totalSize = new TextField(SizeUnit.factorise(0L));
        totalSize.setDisable(true);
        HBox hbox1 = new HBox(new Node[]{new Label(language.getString("cylinder")), this.cylinder, new Label(language.getString("head")), this.head, new Label(language.getString("sector")), this.sector});
        hbox1.setAlignment(Pos.CENTER);
        hbox1.setSpacing(5.0);
        HBox hbox2 = new HBox(new Node[]{new Label(language.getString("sectorSize")), this.sectorSize, new Label(language.getString("totalSize")), totalSize});
        hbox2.setAlignment(Pos.CENTER);
        hbox2.setSpacing(5.0);
        VBox vbox = new VBox(5.0, new Node[]{hbox1, hbox2});
        this.getDialogPane().setExpandableContent((Node)vbox);
        this.modifyingComboBox = false;
        this.modifyingSpinners = false;
        this.hddModels.getSelectionModel().selectedItemProperty().addListener((o, oV, newValue) -> {
            if (this.modifyingSpinners) {
                return;
            }
            this.modifyingComboBox = true;
            this.cylinder.setText(Long.toString(newValue.getCylinder()));
            this.head.setText(Long.toString(newValue.getHead()));
            this.sector.setText(Long.toString(newValue.getSector()));
            this.sectorSize.getSelectionModel().select((Object)newValue.getSectorSize());
            totalSize.setText(newValue.getTotalSize());
            this.modifyingComboBox = false;
        });
        this.path.textProperty().addListener((o, oV, nV) -> this.validateCreateButtonState());
        Delegate resetComboBox = () -> {
            this.validateCreateButtonState();
            if (this.modifyingComboBox) {
                return;
            }
            this.modifyingSpinners = true;
            this.hddModels.getSelectionModel().clearSelection();
            totalSize.setText(new HddGeometry("", this.cylinder.getText(), this.head.getText(), this.sector.getText(), ((Long)this.sectorSize.getSelectionModel().getSelectedItem()).toString()).getTotalSize());
            this.modifyingSpinners = false;
        };
        this.cylinder.textProperty().addListener((o, oV, nV) -> resetComboBox.fire());
        this.head.textProperty().addListener((o, oV, nV) -> resetComboBox.fire());
        this.sector.textProperty().addListener((o, oV, nV) -> resetComboBox.fire());
        this.sectorSize.getSelectionModel().selectedIndexProperty().addListener((o, oV, nV) -> resetComboBox.fire());
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? new HddGeometry(this.path.getText(), this.cylinder.getText(), this.head.getText(), this.sector.getText(), ((Long)this.sectorSize.getSelectionModel().getSelectedItem()).toString()) : null;
        });
    }

    private void validateCreateButtonState() {
        if (this.path.getText().isEmpty() || this.cylinder.getText().isEmpty() || this.head.getText().isEmpty() || this.sector.getText().isEmpty() || this.sectorSize.getSelectionModel().isEmpty()) {
            this.createButton.setDisable(true);
        } else {
            this.createButton.setDisable(false);
        }
    }

    private class HddModelDataHandler
    extends DefaultHandler {
        private String manufacturer;

        private HddModelDataHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            switch (qName) {
                case "manufacturer": {
                    this.manufacturer = atts.getValue("name");
                    break;
                }
                case "model": {
                    HddGeometry model = new HddGeometry(this.manufacturer, atts.getValue("name"), atts.getValue("cylinder"), atts.getValue("head"), atts.getValue("sector"), atts.getValue("sectorSize"));
                    HddCreationDialog.this.hddModels.getItems().add((Object)model);
                }
            }
        }
    }
}

