/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.util.function.Delegate;

public class ImageViewPane
extends Region {
    private final ObjectProperty<ImageView> imageViewProperty = new SimpleObjectProperty();
    private String dragCopyPath;
    private Delegate onDropCompleted;
    private ObjectProperty<Tooltip> tooltip;

    public ImageViewPane() {
        this(new ImageView());
    }

    public ImageViewPane(Image image) {
        this((ImageView)null);
        this.setImage(image, true);
    }

    public ImageViewPane(ImageView imageView) {
        this.imageViewProperty.addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                this.getChildren().remove(oldValue);
            }
            if (newValue != null) {
                this.getChildren().add(newValue);
            }
        });
        this.imageViewProperty.set((Object)imageView);
        DropShadow ds = new DropShadow(10.0, Color.RED);
        Function<Dragboard, Boolean> isAcceptable = dragBoard -> Strings.isValid(this.dragCopyPath) && dragBoard.hasUrl() && dragBoard.getUrl().matches("[\\s\\S]+\\.(png|jpg)");
        this.setOnDragOver(event -> {
            if (((Boolean)isAcceptable.apply(event.getDragboard())).booleanValue()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
            event.consume();
        });
        this.setOnDragEntered(event -> {
            if (((Boolean)isAcceptable.apply(event.getDragboard())).booleanValue()) {
                this.setEffect((Effect)ds);
            }
            event.consume();
        });
        this.setOnDragExited(event -> {
            if (((Boolean)isAcceptable.apply(event.getDragboard())).booleanValue()) {
                this.setEffect(null);
            }
            event.consume();
        });
        this.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (((Boolean)isAcceptable.apply(db)).booleanValue()) {
                try {
                    String url = db.getUrl();
                    int index = url.lastIndexOf(".");
                    String extension = url.substring(index);
                    Path targetPath = Paths.get(this.dragCopyPath + extension, new String[0]);
                    File targetDir = targetPath.getParent().toFile();
                    if (!targetDir.exists()) {
                        targetDir.mkdirs();
                    }
                    Path tmpPath = extension.endsWith("jpg") ? Paths.get(this.dragCopyPath + ".png", new String[0]) : Paths.get(this.dragCopyPath + ".jpg", new String[0]);
                    Files.deleteIfExists(tmpPath);
                    Files.copy(Paths.get(new URL(url.replace(" ", "%20")).toURI()), targetPath, StandardCopyOption.REPLACE_EXISTING);
                    if (this.onDropCompleted != null) {
                        this.onDropCompleted.fire();
                    }
                    success = true;
                }
                catch (IOException | URISyntaxException ex) {
                    Logger.getLogger(ImageViewPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            event.setDropCompleted(success);
            event.consume();
        });
    }

    public ObjectProperty<ImageView> imageViewProperty() {
        return this.imageViewProperty;
    }

    public ImageView getImageView() {
        return (ImageView)this.imageViewProperty.get();
    }

    public void setImageView(ImageView imageView) {
        this.imageViewProperty.set((Object)imageView);
    }

    public void setImage(Image image) {
        PixelReader reader = image.getPixelReader();
        if (reader != null) {
            Color bottomRightColour;
            boolean isBig = image.getWidth() >= 5.0 || image.getHeight() >= 5.0;
            Color topLeftColour = isBig ? reader.getColor(5, 5) : reader.getColor(0, 0);
            Color topRightColour = isBig ? reader.getColor((int)image.getWidth() - 6, 5) : reader.getColor(0, 0);
            Color bottomLeftColour = isBig ? reader.getColor(5, (int)image.getHeight() - 6) : reader.getColor(0, 0);
            Color color = bottomRightColour = isBig ? reader.getColor((int)image.getWidth() - 6, (int)image.getHeight() - 6) : reader.getColor(0, 0);
            if (topLeftColour == topRightColour || bottomLeftColour == bottomRightColour) {
                this.setStyle("-fx-background-color: linear-gradient(to bottom, " + this.toRgbaCode(topLeftColour) + ", " + this.toRgbaCode(bottomRightColour) + ")");
            } else if (topLeftColour == bottomLeftColour || topRightColour == bottomRightColour) {
                this.setStyle("-fx-background-color: linear-gradient(to right, " + this.toRgbaCode(topLeftColour) + ", " + this.toRgbaCode(bottomRightColour) + ")");
            } else {
                this.setStyle("-fx-background-color: linear-gradient(to bottom right, " + this.toRgbaCode(topLeftColour) + " 0%, " + this.toRgbaCode(bottomLeftColour) + " 50%, " + this.toRgbaCode(bottomRightColour) + " 100%)");
            }
        } else {
            this.setStyle("-fx-background-color: radial-gradient(center 50% 50%, radius 80%, white 0%, white 50%, red 60%)");
        }
        this.setImage(image, true);
    }

    public void setImage(Image image, boolean preserveRatio) {
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(preserveRatio);
        imageView.setPickOnBounds(true);
        this.setImageView(imageView);
    }

    public void setDragCopyPath(String dragCopyPath) {
        this.dragCopyPath = dragCopyPath;
    }

    public void setOnDropCompleted(Delegate delegate) {
        this.onDropCompleted = delegate;
    }

    public final ObjectProperty<Tooltip> tooltipProperty() {
        if (this.tooltip == null) {
            this.tooltip = new ObjectPropertyBase<Tooltip>(){
                private Tooltip old = null;

                protected void invalidated() {
                    Tooltip t = (Tooltip)this.get();
                    if (t != this.old) {
                        if (this.old != null) {
                            Tooltip.uninstall((Node)ImageViewPane.this, (Tooltip)this.old);
                        }
                        if (t != null) {
                            Tooltip.install((Node)ImageViewPane.this, (Tooltip)t);
                        }
                        this.old = t;
                    }
                }

                public Object getBean() {
                    return ImageViewPane.this;
                }

                public String getName() {
                    return "tooltip";
                }
            };
        }
        return this.tooltip;
    }

    public final void setTooltip(Tooltip value) {
        this.tooltipProperty().setValue((Object)value);
    }

    public final Tooltip getTooltip() {
        return this.tooltip == null ? null : (Tooltip)this.tooltip.getValue();
    }

    protected void layoutChildren() {
        ImageView imageView = (ImageView)this.imageViewProperty.get();
        if (imageView != null) {
            imageView.setFitWidth(this.getWidth());
            imageView.setFitHeight(this.getHeight());
            this.layoutInArea((Node)imageView, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0, HPos.CENTER, VPos.CENTER);
        }
        super.layoutChildren();
    }

    private String toRgbaCode(Color color) {
        return String.format("rgba(%d,%d,%d,%f)", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), color.getOpacity());
    }
}

