/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.util.Duration;
import net.babelsoft.negatron.controller.DeviceController;
import net.babelsoft.negatron.controller.MachineComponentController;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.model.item.Machine;
import net.babelsoft.negatron.model.item.Software;
import net.babelsoft.negatron.model.item.SoftwareList;
import net.babelsoft.negatron.theme.Components;
import net.babelsoft.negatron.theme.Language;
import net.babelsoft.negatron.util.function.TriConsumer;
import net.babelsoft.negatron.view.control.adapter.FocusData;
import net.babelsoft.negatron.view.control.form.Control;

public class MachineConfigurationPane
extends GridPane {
    private static final Image NEW_BADGE = new Image(Components.class.getResourceAsStream("/net/babelsoft/negatron/resource/icon/device/new.png"));
    private static final Image MODIFIED_BADGE = new Image(Components.class.getResourceAsStream("/net/babelsoft/negatron/resource/icon/device/mod.png"));
    private Machine currentMachine;
    private final List<MachineComponentController<?, ?, ?>> controllers = new ArrayList();
    private final List<Label> badgedLabels = new ArrayList<Label>();
    private FocusData focusData;
    private boolean mustDoAnimation;
    private Consumer<String> onDataUpdated;
    private final Label noSettingsLabel = new Label(Language.Manager.getString("noSettings"));

    public MachineConfigurationPane() {
        this.noSettingsLabel.setAlignment(Pos.CENTER);
        this.noSettingsLabel.setMaxWidth(Double.MAX_VALUE);
    }

    private void reset() {
        this.focusData = null;
        this.controllers.stream().forEach(controller -> {
            if (this.focusData == null && controller.isFocused()) {
                this.focusData = controller.getFocusData();
            }
            controller.dispose();
        });
        this.controllers.clear();
        this.getChildren().clear();
    }

    public void setOnDataUpdated(Consumer<String> consumer) {
        this.onDataUpdated = consumer;
    }

    public void setControls(Machine newMachine, List<Control<?>> controls) {
        boolean startedFromScratch = newMachine != this.currentMachine;
        this.currentMachine = newMachine;
        this.reset();
        ArrayList keyValues1 = new ArrayList();
        ArrayList keyValues2 = new ArrayList();
        ArrayList keyValues3 = new ArrayList();
        this.mustDoAnimation = false;
        TriConsumer<Node, Double, Double> KeyValues = (node, startValue, endValue) -> {
            keyValues1.add(new KeyValue((WritableValue)node.scaleYProperty(), startValue));
            keyValues1.add(new KeyValue((WritableValue)node.opacityProperty(), startValue));
            keyValues2.add(new KeyValue((WritableValue)node.scaleYProperty(), endValue));
            keyValues2.add(new KeyValue((WritableValue)node.opacityProperty(), endValue));
            if (!this.mustDoAnimation) {
                this.mustDoAnimation = true;
            }
        };
        Consumer<Node> KeyValuesEx = node -> {
            keyValues3.add(new KeyValue((WritableValue)node.scaleYProperty(), (Object)1.0));
            keyValues3.add(new KeyValue((WritableValue)node.opacityProperty(), (Object)1.0));
        };
        controls.stream().forEachOrdered(control -> {
            Object controller = control.getController();
            Object machineComponent = ((MachineComponentController)controller).getMachineComponent();
            ((MachineComponentController)controller).setOnDataUpdated(this.onDataUpdated);
            ImageView image = Components.loadIcon(this.currentMachine, machineComponent);
            Label label = Components.loadLabel(machineComponent);
            Node node = control.getNode();
            int rowIndex = controls.indexOf(control) + 1;
            this.add((Node)image, 0, rowIndex);
            this.add((Node)label, 1, rowIndex);
            this.add(node, 2, rowIndex);
            switch (control.getStatus()) {
                case ADDED: {
                    label.setGraphic((Node)new ImageView(NEW_BADGE));
                    this.badgedLabels.add(label);
                    KeyValues.accept((Node)image, 0.0, 1.0);
                    KeyValues.accept((Node)label, 0.0, 1.0);
                    KeyValues.accept(node, 0.0, 1.0);
                    this.controllers.add((MachineComponentController<?, ?, ?>)controller);
                    break;
                }
                case DELETED: {
                    KeyValues.accept((Node)image, 1.0, 0.0);
                    KeyValues.accept((Node)label, 1.0, 0.0);
                    KeyValues.accept(node, 1.0, 0.0);
                    break;
                }
                case CHANGED: {
                    label.setGraphic((Node)new ImageView(MODIFIED_BADGE));
                    this.badgedLabels.add(label);
                    KeyValues.accept((Node)image, 1.0, 0.0);
                    KeyValues.accept((Node)label, 1.0, 0.0);
                    KeyValues.accept(node, 1.0, 0.0);
                    KeyValuesEx.accept((Node)image);
                    KeyValuesEx.accept((Node)label);
                    KeyValuesEx.accept(node);
                    this.controllers.add((MachineComponentController<?, ?, ?>)controller);
                    break;
                }
                default: {
                    if (startedFromScratch) {
                        KeyValues.accept((Node)image, 0.0, 1.0);
                        KeyValues.accept((Node)label, 0.0, 1.0);
                        KeyValues.accept(node, 0.0, 1.0);
                    }
                    this.controllers.add((MachineComponentController<?, ?, ?>)controller);
                }
            }
            ((MachineComponentController)controller).requestFocus(this.focusData);
        });
        if (this.mustDoAnimation || this.controllers.size() <= 0) {
            if (this.controllers.size() <= 0) {
                this.setAlignment(Pos.CENTER);
                this.add((Node)this.noSettingsLabel, 0, 0, 3, 1);
                KeyValues.accept((Node)this.noSettingsLabel, 0.0, 1.0);
            } else {
                this.setAlignment(Pos.TOP_LEFT);
            }
            Timeline timeline = new Timeline();
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, null, null, keyValues1));
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), null, null, keyValues2));
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)600.0), null, event -> this.getChildren().removeIf(control -> control.getScaleY() == 0.0), keyValues3));
            timeline.play();
        }
    }

    public void clearControls() {
        if (this.getChildren().size() > 0) {
            ArrayList keyValues1 = new ArrayList();
            ArrayList keyValues2 = new ArrayList();
            this.getChildren().stream().forEach(node -> {
                keyValues1.add(new KeyValue((WritableValue)node.scaleYProperty(), (Object)1.0));
                keyValues1.add(new KeyValue((WritableValue)node.opacityProperty(), (Object)1.0));
                keyValues2.add(new KeyValue((WritableValue)node.scaleYProperty(), (Object)0.0));
                keyValues2.add(new KeyValue((WritableValue)node.opacityProperty(), (Object)0.0));
            });
            Timeline timeline = new Timeline();
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, null, null, keyValues1));
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), null, null, keyValues2));
            timeline.play();
        }
    }

    public void clearBadges() {
        if (this.badgedLabels.size() > 0) {
            ArrayList keyValues1 = new ArrayList();
            ArrayList keyValues2 = new ArrayList();
            this.badgedLabels.stream().forEach(label -> {
                Node graphic = label.getGraphic();
                keyValues1.add(new KeyValue((WritableValue)graphic.scaleXProperty(), (Object)1.0));
                keyValues1.add(new KeyValue((WritableValue)graphic.opacityProperty(), (Object)1.0));
                keyValues2.add(new KeyValue((WritableValue)graphic.scaleXProperty(), (Object)0.0));
                keyValues2.add(new KeyValue((WritableValue)graphic.opacityProperty(), (Object)0.0));
            });
            Timeline timeline = new Timeline();
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, null, null, keyValues1));
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), null, event -> {
                this.badgedLabels.stream().forEach(label -> label.setGraphic(null));
                this.badgedLabels.clear();
            }, keyValues2));
            timeline.play();
        }
    }

    public List<MachineComponentController<?, ?, ?>> getControllers() {
        return this.controllers;
    }

    public void resetControllers() {
        this.controllers.stream().filter(controller -> controller instanceof DeviceController).map(controller -> (DeviceController)controller).forEach(controller -> controller.reset());
    }

    public void satisfyRequirement(Software.Requirement requirement, Map<String, SoftwareList> softwareLists) {
        String interfaceFormat;
        if (requirement == null) {
            return;
        }
        if (requirement.getSoftwareList() != null) {
            interfaceFormat = softwareLists.get(requirement.getSoftwareList()).getInterfaceFormat(requirement.getSoftware());
            if (interfaceFormat == null) {
                return;
            }
        } else {
            Optional<String> result = this.currentMachine.getSoftwareLists().stream().map(softwareListFilter -> (SoftwareList)softwareLists.get(softwareListFilter.getSoftwareList())).filter(softwareList -> softwareList != null).map(softwareList -> softwareList.getInterfaceFormat(requirement.getSoftware())).filter(interfaceFormat_ -> interfaceFormat_ != null).findAny();
            if (result.isPresent()) {
                interfaceFormat = result.get();
            } else {
                return;
            }
        }
        this.controllers.stream().filter(controller -> {
            Device device;
            Object machineComponent = controller.getMachineComponent();
            return machineComponent instanceof Device && (device = (Device)machineComponent).getInterfaceFormats().contains(interfaceFormat);
        }).findAny().ifPresent(controller -> ((DeviceController)controller).setText(requirement.getSoftware()));
    }

    public void showList(String deviceName) {
        this.controllers.stream().filter(controller -> {
            Object machineComponent = controller.getMachineComponent();
            if (machineComponent instanceof Device) {
                Device device = (Device)machineComponent;
                return deviceName.equals(device.getName());
            }
            return false;
        }).findAny().map(controller -> (DeviceController)controller).ifPresent(device -> device.showList());
    }
}

