/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import com.sun.javafx.event.EventDispatchChainImpl;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import net.babelsoft.negatron.io.Video;
import net.babelsoft.negatron.io.configuration.Configuration;
import net.babelsoft.negatron.util.Disposable;
import net.babelsoft.negatron.util.Strings;
import net.babelsoft.negatron.util.function.Delegate;
import net.babelsoft.negatron.view.control.ImageViewPane;
import uk.co.caprica.vlcj.component.DirectMediaPlayerComponent;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.TrackType;
import uk.co.caprica.vlcj.player.VideoTrackInfo;
import uk.co.caprica.vlcj.player.direct.BufferFormat;
import uk.co.caprica.vlcj.player.direct.BufferFormatCallback;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.format.RV32BufferFormat;

public class MediaViewPane
extends Region
implements Disposable {
    private static final PseudoClass CSS_PLAYING = PseudoClass.getPseudoClass((String)"playing");
    private final DirectMediaPlayerComponent mediaPlayerComponent;
    private final MediaPlayer mediaPlayer;
    private double displayAspectRatio;
    private WritableImage writableImage;
    private ImageView mediaView;
    private PixelWriter pixelWriter;
    private final ToolBar mediaButtonBar;
    private final HBox mediaBottomBar;
    private ParallelTransition mediaViewTransition;
    private FadeTransition mediaButtonBarTransition;
    private static final EventDispatchChain DUMMY_CHAIN = new EventDispatchChainImpl();
    private final List<ImageViewPane> dropTargets;
    private final Map<ImageViewPane, DragState> dragStates;
    private String dragCopyPath;
    private Delegate onDropCompleted;
    private ImageViewPane previousMouseTarget;
    private Delegate onMouseRightClick;
    private static final BooleanProperty loopEnabled = new SimpleBooleanProperty();
    private final BooleanProperty playingProperty;
    private boolean isMouseEntered;
    private boolean disabled;
    private AnchorPane background;

    public MediaViewPane() {
        this.setStyle("-fx-background-color: rgba(0,0,0,0)");
        if (Video.isEnabled()) {
            this.mediaPlayerComponent = new CanvasPlayerComponent();
            this.mediaPlayer = this.mediaPlayerComponent.getMediaPlayer();
            this.displayAspectRatio = 0.75;
            this.parentProperty().addListener((o, oV, newParent) -> {
                if (newParent != null && this.background == null) {
                    ObservableList nodes = ((StackPane)newParent).getChildren();
                    this.background = new AnchorPane();
                    this.background.setStyle("-fx-background-color: -fx-background");
                    this.background.setOpacity(0.0);
                    nodes.add(nodes.indexOf((Object)this), (Object)this.background);
                }
            });
            this.isMouseEntered = false;
            this.mediaButtonBar = new ToolBar();
            this.mediaButtonBar.getStyleClass().add((Object)"media-button-bar");
            this.mediaButtonBar.setStyle("-fx-background-color: rgba(0,0,0,0)");
            this.mediaBottomBar = new HBox();
            this.mediaBottomBar.setSpacing(0.0);
            this.mediaBottomBar.setAlignment(Pos.CENTER);
            Button backButton = new Button("Back");
            backButton.getStyleClass().add((Object)"back-button");
            backButton.setOnAction(e -> {
                if (!this.disabled && this.mediaView != null) {
                    this.showMediaView();
                    this.mediaPlayer.setTime(0L);
                    this._play();
                }
            });
            Button stopButton = new Button("Stop");
            stopButton.getStyleClass().add((Object)"stop-button");
            stopButton.setOnAction(e -> {
                if (!this.disabled) {
                    this._stop();
                    if (this.isMediaViewShown()) {
                        this.hideMediaView();
                    }
                }
            });
            Button playButton = new Button("Play");
            playButton.getStyleClass().add((Object)"play-button");
            playButton.setOnAction(e -> {
                if (!this.disabled) {
                    this._play();
                }
            });
            Button pauseButton = new Button("Pause");
            pauseButton.getStyleClass().add((Object)"pause-button");
            pauseButton.setOnAction(e -> {
                if (!this.disabled && this.mediaPlayer.isPlaying()) {
                    this.mediaPlayer.pause();
                }
            });
            Button forwardButton = new Button("Forward");
            forwardButton.getStyleClass().add((Object)"forward-button");
            forwardButton.setOnAction(e -> {
                if (!this.disabled && this.mediaView != null) {
                    long currentTime = this.mediaPlayer.getTime();
                    this.mediaPlayer.setTime(currentTime + 5000L);
                }
            });
            ToggleButton loopButton = new ToggleButton("Loop");
            loopButton.getStyleClass().add((Object)"loop-button");
            loopButton.setOnAction(e -> {
                if (!this.disabled) {
                    if (loopButton.isSelected()) {
                        this.mediaPlayer.setRepeat(true);
                    } else {
                        this.mediaPlayer.setRepeat(false);
                    }
                    loopEnabled.set(loopButton.isSelected());
                }
            });
            this.mediaBottomBar.getChildren().addAll((Object[])new Node[]{backButton, stopButton, playButton, pauseButton, forwardButton, loopButton});
            this.mediaButtonBar.getItems().add((Object)this.mediaBottomBar);
            this.mediaButtonBar.setOpacity(0.0);
            if (loopEnabled.get()) {
                loopButton.fire();
            }
            loopEnabled.addListener((o, oV, newValue) -> {
                if (newValue.booleanValue() != loopButton.isSelected()) {
                    loopButton.fire();
                }
            });
            this.setOnMouseEntered(event -> {
                if (!this.disabled && !this.isMouseEntered) {
                    this.showMediaButtonBar();
                }
            });
            this.addEventFilter(MouseEvent.MOUSE_EXITED, event -> {
                if (!this.disabled) {
                    this.hideMediaButtonBar();
                }
            });
            this.setOnTouchPressed(event -> {
                if (!this.disabled && this.mediaView != null) {
                    if (this.isMouseEntered) {
                        this.hideMediaButtonBar();
                    } else {
                        this.showMediaButtonBar();
                    }
                }
            });
        } else {
            this.mediaPlayerComponent = null;
            this.mediaPlayer = null;
            this.mediaButtonBar = null;
            this.mediaBottomBar = null;
        }
        this.playingProperty = new SimpleBooleanProperty();
        this.playingProperty.addListener((o, oV, newValue) -> this.pseudoClassStateChanged(CSS_PLAYING, (boolean)newValue));
        this.dropTargets = new ArrayList<ImageViewPane>();
        this.setOnMouseMoved(event -> {
            if (this.mediaView == null || this.mediaView.getOpacity() == 0.0) {
                this.dropTargets.stream().filter(dropTarget -> dropTarget.getBoundsInParent().contains(event.getX(), event.getY())).findAny().ifPresent(dropTarget -> {
                    if (this.previousMouseTarget != null && this.previousMouseTarget != dropTarget) {
                        MouseEvent evt = event.copyFor(event.getSource(), event.getTarget(), MouseEvent.MOUSE_EXITED);
                        this.previousMouseTarget.getEventDispatcher().dispatchEvent((Event)evt, DUMMY_CHAIN);
                    }
                    dropTarget.getEventDispatcher().dispatchEvent(event, DUMMY_CHAIN);
                    this.previousMouseTarget = dropTarget;
                });
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_EXITED, event -> {
            if (this.previousMouseTarget != null) {
                this.previousMouseTarget.getEventDispatcher().dispatchEvent(event, DUMMY_CHAIN);
                this.previousMouseTarget = null;
            }
        });
        this.setOnMousePressed(event -> this.dropTargets.stream().filter(dropTarget -> dropTarget.getBoundsInParent().contains(event.getX(), event.getY())).findAny().ifPresent(dropTarget -> dropTarget.getEventDispatcher().dispatchEvent(event, DUMMY_CHAIN)));
        this.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                this.dropTargets.stream().filter(dropTarget -> dropTarget.getBoundsInParent().contains(event.getX(), event.getY())).findAny().ifPresent(dropTarget -> dropTarget.getEventDispatcher().dispatchEvent(event, DUMMY_CHAIN));
            } else if (this.onMouseRightClick != null && event.getButton() == MouseButton.SECONDARY) {
                this.onMouseRightClick.fire();
            }
        });
        this.dragStates = new HashMap<ImageViewPane, DragState>();
        DropShadow ds = new DropShadow(10.0, Color.RED);
        Function<Dragboard, Boolean> isAcceptable = dragBoard -> Strings.isValid(this.dragCopyPath) && dragBoard.hasUrl() && dragBoard.getUrl().matches("[\\s\\S]+\\.(mp4|flv)");
        this.setOnDragEntered(event -> {
            this.dragStates.clear();
            if (((Boolean)isAcceptable.apply(event.getDragboard())).booleanValue()) {
                this.setEffect((Effect)ds);
            } else {
                this.dropTargets.forEach(dropTarget -> {
                    DragState dragState = new DragState((ImageViewPane)((Object)((Object)dropTarget)));
                    this.dragStates.put((ImageViewPane)((Object)((Object)dropTarget)), dragState);
                    if (dragState.isWithinBounds(event)) {
                        ((EventHandler)dropTarget.onDragEnteredProperty().get()).handle(event);
                        dragState.dragEntered = true;
                    }
                });
            }
            event.consume();
        });
        this.setOnDragOver(event -> {
            if (((Boolean)isAcceptable.apply(event.getDragboard())).booleanValue()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            } else {
                this.dropTargets.forEach(dropTarget -> {
                    DragState dragState = this.dragStates.get(dropTarget);
                    if (dragState.isWithinBounds(event)) {
                        ((EventHandler)dropTarget.onDragOverProperty().get()).handle(event);
                        if (!dragState.dragEntered) {
                            ((EventHandler)dropTarget.onDragEnteredProperty().get()).handle(event);
                            dragState.dragEntered = true;
                        }
                    } else if (dragState.dragEntered) {
                        ((EventHandler)dropTarget.onDragExitedProperty().get()).handle(event);
                        dragState.dragEntered = false;
                    }
                });
            }
            event.consume();
        });
        this.setOnDragExited(event -> {
            if (((Boolean)isAcceptable.apply(event.getDragboard())).booleanValue()) {
                this.setEffect(null);
            }
            this.dropTargets.forEach(dropTarget -> ((EventHandler)dropTarget.onDragExitedProperty().get()).handle(event));
            event.consume();
        });
        this.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (((Boolean)isAcceptable.apply(db)).booleanValue()) {
                try {
                    String url = db.getUrl();
                    int index = url.lastIndexOf(".");
                    String extension = url.substring(index);
                    Path targetPath = Paths.get(this.dragCopyPath + extension, new String[0]);
                    File targetDir = targetPath.getParent().toFile();
                    if (!targetDir.exists()) {
                        targetDir.mkdirs();
                    }
                    if (this.mediaPlayer.isPlaying()) {
                        this._stop();
                    }
                    Path tmpPath = extension.endsWith("mp4") ? Paths.get(this.dragCopyPath + ".flv", new String[0]) : Paths.get(this.dragCopyPath + ".mp4", new String[0]);
                    Files.deleteIfExists(tmpPath);
                    Files.copy(Paths.get(new URL(url.replace(" ", "%20")).toURI()), targetPath, StandardCopyOption.REPLACE_EXISTING);
                    if (this.onDropCompleted != null) {
                        this.onDropCompleted.fire();
                    }
                    success = true;
                }
                catch (IOException | URISyntaxException ex) {
                    Logger.getLogger(ImageViewPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                this.dropTargets.stream().filter(dropTarget -> this.dragStates.get(dropTarget).isWithinBounds(event)).forEach(dropTarget -> ((EventHandler)dropTarget.onDragDroppedProperty().get()).handle(event));
            }
            event.setDropCompleted(success);
            event.consume();
        });
    }

    @Override
    public void dispose() {
        if (this.mediaPlayerComponent != null) {
            this.mediaPlayerComponent.release(true);
        }
    }

    private void initializeImageView(int width, int height) {
        if (this.mediaView != null) {
            this.getChildren().remove((Object)this.mediaView);
        }
        this.getChildren().remove((Object)this.mediaButtonBar);
        this.writableImage = new WritableImage(width, height);
        this.pixelWriter = this.writableImage.getPixelWriter();
        this.mediaView = new ImageView((Image)this.writableImage);
        this.getChildren().addAll((Object[])new Node[]{this.mediaView, this.mediaButtonBar});
        List tracksInfo = this.mediaPlayer.getTrackInfo(new TrackType[]{TrackType.VIDEO});
        if (tracksInfo.size() > 0) {
            VideoTrackInfo trackInfo = (VideoTrackInfo)tracksInfo.get(0);
            double sampleAspectRatio = Math.max(trackInfo.sampleAspectRatio(), 1);
            double sampleAspectRatioBase = Math.max(trackInfo.sampleAspectRatioBase(), 1);
            this.displayAspectRatio = sampleAspectRatioBase * (double)height / (sampleAspectRatio * (double)width);
        }
        if (!this.isMediaViewShown()) {
            this.showMediaView();
        }
    }

    private boolean isMediaViewShown() {
        return this.mediaViewTransition != null && ((FadeTransition)this.mediaViewTransition.getChildren().get(0)).getToValue() > 0.0;
    }

    private boolean isMediaButtonBarShown() {
        return this.mediaButtonBarTransition != null && this.mediaButtonBarTransition.getToValue() > 0.0;
    }

    private void _play() {
        this.mediaPlayer.play();
        this.playingProperty.set(true);
    }

    private void _stop() {
        this.mediaPlayer.stop();
        this.playingProperty.set(false);
    }

    public void play() {
        if (this.mediaPlayer != null) {
            this._play();
        }
    }

    public void stop() {
        this.disabled = true;
        if (this.mediaPlayer != null) {
            if (this.mediaPlayer.isPlaying() || (double)this.mediaPlayer.getPosition() > 0.0) {
                this._stop();
            }
            if (this.isMediaViewShown()) {
                this.hideMediaView();
            }
            if (this.isMediaButtonBarShown()) {
                this.hideMediaButtonBar();
            }
        }
    }

    public void pause() {
        if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
        }
    }

    public BooleanProperty playingProperty() {
        return this.playingProperty;
    }

    public void setMedia(Path mediaPath) {
        this.disabled = false;
        if (this.mediaPlayer != null) {
            if (mediaPath != null) {
                this.mediaPlayer.prepareMedia(mediaPath.toString(), new String[0]);
                if (this.mediaView != null && !this.isMediaViewShown()) {
                    this.showMediaView();
                }
            } else {
                this._stop();
                if (this.mediaView != null) {
                    this.hideMediaView();
                }
                this.disabled = true;
            }
        }
    }

    public void setDragCopyPath(String dragCopyPath) {
        this.dragCopyPath = dragCopyPath;
    }

    public void setOnDropCompleted(Delegate delegate) {
        this.onDropCompleted = delegate;
    }

    public void setOnMouseRightClick(Delegate delegate) {
        this.onMouseRightClick = delegate;
    }

    public void setVolume(int volume) {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setVolume(volume);
        }
    }

    public void addDropTarget(ImageViewPane eventTargets) {
        this.dropTargets.add(eventTargets);
    }

    public void addAllDropTargets(ImageViewPane ... eventTargets) {
        Collections.addAll(this.dropTargets, eventTargets);
    }

    private void showMediaView() {
        if (this.mediaView != null) {
            if (this.mediaViewTransition != null) {
                this.mediaViewTransition.stop();
            }
            FadeTransition viewFade = new FadeTransition();
            viewFade.setNode((Node)this.mediaView);
            viewFade.setToValue(1.0);
            FadeTransition bgFade = new FadeTransition();
            bgFade.setNode((Node)this.background);
            bgFade.setToValue(0.75);
            this.mediaViewTransition = new ParallelTransition(new Animation[]{viewFade, bgFade});
            this.mediaViewTransition.setInterpolator(Interpolator.EASE_OUT);
            this.mediaViewTransition.setDelay(Duration.millis((double)200.0));
            this.mediaViewTransition.play();
        }
    }

    private void hideMediaView() {
        if (this.mediaViewTransition != null) {
            this.mediaViewTransition.stop();
        }
        FadeTransition viewFade = new FadeTransition();
        viewFade.setNode((Node)this.mediaView);
        viewFade.setToValue(0.0);
        FadeTransition bgFade = new FadeTransition();
        bgFade.setNode((Node)this.background);
        bgFade.setToValue(0.0);
        this.mediaViewTransition = new ParallelTransition(new Animation[]{viewFade, bgFade});
        this.mediaViewTransition.setInterpolator(Interpolator.EASE_OUT);
        this.mediaViewTransition.setDelay(Duration.millis((double)200.0));
        this.mediaViewTransition.setOnFinished(e -> {
            this.mediaView = null;
        });
        this.mediaViewTransition.play();
    }

    private void showMediaButtonBar() {
        if (this.mediaButtonBarTransition != null) {
            this.mediaButtonBarTransition.stop();
        }
        this.mediaButtonBarTransition = new FadeTransition(Duration.millis((double)200.0), (Node)this.mediaButtonBar);
        this.mediaButtonBarTransition.setToValue(1.0);
        this.mediaButtonBarTransition.setInterpolator(Interpolator.EASE_OUT);
        this.mediaButtonBarTransition.play();
        this.mediaButtonBar.setMouseTransparent(false);
        this.isMouseEntered = true;
    }

    private void hideMediaButtonBar() {
        if (this.isMouseEntered) {
            if (this.mediaButtonBarTransition != null) {
                this.mediaButtonBarTransition.stop();
            }
            this.mediaButtonBarTransition = new FadeTransition(Duration.millis((double)800.0), (Node)this.mediaButtonBar);
            this.mediaButtonBarTransition.setToValue(0.0);
            this.mediaButtonBarTransition.setInterpolator(Interpolator.EASE_OUT);
            this.mediaButtonBarTransition.play();
            this.mediaButtonBar.setMouseTransparent(true);
            this.isMouseEntered = false;
        }
    }

    protected void layoutChildren() {
        double width = this.getWidth();
        double height = this.getHeight();
        if (this.mediaView != null) {
            double fitHeight = this.displayAspectRatio * width;
            if (fitHeight > height) {
                this.mediaView.setFitHeight(height);
                double fitWidth = height / this.displayAspectRatio;
                this.mediaView.setFitWidth(fitWidth);
            } else {
                this.mediaView.setFitWidth(width);
                this.mediaView.setFitHeight(fitHeight);
            }
            this.layoutInArea((Node)this.mediaView, 0.0, 0.0, width, height, 0.0, HPos.CENTER, VPos.CENTER);
        }
        if (this.mediaButtonBar != null) {
            this.mediaButtonBar.resizeRelocate((width - this.mediaButtonBar.getWidth()) / 2.0, height - this.mediaButtonBar.getHeight(), width, this.mediaButtonBar.getHeight());
        }
        super.layoutChildren();
    }

    static {
        loopEnabled.set(Configuration.Manager.isLoopEnabled());
        loopEnabled.addListener((o, oV, newValue) -> {
            try {
                Configuration.Manager.updateLoopEnabled((boolean)newValue);
            }
            catch (IOException ex) {
                Logger.getLogger(MediaViewPane.class.getName()).log(Level.SEVERE, "Couldn't save loop/repeat status of media player", ex);
            }
        });
    }

    private class DragState {
        private final ReadOnlyObjectProperty<Bounds> boundsProperty;
        private boolean dragEntered;

        private DragState(ImageViewPane dropTarget) {
            this.boundsProperty = dropTarget.boundsInParentProperty();
        }

        private boolean isWithinBounds(DragEvent event) {
            return ((Bounds)this.boundsProperty.get()).contains(event.getX(), event.getY());
        }
    }

    private class CanvasBufferFormatCallback
    implements BufferFormatCallback {
        private CanvasBufferFormatCallback() {
        }

        public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
            Platform.runLater(() -> MediaViewPane.this.initializeImageView(sourceWidth, sourceHeight));
            return new RV32BufferFormat(sourceWidth, sourceHeight);
        }
    }

    private class CanvasPlayerComponent
    extends DirectMediaPlayerComponent {
        private final WritablePixelFormat<ByteBuffer> pixelFormat;

        public CanvasPlayerComponent() {
            super((BufferFormatCallback)new CanvasBufferFormatCallback());
            this.pixelFormat = PixelFormat.getByteBgraPreInstance();
        }

        public void display(DirectMediaPlayer mediaPlayer, ByteBuffer[] nativeBuffers, BufferFormat bufferFormat) {
            if (MediaViewPane.this.writableImage == null) {
                return;
            }
            Platform.runLater(() -> {
                ByteBuffer byteBuffer = nativeBuffers[0];
                MediaViewPane.this.pixelWriter.setPixels(0, 0, bufferFormat.getWidth(), bufferFormat.getHeight(), this.pixelFormat, (Buffer)byteBuffer, bufferFormat.getPitches()[0]);
            });
        }

        public void finished(MediaPlayer mediaPlayer) {
            if (!mediaPlayer.getRepeat()) {
                MediaViewPane.this._stop();
                MediaViewPane.this.hideMediaView();
            }
        }
    }
}

