/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import java.util.List;
import java.util.function.Consumer;
import javafx.fxml.Initializable;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import net.babelsoft.negatron.util.function.Delegate;

public abstract class NegatronTreeView<T>
extends TreeTableView<T>
implements Initializable {
    private Delegate onAction;
    protected TreeItem<T> selectedTreeItem;
    private Consumer<Boolean> onTreeWiseOperation;

    public NegatronTreeView() {
        KeyCodeCombination expandAllKeyCombo = new KeyCodeCombination(KeyCode.MULTIPLY, new KeyCombination.Modifier[0]);
        KeyCodeCombination collapseAllKeyCombo = new KeyCodeCombination(KeyCode.DIVIDE, new KeyCombination.Modifier[0]);
        this.addEventFilter(KeyEvent.KEY_PRESSED, arg_0 -> NegatronTreeView.lambda$new$0((KeyCombination)expandAllKeyCombo, arg_0));
        this.addEventHandler(KeyEvent.KEY_PRESSED, event -> this.handleKeyPressed((KeyEvent)event));
        this.addEventHandler(KeyEvent.KEY_RELEASED, arg_0 -> this.lambda$new$2((KeyCombination)expandAllKeyCombo, (KeyCombination)collapseAllKeyCombo, arg_0));
    }

    public void setOnAction(Delegate delegate) {
        this.onAction = delegate;
    }

    public final void setOnTreeWiseOperation(Consumer<Boolean> delegate) {
        this.onTreeWiseOperation = delegate;
    }

    public final void beginTreeWiseOperation() {
        if (this.onTreeWiseOperation != null) {
            this.onTreeWiseOperation.accept(Boolean.TRUE);
        }
        this.selectedTreeItem = (TreeItem)this.getSelectionModel().getSelectedItem();
        this.getSelectionModel().clearSelection();
    }

    public final void endTreeWiseOperation() {
        this.endTreeWiseOperation(false);
    }

    protected final void endTreeWiseOperation(boolean selectParent) {
        if (this.selectedTreeItem != null) {
            TreeItem parent;
            if (selectParent && (parent = this.selectedTreeItem.getParent()) != this.getRoot()) {
                this.selectedTreeItem = parent;
            }
            this.getSelectionModel().select(this.selectedTreeItem);
            if (this.getSelectionModel().getSelectedItem() != this.selectedTreeItem) {
                if (this.onTreeWiseOperation != null) {
                    this.onTreeWiseOperation.accept(Boolean.FALSE);
                }
                this.getSelectionModel().clearSelection();
                this.scrollTo(0);
            } else {
                this.scrollTo(this.getSelectionModel().getSelectedIndex());
            }
        }
        if (this.onTreeWiseOperation != null) {
            this.onTreeWiseOperation.accept(Boolean.FALSE);
        }
    }

    private void setAllExpanded(boolean value) {
        TreeItem root = this.getRoot();
        if (root == null) {
            return;
        }
        this.beginTreeWiseOperation();
        this.performAllExpanded((List<TreeItem<T>>)root.getChildren(), value);
        this.endTreeWiseOperation(!value);
    }

    protected abstract void performAllExpanded(List<TreeItem<T>> var1, boolean var2);

    public void expandAll() {
        this.setAllExpanded(true);
    }

    public void collapseAll() {
        this.setAllExpanded(false);
    }

    protected void handleAction() {
        if (this.onAction != null) {
            this.onAction.fire();
        }
    }

    protected void handleMouseClicked(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2) {
            this.handleAction();
            event.consume();
        }
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.handleAction();
            event.consume();
        }
    }

    private /* synthetic */ void lambda$new$2(KeyCombination expandAllKeyCombo, KeyCombination collapseAllKeyCombo, KeyEvent event) {
        if (expandAllKeyCombo.match(event)) {
            this.expandAll();
            event.consume();
        } else if (collapseAllKeyCombo.match(event)) {
            this.collapseAll();
            event.consume();
        }
    }

    private static /* synthetic */ void lambda$new$0(KeyCombination expandAllKeyCombo, KeyEvent event) {
        if (expandAllKeyCombo.match(event)) {
            event.consume();
        }
    }
}

