/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TableCell;
import javafx.util.StringConverter;
import net.babelsoft.negatron.controller.DeviceController;
import net.babelsoft.negatron.controller.SoftwareConfigurationPaneController;
import net.babelsoft.negatron.model.component.Device;
import net.babelsoft.negatron.view.control.adapter.SoftwarePartAdapter;

public class SoftwarePartChoiceCell
extends TableCell<SoftwarePartAdapter, DeviceController> {
    private static final String EMPTY = "<none>";
    private static final StringConverter<DeviceController> converter = new StringConverter<DeviceController>(){

        public String toString(DeviceController device) {
            return ((Device)device.getMachineComponent()).getName();
        }

        public DeviceController fromString(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private ChoiceBox<DeviceController> choiceBox;

    public SoftwarePartChoiceCell() {
        this.getStyleClass().add((Object)"choice-box-table-cell");
        this.textProperty().addListener((o, oV, newValue) -> {
            if (newValue == null || this.getIndex() < 0 || this.getTableView().getItems().size() <= 0) {
                return;
            }
            SoftwarePartAdapter currentAdapter = (SoftwarePartAdapter)this.getTableView().getItems().get(this.getIndex());
            String name = currentAdapter.getName();
            currentAdapter.getDevices().stream().filter(device -> !((Device)device.getMachineComponent()).getName().equals(newValue) && name.equals(device.getText())).forEach(device -> device.setText(""));
            this.getTableView().getItems().stream().filter(adapter -> adapter != currentAdapter && adapter.getAssignment() != null && ((Device)adapter.getAssignment().getMachineComponent()).getName().equals(newValue)).forEach(adapter -> adapter.setAssignment(SoftwareConfigurationPaneController.DEFAULT_DEVICE));
            this.setItem(currentAdapter.getAssignment());
        });
    }

    private String getItemText() {
        DeviceController device = (DeviceController)this.getItem();
        if (device != null) {
            return converter.toString((Object)device);
        }
        return EMPTY;
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        if (this.choiceBox == null) {
            this.choiceBox = new ChoiceBox();
            this.choiceBox.setMaxWidth(Double.MAX_VALUE);
            this.choiceBox.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
                if (!this.isEditing()) {
                    return;
                }
                this.commitEdit(newValue);
                String name = ((SoftwarePartAdapter)this.getTableView().getItems().get(this.getIndex())).getName();
                if (oldValue != null && oldValue != SoftwareConfigurationPaneController.DEFAULT_DEVICE && name.equals(oldValue.getText())) {
                    oldValue.setText("");
                }
                if (newValue != null && newValue != SoftwareConfigurationPaneController.DEFAULT_DEVICE) {
                    SoftwarePartAdapter currentAdapter = (SoftwarePartAdapter)this.getTableView().getItems().get(this.getIndex());
                    this.getTableView().getItems().stream().filter(adapter -> adapter != currentAdapter && adapter.getAssignment() == newValue).forEach(adapter -> adapter.setAssignment(SoftwareConfigurationPaneController.DEFAULT_DEVICE));
                    newValue.setText(name);
                }
            });
            this.choiceBox.setConverter(converter);
        }
        this.choiceBox.getItems().setAll(((SoftwarePartAdapter)this.getTableView().getItems().get(this.getIndex())).getDevices());
        DeviceController item = (DeviceController)this.getItem();
        if (item != null) {
            this.choiceBox.getSelectionModel().select((Object)item);
        } else {
            this.choiceBox.getSelectionModel().selectFirst();
        }
        super.startEdit();
        this.setItem(item);
        this.setText(null);
        this.setGraphic((Node)this.choiceBox);
        this.choiceBox.show();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getItemText());
        this.setGraphic(null);
    }

    public void updateItem(DeviceController item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (this.isEmpty()) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.choiceBox != null) {
                this.choiceBox.getSelectionModel().select(this.getItem());
            }
            this.setText(null);
            this.setGraphic((Node)this.choiceBox);
        } else {
            this.setText(this.getItemText());
            this.setGraphic(null);
        }
    }
}

