/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import net.babelsoft.negatron.controller.TitledWindowPaneController;
import net.babelsoft.negatron.util.function.Delegate;

public class TitledWindowPane
extends VBox {
    public static final String PROP_TEXT = "PROP_TEXT";
    public static final String PROP_GRAPHIC = "PROP_GRAPHIC";
    public static final String PROP_HEADER = "PROP_HEADER";
    public static final String PROP_CONTENT = "PROP_CONTENT";
    private String text;
    private ImageView graphic;
    private Node header;
    private Node content;
    private DisplayMode previousDisplayMode;
    private Delegate onceOnAnimationEnded;
    private boolean intermediateSize;
    private final ObjectProperty<DisplayMode> displayMode;
    private final TitledWindowPaneController controller;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);

    public TitledWindowPane() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("fxml/TitledWindowPane.fxml"));
        fxmlLoader.setRoot((Object)this);
        this.intermediateSize = true;
        try {
            fxmlLoader.load();
            this.controller = (TitledWindowPaneController)fxmlLoader.getController();
            this.propertyChangeSupport.addPropertyChangeListener(evt -> {
                switch (evt.getPropertyName()) {
                    case "PROP_TEXT": {
                        this.controller.setText(this.text);
                        break;
                    }
                    case "PROP_GRAPHIC": {
                        this.controller.setGraphic(this.graphic);
                        break;
                    }
                    case "PROP_HEADER": {
                        this.controller.setHeader(this.header);
                        break;
                    }
                    case "PROP_CONTENT": {
                        this.controller.setContent(this.content);
                    }
                }
            });
            this.previousDisplayMode = DisplayMode.HIDDEN;
            this.displayMode = new SimpleObjectProperty();
            this.displayMode.set((Object)DisplayMode.HIDDEN);
            this.controller.setControl(this);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.propertyChangeSupport.firePropertyChange(PROP_TEXT, null, text);
    }

    public ImageView getGraphic() {
        return this.graphic;
    }

    public void setGraphic(ImageView graphic) {
        this.graphic = graphic;
        this.propertyChangeSupport.firePropertyChange(PROP_GRAPHIC, null, graphic);
    }

    public Node getHeader() {
        return this.header;
    }

    public void setHeader(Node header) {
        this.header = header;
        this.propertyChangeSupport.firePropertyChange(PROP_HEADER, null, header);
    }

    public Node getContent() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content = content;
        this.propertyChangeSupport.firePropertyChange(PROP_CONTENT, null, content);
    }

    public DisplayMode getDisplayMode() {
        return (DisplayMode)((Object)this.displayMode.get());
    }

    private void setDisplayMode(DisplayMode displayMode) {
        this.previousDisplayMode = this.getDisplayMode();
        this.displayMode.set((Object)displayMode);
    }

    public ReadOnlyObjectProperty<DisplayMode> displayModeProperty() {
        return this.displayMode;
    }

    public DisplayMode getPreviousDisplayMode() {
        return this.previousDisplayMode;
    }

    public void setIntermediateSize(boolean value) {
        this.intermediateSize = value;
    }

    public boolean isIntermediateSize() {
        return this.intermediateSize;
    }

    public void setSyncWindow(TitledWindowPane window) {
        this.controller.setSyncWindow(this, window);
    }

    public void setWindowSlaves(TitledWindowPane ... windows) {
        this.controller.setWindowSlaves(windows);
    }

    public void setOnClose(Delegate delegate) {
        this.controller.setOnClose(delegate);
    }

    public void setOnceOnAnimationEnded(Delegate delegate) {
        this.onceOnAnimationEnded = delegate;
    }

    public Delegate getOnceOnAnimationEnded() {
        return this.onceOnAnimationEnded;
    }

    public void hide() {
        this.setDisplayMode(DisplayMode.HIDDEN);
    }

    public void show() {
        this.setDisplayMode(DisplayMode.INTERMEDIATE);
    }

    public void showMaximised() {
        this.setDisplayMode(DisplayMode.MAXIMISED);
    }

    public void close() {
        this.controller.close();
    }

    public static enum DisplayMode {
        NONE,
        HIDDEN,
        INTERMEDIATE,
        MAXIMISED;

    }
}

