/*
 * Decompiled with CFR 0.152.
 */
package net.babelsoft.negatron.view.control.adapter;

import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.image.Image;
import javafx.scene.layout.RowConstraints;
import net.babelsoft.negatron.io.configuration.Property;
import net.babelsoft.negatron.io.extras.Extras;
import net.babelsoft.negatron.view.control.ImageViewPane;

public class ImageGridAdapter {
    private final ImageViewPane imageViewPane;
    private final RowConstraints rowConstraints;

    public ImageGridAdapter(Image image, ReadOnlyDoubleProperty referenceWidth, double widthRatio, String name, Property property) {
        if (image != null) {
            this.imageViewPane = new ImageViewPane(image);
            this.rowConstraints = new RowConstraints();
            ChangeListener listener = (o, oV, newValue) -> this.rowConstraints.setMaxHeight(image.getHeight() * newValue.doubleValue() * widthRatio / image.getWidth());
            referenceWidth.addListener(listener);
            listener.changed(null, null, (Object)referenceWidth.get());
            if (name != null && property != null) {
                this.imageViewPane.setDragCopyPath(Extras.toPrimaryPath(name, property));
            }
        } else {
            this.imageViewPane = null;
            this.rowConstraints = null;
        }
    }

    public ImageViewPane getImageViewPane() {
        return this.imageViewPane;
    }

    public RowConstraints getRowConstraints() {
        return this.rowConstraints;
    }
}

